/*
 * Decompiled with CFR 0.152.
 */
import de.codecentric.centerdevice.MenuToolkit;
import entities.Attachments;
import entities.Feed;
import entities.Invoice;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.print.PageOrientation;
import javafx.print.Printer;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.controlsfx.control.PopOver;
import utility.Badge;
import utility.DesktopApi;
import utility.Email;
import utility.Functions;
import utility.ReadXML;
import utility.Sign;
import utility.ZoomingPane;

public class ViewMain
extends Application {
    private Color colAzzurro = Color.rgb((int)46, (int)175, (int)235);
    private Color colAzzurroTenue = Color.rgb((int)206, (int)227, (int)237);
    private Color colAzzurroScuro = Color.rgb((int)12, (int)132, (int)186);
    private static WebView webView;
    private static WebEngine engine;
    private Functions myFunctions;
    private ReadXML readXML = new ReadXML();
    private Email email;
    private Sign sign = new Sign();
    private static String applicationVersion;
    private Scene sceneMain = new Scene((Parent)new Group(), (Paint)this.colAzzurroTenue);
    private VBox vboxMain = new VBox();
    private SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat formatDateFeedRSS = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private ListView<Invoice> listViewCedentePrestatore = new ListView();
    private TextField textFilterCedentePrestatore = new TextField();
    private ListView<Invoice> listViewCessionarioCommittente = new ListView();
    private TextField textFilterCessionarioCommittente = new TextField();
    private ListView<Invoice> listViewFatture = new ListView();
    private TextField textFilterFatture = new TextField();
    private final List<Invoice> listFatture = new ArrayList<Invoice>();
    private List<File> arrayFiles = new ArrayList<File>();
    private FilteredList<Invoice> listFilterCedentePrestatore;
    private FilteredList<Invoice> listFilterCessionarioCommittente;
    private FilteredList<Invoice> listFilterFatture;
    private TabPane tabPaneYears = new TabPane();
    private TabPane tabPaneMonths = new TabPane();
    private Label lblNoInvoicesFound = new Label("(Nessuna fattura presente)");
    private Label lblNoRowsFoundCedentePrestatore = new Label("(Nessun cedente prestatore)");
    private Label lblNoRowsFoundCessionarioCommittente = new Label("(Nessun cessionario committente)");
    private FilteredList<Feed> listFilterFeed;
    private List<Feed> listFeed = new ArrayList<Feed>();
    private ListView<Feed> listViewFeed = new ListView();
    private TextField textFilterFeed = new TextField();
    private Label lblNoFeedFound = new Label("(Nessuna notizia trovata)");
    Badge _badgeNumFatture = new Badge();
    private Button btnSettings = new Button();
    private Button btnDirectory = new Button("");
    private Button btnDirectoryRefresh = new Button("");
    private Button btnStyleSheets = new Button("");
    private Button btnStyleSheetsDownload = new Button("");
    private Button btnStyleSheetsConfig = new Button("");
    private Button btnTutorial = new Button("");
    private Button btnGuide = new Button("");
    private Button btnReset = new Button("");
    private Button btnContact = new Button("");
    private Button btnCondizioniUso = new Button("");
    private Button btnAbout = new Button("");
    private Button btnExit = new Button("");
    private File directory;
    private File styleSheets;
    private static Preferences preferences;
    private static Preferences settings;
    private Label labelNomeDirectory = new Label("(Nessuna directory selezionata)");
    private Label labelNomeStyleSheets = new Label("(Nessun foglio di stile presente)");
    private PopOver popOverSettings = new PopOver();
    private PopOver popOverPrint = new PopOver();
    private PopOver popOverVerifySign = new PopOver();
    private PopOver popOverAbout = new PopOver();
    private PopOver popOverGuide = new PopOver();
    private PopOver popOverAnteprimaAllegato = new PopOver();
    private PopOver popOverCondizioniUso = new PopOver();
    private PopOver popOverConfigProxy = new PopOver();
    private VBox vboxPreview = new VBox();
    private Slider slider = new Slider(0.5, 1.5, 1.0);
    private PopOver popOverDirectory = new PopOver();
    private PopOver popOverTabYears = new PopOver();
    private PopOver popOverTabMonth = new PopOver();
    private PopOver popOverCedentePrestatore = new PopOver();
    private PopOver popOverCessionarioCommitente = new PopOver();
    private PopOver popOverContrassegnate = new PopOver();
    private PopOver popOverListFatture = new PopOver();
    private PopOver popOverButtonPrintAll = new PopOver();
    private PopOver popOverButtonDeleteFiles = new PopOver();
    private PopOver popOverButtonCompletaSemplificata = new PopOver();
    private PopOver popOverButtonOpenFolder = new PopOver();
    private PopOver popOverButtonExport = new PopOver();
    private PopOver popOverButtonPrint = new PopOver();
    private PopOver popOverButtonSignMark = new PopOver();
    private Timeline timelineDirectory;
    private Timeline timelineYears;
    private Timeline timelineMonth;
    private Timeline timelineCedentePrestatore;
    private Timeline timelineCessionarioCommitente;
    private Timeline timelineContrassegnate;
    private Timeline timelineFatture;
    private Timeline timelinePrintAll;
    private Timeline timelineDeleteFiles;
    private Timeline timelineCompletaSemplificata;
    private Timeline timelineOpenFolder;
    private Timeline timelineExport;
    private Timeline timelinePrint;
    private Timeline timelineSignMark;
    private Timeline timelineEnd;
    private HBox hboxCloseTutorial = new HBox();
    private Button closeTutorial = new Button();
    private Stage loaderStage;
    private static final int SPLASH_WIDTH = 400;
    private Font customFont = Font.loadFont((String)((Object)((Object)this)).getClass().getResource("/res/EngraversGothic.ttf").toExternalForm(), (double)16.0);
    private Pane loaderLayout;
    private Label labelProgress = new Label();
    private ProgressBar pProgress = new ProgressBar();
    private HBox hboxHeader = new HBox();
    private Font customFontMittente = Font.loadFont((String)((Object)((Object)this)).getClass().getResource("/res/EngraversGothic.ttf").toExternalForm(), (double)18.0);
    private Font customFontTitle = Font.loadFont((String)((Object)((Object)this)).getClass().getResource("/res/EngraversGothic.ttf").toExternalForm(), (double)18.0);
    private ContextMenu contextMenuApp = new ContextMenu();
    private SplitPane splitPaneContatti = new SplitPane();
    private SplitPane splitPaneMain = new SplitPane();
    private SplitPane splitPaneGlobal = new SplitPane();
    private Button btnPrint = new Button("", (Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/print.png").toString())));
    private Button btnDeleteFiles = new Button("", (Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/delete.png").toString())));
    private Stage mainStage = new Stage();
    private Label lblTitleCedentePrestatore = new Label("Cedente prestatore...");
    private Label lblNomeFileSuDisco = new Label("...");
    private Button btnOpenFolder = new Button("", (Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/more.png").toString())));
    private Button btnExportFile = new Button("", (Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/download.png").toString())));
    private Button btnPrintFile = new Button("", (Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/print.png").toString())));
    private Button btnVerifySign = new Button("", (Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/verifySign.png").toString())));
    int errorLoading = 0;
    boolean interrompiCaricamento = false;
    private WebView browserAnteprima;
    private WebEngine webEngineAnteprima;
    private ComboBox comboBoxStileFattura;
    private TextField tbProxyIndirizzoIP;
    private TextField tbProxyPorta;
    private TextField tbProxyUsername;
    private PasswordField tbProxyPassword;
    private ComboBox comboBoxContrassegnate;
    private List<String> _listFattureContrassegnate;
    private int selectedYear = 0;
    private int selectedMonth = 0;
    private boolean evitaAggiornaFattureFiltrate;
    Stage popupCondizioniUso = new Stage();

    static {
        preferences = Preferences.userRoot();
        settings = preferences.node("settings");
    }

    public ViewMain(Functions functions) {
        this.myFunctions = functions;
    }

    public static void main(String[] args) {
        ViewMain.launch((String[])args);
    }

    public void start(final Stage stage) throws Exception {
        this.myFunctions.Logga("--------------------------------------------------------------------------------");
        this.myFunctions.Logga("Inizio start ViewMain");
        this._listFattureContrassegnate = this.myFunctions.CaricaListaContrassegnateDaDisco();
        this.mainStage = stage;
        this.myFunctions.Logga("passo 1");
        this.createMenuOSX();
        this.myFunctions.Logga("passo 2");
        if (webView == null) {
            this.myFunctions.Logga("passo 2.1");
            try {
                webView = new WebView();
                this.myFunctions.Logga("passo 2.2");
            }
            catch (Exception e2) {
                this.myFunctions.Logga("Exception new WebView");
                this.myFunctions.Logga("   " + e2.toString());
                this.myFunctions.Logga("   " + e2.getMessage());
            }
        }
        this.myFunctions.Logga("passo 2.3");
        webView.getStyleClass().add((Object)"web-view-custom");
        this.myFunctions.Logga("passo 2.4");
        webView.setContextMenuEnabled(false);
        this.myFunctions.Logga("passo 2.5");
        webView.setCache(true);
        this.myFunctions.Logga("passo 2.6");
        this.btnPrint.setDisable(true);
        this.btnDeleteFiles.setDisable(true);
        this.myFunctions.Logga("passo 2.7");
        engine = webView.getEngine();
        this.myFunctions.Logga("passo 3.1");
        applicationVersion = this.myFunctions.getVersion();
        this.myFunctions.Logga("passo 3.2 [" + applicationVersion + "]");
        this.labelNomeDirectory.setMinWidth(200.0);
        this.myFunctions.Logga("passo 3.3 (prima del set font)");
        this.labelNomeDirectory.setFont(Font.font((String)"Arial", (double)12.0));
        this.myFunctions.Logga("passo 3.4 (dopo il set font)");
        this.labelNomeStyleSheets.setFont(Font.font((String)"Arial", (double)12.0));
        this.myFunctions.Logga("passo 3.5");
        this.labelNomeStyleSheets.setMinWidth(200.0);
        this.myFunctions.Logga("passo 4");
        this.lblNoRowsFoundCedentePrestatore.setFont(Font.font((String)"Arial", (FontPosture)FontPosture.ITALIC, (double)12.0));
        this.lblNoRowsFoundCessionarioCommittente.setFont(Font.font((String)"Arial", (FontPosture)FontPosture.ITALIC, (double)12.0));
        this.lblNoInvoicesFound.setFont(Font.font((String)"Arial", (FontPosture)FontPosture.ITALIC, (double)12.0));
        this.lblNoFeedFound.setFont(Font.font((String)"Arial", (FontPosture)FontPosture.ITALIC, (double)12.0));
        this.listViewCedentePrestatore.setPlaceholder((Node)this.lblNoRowsFoundCedentePrestatore);
        this.listViewCessionarioCommittente.setPlaceholder((Node)this.lblNoRowsFoundCessionarioCommittente);
        this.listViewFatture.setPlaceholder((Node)this.lblNoInvoicesFound);
        this.lblTitleCedentePrestatore.setAlignment(Pos.CENTER_LEFT);
        this.lblTitleCedentePrestatore.setFont(this.customFontMittente);
        this.lblTitleCedentePrestatore.setWrapText(true);
        this.btnOpenFolder.setDisable(true);
        this.btnExportFile.setDisable(true);
        this.btnPrintFile.setDisable(true);
        this.btnVerifySign.setDisable(true);
        this.myFunctions.Logga("passo 5");
        this.listViewFatture.getSelectionModel().selectedItemProperty().addListener((obs, ov, nv) -> {
            if (this.listViewFatture.getSelectionModel().getSelectedItem() != null) {
                this.contextMenuApp.hide();
                this.btnOpenFolder.setDisable(this.listViewFatture.getSelectionModel().getSelectedItems().size() > 1);
                this.btnExportFile.setDisable(this.listViewFatture.getSelectionModel().getSelectedItems().size() > 1);
                this.btnPrintFile.setDisable(this.listViewFatture.getSelectionModel().getSelectedItems().size() > 1);
                this.btnVerifySign.setDisable(this.listViewFatture.getSelectionModel().getSelectedItems().size() > 1);
                Invoice fattura = (Invoice)this.listViewFatture.getSelectionModel().getSelectedItem();
                if (fattura != null) {
                    this.btnVerifySign.setDisable(!fattura.getPathOriginale().toLowerCase().endsWith(".p7m") && !fattura.getPathOriginale().toLowerCase().endsWith(".tsd") && fattura.getIsX509Certificate() == false);
                    String metadatiCedentePrestatore = "";
                    String piva = fattura.getPivaCedentePrestatore().isEmpty() ? "..." : fattura.getPivaCedentePrestatore();
                    String cedentePrestatore = fattura.getCedentePrestatore().isEmpty() ? "Non impostato" : fattura.getCedentePrestatore();
                    metadatiCedentePrestatore = fattura.getPECDestinatario().isEmpty() || fattura.getPECDestinatario() == null ? " (" + piva + ")" : " (" + piva + " - " + fattura.getPECDestinatario() + ")";
                    this.lblTitleCedentePrestatore.setText(String.valueOf(cedentePrestatore) + metadatiCedentePrestatore);
                    this.lblTitleCedentePrestatore.setTooltip(new Tooltip(String.valueOf(cedentePrestatore) + metadatiCedentePrestatore));
                    this.lblNomeFileSuDisco.setText(this.myFunctions.NascondiDirDefault(fattura.getNomeFileSorgenteSuDisco()));
                    String returnFilename = this.myFunctions.applyStyleSheetsXml(new File(fattura.getPathXML()));
                    this.previewFiles(returnFilename);
                } else {
                    this.myFunctions.notifier("Attenzione", "Selezionare un documento prima di continuare!", Alert.AlertType.WARNING, 1500.0);
                }
            } else {
                this.btnOpenFolder.setDisable(true);
                this.btnExportFile.setDisable(true);
                this.btnPrintFile.setDisable(true);
                this.btnVerifySign.setDisable(true);
                this.lblTitleCedentePrestatore.setText("Cedente prestatore...");
                this.lblTitleCedentePrestatore.setTooltip(new Tooltip(""));
                this.lblNomeFileSuDisco.setText("...");
                engine.loadContent("");
            }
            this.btnPrint.setDisable(this.listViewFatture.getSelectionModel().getSelectedItems().size() <= 1);
            this.btnDeleteFiles.setDisable(this.listViewFatture.getSelectionModel().getSelectedItems().size() < 1);
        });
        this.listViewFatture.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        SimpleBooleanProperty listFattureIsEmpty = new SimpleBooleanProperty(this.listFilterFatture == null || this.listFilterFatture.size() <= 0);
        this.lblNoInvoicesFound.visibleProperty().bind((ObservableValue)listFattureIsEmpty);
        SimpleBooleanProperty listCedentePrestatoreIsEmpty = new SimpleBooleanProperty(this.listFilterCedentePrestatore == null || this.listFilterCedentePrestatore.size() <= 0);
        this.lblNoRowsFoundCedentePrestatore.visibleProperty().bind((ObservableValue)listCedentePrestatoreIsEmpty);
        SimpleBooleanProperty listCessionarioCommitente = new SimpleBooleanProperty(this.listFilterCessionarioCommittente == null || this.listFilterCessionarioCommittente.size() <= 0);
        this.lblNoRowsFoundCessionarioCommittente.visibleProperty().bind((ObservableValue)listCessionarioCommitente);
        this.myFunctions.Logga("passo 6");
        if (!settings.get("styleSheetsDefaulPath", "").isEmpty()) {
            File styleSheets = new File(settings.get("styleSheetsDefaulPath", ""));
            if (styleSheets.exists()) {
                this.myFunctions.setStyleSheetsFatt(settings.get("styleSheetsDefaulPath", ""));
                this.labelNomeStyleSheets.setText(settings.get("styleSheetsDefaulName", ""));
                this.labelNomeStyleSheets.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0));
                this.labelNomeStyleSheets.setTextFill((Paint)this.colAzzurro);
            }
        } else {
            InputStream defaultStyleSheets = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("res/fatturapa_v1.2.xsl");
            FileOutputStream outputStyleSheets = new FileOutputStream(String.valueOf(this.myFunctions.getPathTmp()) + "fatturapa_v1.2.xsl");
            try {
                int bytesRead;
                byte[] buf = new byte[1024];
                while ((bytesRead = defaultStyleSheets.read(buf)) > 0) {
                    ((OutputStream)outputStyleSheets).write(buf, 0, bytesRead);
                }
            }
            finally {
                this.myFunctions.setStyleSheetsFatt(String.valueOf(this.myFunctions.getPathTmp()) + "fatturapa_v1.2.xsl");
                settings.put("styleSheetsDefaulPath", String.valueOf(this.myFunctions.getPathTmp()) + "fatturapa_v1.2.xsl");
                settings.put("styleSheetsDefaulName", "fatturapa_v1.2.xsl");
                this.labelNomeStyleSheets.setText(settings.get("styleSheetsDefaulName", ""));
                this.labelNomeStyleSheets.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0));
                this.labelNomeStyleSheets.setTextFill((Paint)this.colAzzurro);
                defaultStyleSheets.close();
                ((OutputStream)outputStyleSheets).close();
            }
        }
        this.myFunctions.Logga("passo 7");
        if (settings.get("directoryDefault", "").isEmpty()) {
            this.myFunctions.Logga("directoryDefault isEmpty reimposta a " + this.myFunctions.getSourceFolderFromSetup(""));
            settings.put("directoryDefault", this.myFunctions.getSourceFolderFromSetup(""));
        }
        if (!settings.get("directoryDefault", "").isEmpty()) {
            this.directory = new File(settings.get("directoryDefault", ""));
            if (this.directory != null) {
                this.labelNomeDirectory.setText(settings.get("directoryDefault", ""));
                this.labelNomeDirectory.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0));
                this.labelNomeDirectory.setTextFill((Paint)this.colAzzurro);
                this.Loading();
            }
        } else {
            this.myFunctions.Logga("directoryDefault ancora isEmpty");
        }
        this.hboxHeader.setSpacing(10.0);
        this.hboxHeader.setAlignment(Pos.CENTER_LEFT);
        HBox hboxBanner = new HBox();
        hboxBanner.setAlignment(Pos.CENTER_LEFT);
        hboxBanner.setSpacing(3.0);
        this.btnSettings.getStyleClass().add((Object)"buttonMenu");
        this.btnSettings.setCursor(Cursor.HAND);
        this.btnSettings.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e2) {
                if (ViewMain.this.popOverAbout.isShowing()) {
                    ViewMain.this.popOverAbout.hide();
                }
                Label lblTitle = new Label("Impostazioni:\n\n");
                lblTitle.setTextFill((Paint)ViewMain.this.colAzzurro);
                lblTitle.setFont(ViewMain.this.customFontTitle);
                Label lblTitleDir = new Label("Seleziona la directory di lavoro:\n\n");
                lblTitleDir.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
                HBox hboxDirectory = new HBox();
                hboxDirectory.setSpacing(10.0);
                ViewMain.this.btnDirectoryRefresh.getStyleClass().add((Object)"buttonReset");
                ViewMain.this.btnDirectoryRefresh.setTooltip(new Tooltip("Aggiorna i dati visualizzati"));
                ViewMain.this.btnDirectoryRefresh.setCursor(Cursor.HAND);
                ViewMain.this.btnDirectory.getStyleClass().add((Object)"buttonSettings");
                ViewMain.this.btnDirectory.setCursor(Cursor.HAND);
                ViewMain.this.btnDirectory.setDisable(!ViewMain.this.myFunctions.getEnableSettingsFromSetup(true));
                hboxDirectory.setAlignment(Pos.CENTER_LEFT);
                ViewMain.this.labelNomeDirectory.setPrefWidth(250.0);
                ViewMain.this.labelNomeDirectory.setWrapText(true);
                hboxDirectory.getChildren().addAll((Object[])new Node[]{ViewMain.this.btnDirectoryRefresh, ViewMain.this.btnDirectory, ViewMain.this.labelNomeDirectory});
                Label lblTitleStyleSheets = new Label("Aggiornamento fogli di stile dal server:\n\n");
                lblTitleStyleSheets.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
                HBox hboxStyleSheets = new HBox();
                hboxStyleSheets.setSpacing(10.0);
                ViewMain.this.btnStyleSheets.getStyleClass().add((Object)"buttonSettings");
                ViewMain.this.btnStyleSheets.setCursor(Cursor.HAND);
                ViewMain.this.btnStyleSheetsDownload.getStyleClass().add((Object)"buttonCloud");
                ViewMain.this.btnStyleSheetsDownload.setCursor(Cursor.HAND);
                ViewMain.this.btnStyleSheetsDownload.setTooltip(new Tooltip("Aggiorna i fogli di stile dal server"));
                hboxStyleSheets.setAlignment(Pos.CENTER_LEFT);
                ViewMain.this.btnStyleSheetsConfig.getStyleClass().add((Object)"buttonConfig");
                ViewMain.this.btnStyleSheetsConfig.setTooltip(new Tooltip("Configurazione connessione Internet"));
                ViewMain.this.btnStyleSheetsConfig.setCursor(Cursor.HAND);
                ViewMain.this.btnStyleSheetsConfig.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent e2) {
                        ViewMain.this.ShowConfigProxy();
                    }
                });
                if (ViewMain.this.myFunctions.getUrlXslMyInvoice() != null || ViewMain.this.myFunctions.getUrlXslMinisteriale() != null) {
                    hboxStyleSheets.getChildren().addAll((Object[])new Node[]{ViewMain.this.btnStyleSheetsDownload, ViewMain.this.btnStyleSheetsConfig});
                }
                Label lblTutorial = new Label("Visualizza il tutorial");
                lblTutorial.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
                HBox hboxTutorial = new HBox();
                hboxTutorial.setSpacing(10.0);
                hboxTutorial.setAlignment(Pos.CENTER_RIGHT);
                ViewMain.this.btnTutorial.getStyleClass().add((Object)"buttonTutorial");
                ViewMain.this.btnTutorial.setCursor(Cursor.HAND);
                ViewMain.this.btnTutorial.setOnAction(event -> {
                    ViewMain.this.popOverSettings.hide();
                    ViewMain.this.ShowTutorial((Node)ViewMain.this.vboxMain);
                });
                hboxTutorial.getChildren().addAll((Object[])new Node[]{lblTutorial, ViewMain.this.btnTutorial});
                Label lblGuide = new Label("Legenda");
                lblGuide.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
                HBox hboxGuide = new HBox();
                hboxGuide.setSpacing(10.0);
                hboxGuide.setAlignment(Pos.CENTER_RIGHT);
                ViewMain.this.btnGuide.getStyleClass().add((Object)"buttonGuide");
                ViewMain.this.btnGuide.setCursor(Cursor.HAND);
                ViewMain.this.btnGuide.setOnAction(event -> {
                    ViewMain.this.popOverSettings.hide();
                    ViewMain.this.ShowLegends((Node)ViewMain.this.listViewFatture);
                });
                hboxGuide.getChildren().addAll((Object[])new Node[]{lblGuide, ViewMain.this.btnGuide});
                Label lblReset = new Label("Resetta impostazioni di default");
                lblReset.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
                HBox hboxReset = new HBox();
                hboxReset.setSpacing(10.0);
                hboxReset.setAlignment(Pos.CENTER_RIGHT);
                ViewMain.this.btnReset.getStyleClass().add((Object)"buttonReset");
                ViewMain.this.btnReset.setCursor(Cursor.HAND);
                ViewMain.this.btnReset.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        ViewMain.this.Reset(event);
                    }
                });
                hboxReset.getChildren().addAll((Object[])new Node[]{lblReset, ViewMain.this.btnReset});
                Label lblContact = new Label("Contattaci");
                lblContact.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
                HBox hboxContact = new HBox();
                hboxContact.setSpacing(10.0);
                hboxContact.setAlignment(Pos.CENTER_RIGHT);
                ViewMain.this.btnContact.getStyleClass().add((Object)"buttonContact");
                ViewMain.this.btnContact.setCursor(Cursor.HAND);
                ViewMain.this.btnContact.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        try {
                            DesktopApi.openMail(new URI("mailto:info@fatturazione-elettronica.online?subject=Richiesta%20informazioni%20My%20Invoice"));
                        }
                        catch (URISyntaxException e2) {
                            ViewMain.this.myFunctions.notifier("Attenzione", e2.getLocalizedMessage(), Alert.AlertType.WARNING, 2500.0);
                        }
                    }
                });
                hboxContact.getChildren().addAll((Object[])new Node[]{lblContact, ViewMain.this.btnContact});
                Label lblCondizioni = new Label("Condizioni d'uso");
                lblCondizioni.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
                HBox hboxCondizioni = new HBox();
                hboxCondizioni.setSpacing(10.0);
                hboxCondizioni.setAlignment(Pos.CENTER_RIGHT);
                ViewMain.this.btnCondizioniUso.getStyleClass().add((Object)"buttonCondizioni");
                ViewMain.this.btnCondizioniUso.setCursor(Cursor.HAND);
                ViewMain.this.btnCondizioniUso.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        ViewMain.this.ShowCondizioniUso("Versione1");
                    }
                });
                hboxCondizioni.getChildren().addAll((Object[])new Node[]{lblCondizioni, ViewMain.this.btnCondizioniUso});
                Label lblAbout = new Label("Informazioni");
                lblAbout.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
                HBox hboxAbout = new HBox();
                hboxAbout.setSpacing(10.0);
                hboxAbout.setAlignment(Pos.CENTER_RIGHT);
                ViewMain.this.btnAbout.getStyleClass().add((Object)"buttonAbout");
                ViewMain.this.btnAbout.setCursor(Cursor.HAND);
                ViewMain.this.btnAbout.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        ViewMain.this.popOverSettings.hide();
                        ViewMain.this.ShowInfoApp((Node)ViewMain.this.btnSettings);
                    }
                });
                hboxAbout.getChildren().addAll((Object[])new Node[]{lblAbout, ViewMain.this.btnAbout});
                Label lblExit = new Label("Esci");
                lblExit.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
                HBox hboxExit = new HBox();
                hboxExit.setSpacing(10.0);
                hboxExit.setAlignment(Pos.CENTER_LEFT);
                ViewMain.this.btnExit.getStyleClass().add((Object)"buttonExit");
                ViewMain.this.btnExit.setCursor(Cursor.HAND);
                ViewMain.this.btnExit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        ViewMain.this.exit((Event)event);
                    }
                });
                hboxExit.getChildren().addAll((Object[])new Node[]{ViewMain.this.btnExit, lblExit});
                VBox vboxSettings = new VBox();
                vboxSettings.setSpacing(10.0);
                vboxSettings.getChildren().addAll((Object[])new Node[]{lblTitle, lblTitleDir, hboxDirectory, lblTitleStyleSheets, hboxStyleSheets, hboxTutorial, hboxGuide, hboxContact, hboxAbout, hboxExit});
                HBox hPopOver = new HBox();
                hPopOver.setSpacing(5.0);
                hPopOver.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                hPopOver.setAlignment(Pos.CENTER_LEFT);
                hPopOver.getChildren().clear();
                hPopOver.getChildren().addAll((Collection)FXCollections.observableArrayList((Object[])new VBox[]{vboxSettings}));
                ViewMain.this.popOverSettings.setCornerRadius(5.0);
                ViewMain.this.popOverSettings.setHideOnEscape(true);
                ViewMain.this.popOverSettings.setAutoFix(true);
                ViewMain.this.popOverSettings.setDetachable(false);
                ViewMain.this.popOverSettings.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                ViewMain.this.popOverSettings.setContentNode((Node)hPopOver);
                ViewMain.this.popOverSettings.show((Node)ViewMain.this.btnSettings);
            }
        });
        ImageView imgBanner = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/loghi/banner.png").toString()));
        imgBanner.setPreserveRatio(true);
        hboxBanner.getChildren().addAll((Object[])new Node[]{this.btnSettings, imgBanner});
        this.hboxCloseTutorial.setSpacing(3.0);
        this.hboxCloseTutorial.setAlignment(Pos.CENTER_RIGHT);
        this.hboxCloseTutorial.setVisible(true);
        this.closeTutorial.getStyleClass().add((Object)"buttonCloseTutorial");
        this.closeTutorial.setCursor(Cursor.HAND);
        this.closeTutorial.setTooltip(new Tooltip("Chiudi tutorial..."));
        this.closeTutorial.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e2) {
                Platform.runLater(() -> ViewMain.this.CloseTutorial());
            }
        });
        this.hboxCloseTutorial.getChildren().add((Object)this.closeTutorial);
        VBox vboxTab = new VBox();
        HBox hboxHeaderYears = new HBox();
        this.CaricaAnniFatture();
        hboxHeaderYears.getChildren().addAll((Object[])new Node[]{this.tabPaneYears});
        HBox hboxHeaderMonth = new HBox();
        String[] months = DateFormatSymbols.getInstance(Locale.ITALY).getMonths();
        Tab tabAllMonth = new Tab();
        tabAllMonth.setClosable(false);
        tabAllMonth.setId("0");
        Label labelAllMonth = new Label("Tutti i mesi");
        labelAllMonth.setFont(this.customFontTitle);
        tabAllMonth.setGraphic((Node)labelAllMonth);
        this.tabPaneMonths.getStyleClass().add((Object)"tab-pane-month");
        this.tabPaneMonths.getTabs().add((Object)tabAllMonth);
        int i = 0;
        while (i < months.length - 1) {
            Tab tabMonth = new Tab();
            tabMonth.setClosable(false);
            tabMonth.setId(String.valueOf(i + 1));
            Label labelMonth = new Label(String.valueOf(Character.toUpperCase(months[i].charAt(0))) + months[i].substring(1));
            labelMonth.setFont(this.customFontTitle);
            tabMonth.setGraphic((Node)labelMonth);
            this.tabPaneMonths.getTabs().add((Object)tabMonth);
            ++i;
        }
        hboxHeaderMonth.getChildren().addAll((Object[])new Node[]{this.tabPaneMonths});
        vboxTab.getChildren().addAll((Object[])new Node[]{hboxHeaderYears, hboxHeaderMonth});
        this.hboxHeader.getChildren().addAll((Object[])new Node[]{hboxBanner, vboxTab});
        engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                switch (newState) {
                    case CANCELLED: 
                    case FAILED: {
                        if (engine.getLoadWorker().getException() != null) {
                            ViewMain.this.myFunctions.notifier("Attenzione", engine.getLoadWorker().getException().getLocalizedMessage(), Alert.AlertType.WARNING, 2000.0);
                        }
                        engine.loadContent("<!DOCTYPE html><html><body><br><div style='width:200px; margin:auto; align:center'><p style='text-align:center;font-family:arial;font-size:14px'>Seleziona il documento per visualizzarlo qui!</p><img style='margin:0px auto;display:block' src='" + this.getClass().getResource("res/loghi/logoPreview.png").toString() + "' alt='' height='54' width='54'>" + "</div>" + "</body>" + "</html>");
                        break;
                    }
                    case SUCCEEDED: {
                        String html = (String)engine.executeScript("document.documentElement.outerHTML");
                        if (!html.contains("Seleziona il documento per visualizzarlo qui!")) break;
                        return;
                    }
                }
            }
        });
        this.btnDirectoryRefresh.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ViewMain.this.directory = new File(settings.get("directoryDefault", ""));
                ViewMain.this.Loading();
            }
        });
        this.btnDirectory.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                DirectoryChooser fileChooser = new DirectoryChooser();
                fileChooser.setTitle("Seleziona la directory di lavoro...");
                ViewMain.this.directory = fileChooser.showDialog((Window)stage);
                if (ViewMain.this.directory != null) {
                    if (!ViewMain.this.directory.exists()) {
                        ViewMain.this.myFunctions.notifier("Attenzione", "Directory di lavoro inesistente, impossibile continuare!", Alert.AlertType.WARNING, 2500.0);
                        return;
                    }
                    ViewMain.this.Loading();
                }
            }
        });
        this.btnStyleSheetsDownload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                block15: {
                    Functions myFunctions;
                    block14: {
                        myFunctions = new Functions();
                        if (myFunctions.downloadFile(myFunctions.getUrlXslMyInvoice(), myFunctions.getPathTmp())) {
                            try {
                                int nEsitoAggiornamento;
                                String strNomeFileMyInvoice = FilenameUtils.getName(myFunctions.getUrlXslMyInvoice());
                                if (strNomeFileMyInvoice.contains(".zip")) {
                                    ZipFile zipFile = new ZipFile(String.valueOf(myFunctions.getPathTmp()) + "/" + strNomeFileMyInvoice);
                                    zipFile.extractAll(myFunctions.getPathTmp());
                                    strNomeFileMyInvoice = strNomeFileMyInvoice.replaceAll(".zip", ".xsl");
                                }
                                if ((nEsitoAggiornamento = myFunctions.VerificaAggiornamentoFoglioDiStile(myFunctions.getPathTmp(), strNomeFileMyInvoice, myFunctions.getXslMyInvoiceWork())) > 0) {
                                    myFunctions.notifier("Operazione eseguita", "Il foglio di stile MyInvoice \u00e8 stato aggiornato dal server.", Alert.AlertType.INFORMATION, 2500.0);
                                    myFunctions.deleteHtmlTmp(new File(myFunctions.getPathTmp()));
                                    break block14;
                                }
                                if (nEsitoAggiornamento < 0) {
                                    myFunctions.notifier("Operazione non eseguita", "Attenzione, non \u00e8 possibile elaborare il foglio di stile MyInvoice dal server.", Alert.AlertType.WARNING, 2500.0);
                                    break block14;
                                }
                                myFunctions.notifier("Operazione eseguita", "Il foglio di stile MyInvoice \u00e8 gi\u00e0 aggiornato.", Alert.AlertType.INFORMATION, 2500.0);
                            }
                            catch (Exception e2) {
                                myFunctions.notifier("Operazione non eseguita", "Attenzione, non \u00e8 possibile elaborare il foglio di stile MyInvoice dal server.", Alert.AlertType.WARNING, 2500.0);
                            }
                        } else {
                            myFunctions.notifier("Operazione non eseguita", "Attenzione, non \u00e8 possibile scaricare il foglio di stile MyInvoice dal server.", Alert.AlertType.WARNING, 2500.0);
                        }
                    }
                    if (myFunctions.downloadFile(myFunctions.getUrlXslMinisteriale(), myFunctions.getPathTmp())) {
                        try {
                            int nEsitoAggiornamento;
                            String strNomeFileMinisteriale = FilenameUtils.getName(myFunctions.getUrlXslMinisteriale());
                            if (strNomeFileMinisteriale.contains(".zip")) {
                                ZipFile zipFile = new ZipFile(String.valueOf(myFunctions.getPathTmp()) + "/" + strNomeFileMinisteriale);
                                zipFile.extractAll(myFunctions.getPathTmp());
                                strNomeFileMinisteriale = strNomeFileMinisteriale.replaceAll(".zip", ".xsl");
                            }
                            if ((nEsitoAggiornamento = myFunctions.VerificaAggiornamentoFoglioDiStile(myFunctions.getPathTmp(), strNomeFileMinisteriale, myFunctions.getXslMinisterialeWork())) > 0) {
                                myFunctions.notifier("Operazione eseguita", "Il foglio di stile ministeriale \u00e8 stato aggiornato dal server.", Alert.AlertType.INFORMATION, 2500.0);
                                myFunctions.deleteHtmlTmp(new File(myFunctions.getPathTmp()));
                                break block15;
                            }
                            if (nEsitoAggiornamento < 0) {
                                myFunctions.notifier("Operazione non eseguita", "Attenzione, non \u00e8 possibile elaborare il foglio di stile ministeriale dal server.", Alert.AlertType.WARNING, 2500.0);
                                break block15;
                            }
                            myFunctions.notifier("Operazione eseguita", "Il foglio di stile ministeriale \u00e8 gi\u00e0 aggiornato.", Alert.AlertType.INFORMATION, 2500.0);
                        }
                        catch (Exception e3) {
                            myFunctions.notifier("Operazione non eseguita", "Attenzione, non \u00e8 possibile elaborare il foglio di stile ministeriale dal server.", Alert.AlertType.WARNING, 2500.0);
                        }
                    } else {
                        myFunctions.notifier("Operazione non eseguita", "Attenzione, non \u00e8 possibile scaricare il foglio di stile ministeriale dal server.", Alert.AlertType.WARNING, 2500.0);
                    }
                }
                ViewMain.this.RicaricaFatturaCorrente();
            }
        });
        this.btnStyleSheets.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Seleziona il foglio di stile...");
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("XSL files (*.xsl)", new String[]{"*.xsl"}));
                ViewMain.this.styleSheets = fileChooser.showOpenDialog((Window)stage);
                if (ViewMain.this.styleSheets != null) {
                    if (!ViewMain.this.styleSheets.exists()) {
                        ViewMain.this.myFunctions.notifier("Attenzione", "Foglio di stile non corretto, impossibile continuare!", Alert.AlertType.WARNING, 2500.0);
                        return;
                    }
                    settings.put("styleSheetsDefaulPath", ViewMain.this.styleSheets.getAbsolutePath());
                    settings.put("styleSheetsDefaulName", ViewMain.this.styleSheets.getName());
                    ViewMain.this.labelNomeStyleSheets.setText(ViewMain.this.styleSheets.getName());
                    ViewMain.this.labelNomeStyleSheets.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0));
                    ViewMain.this.labelNomeStyleSheets.setTextFill((Paint)ViewMain.this.colAzzurro);
                    ViewMain.this.myFunctions.setStyleSheetsFatt(ViewMain.this.styleSheets.getAbsolutePath());
                }
            }
        });
        StackPane stackPaneContatti = new StackPane();
        stackPaneContatti.setMinWidth(290.0);
        stackPaneContatti.setMaxWidth(290.0);
        stackPaneContatti.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        VBox vboxContatti = new VBox();
        vboxContatti.setAlignment(Pos.TOP_LEFT);
        vboxContatti.getStyleClass().add((Object)"vbox-list");
        VBox vboxCedentePrestatore = new VBox();
        vboxCedentePrestatore.setSpacing(5.0);
        vboxCedentePrestatore.setAlignment(Pos.TOP_LEFT);
        vboxCedentePrestatore.getStyleClass().add((Object)"vbox-list");
        this.listViewCedentePrestatore.getStyleClass().add((Object)"list-view-cedente-prestatore-cessionario-committente");
        VBox vboxCessionarioCommittente = new VBox();
        vboxCessionarioCommittente.setSpacing(5.0);
        vboxCessionarioCommittente.setAlignment(Pos.TOP_LEFT);
        vboxCessionarioCommittente.getStyleClass().add((Object)"vbox-list");
        this.listViewCessionarioCommittente.getStyleClass().add((Object)"list-view-cedente-prestatore-cessionario-committente");
        HBox hboxFilterCedentePrestatore = new HBox();
        hboxFilterCedentePrestatore.setSpacing(10.0);
        hboxFilterCedentePrestatore.setAlignment(Pos.CENTER_LEFT);
        hboxFilterCedentePrestatore.setPadding(new Insets(15.0, 5.0, 0.0, 5.0));
        this.textFilterCedentePrestatore.getStyleClass().add((Object)"text-field-filter");
        this.textFilterCedentePrestatore.setPromptText("Cerca Cedente Prestatore...");
        Button buttonCancelFilterCedentePrestatore = new Button();
        ImageView imgCancelFilterCedentePrestatore = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/cancel.png").toString()));
        buttonCancelFilterCedentePrestatore.setGraphic((Node)imgCancelFilterCedentePrestatore);
        buttonCancelFilterCedentePrestatore.setStyle("-fx-background-color: transparent; -fx-min-width: 16px; -fx-min-height: 16px; -fx-max-width: 16px; -fx-max-height: 16px;");
        buttonCancelFilterCedentePrestatore.setDisable(true);
        buttonCancelFilterCedentePrestatore.setCursor(Cursor.HAND);
        buttonCancelFilterCedentePrestatore.setTooltip(new Tooltip("Cancella contenuto..."));
        buttonCancelFilterCedentePrestatore.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ViewMain.this.textFilterCedentePrestatore.clear();
            }
        });
        hboxFilterCedentePrestatore.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("res/search.png"))), this.textFilterCedentePrestatore, buttonCancelFilterCedentePrestatore});
        this.textFilterCedentePrestatore.textProperty().addListener(obs -> {
            if (this.listFilterCedentePrestatore == null) {
                return;
            }
            String filter = this.textFilterCedentePrestatore.getText().toUpperCase();
            if (filter == null || filter.length() == 0) {
                this.listFilterCedentePrestatore.setPredicate(s -> true);
                buttonCancelFilterCedentePrestatore.setDisable(true);
            } else {
                this.listFilterCedentePrestatore.setPredicate(i -> i.getCedentePrestatore().toUpperCase().contains(filter));
                buttonCancelFilterCedentePrestatore.setDisable(false);
            }
            if (this.listFilterCedentePrestatore.size() > 0) {
                this.listViewCedentePrestatore.getSelectionModel().select(0);
            }
        });
        HBox hboxFilterCessionarioCommitente = new HBox();
        hboxFilterCessionarioCommitente.setSpacing(10.0);
        hboxFilterCessionarioCommitente.setAlignment(Pos.CENTER_LEFT);
        hboxFilterCessionarioCommitente.setPadding(new Insets(15.0, 5.0, 0.0, 5.0));
        this.textFilterCessionarioCommittente.getStyleClass().add((Object)"text-field-filter");
        this.textFilterCessionarioCommittente.setPromptText("Cerca Cessionario Committente...");
        Button buttonCancelFilterCessionarioCommittente = new Button();
        ImageView imgCancelFilterCessionarioCommittente = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/cancel.png").toString()));
        buttonCancelFilterCessionarioCommittente.setGraphic((Node)imgCancelFilterCessionarioCommittente);
        buttonCancelFilterCessionarioCommittente.setStyle("-fx-background-color: transparent; -fx-min-width: 16px; -fx-min-height: 16px; -fx-max-width: 16px; -fx-max-height: 16px;");
        buttonCancelFilterCessionarioCommittente.setDisable(true);
        buttonCancelFilterCessionarioCommittente.setCursor(Cursor.HAND);
        buttonCancelFilterCessionarioCommittente.setTooltip(new Tooltip("Cancella contenuto..."));
        buttonCancelFilterCessionarioCommittente.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ViewMain.this.textFilterCessionarioCommittente.clear();
            }
        });
        hboxFilterCessionarioCommitente.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("res/search.png"))), this.textFilterCessionarioCommittente, buttonCancelFilterCessionarioCommittente});
        this.textFilterCessionarioCommittente.textProperty().addListener(obs -> {
            if (this.listFilterCessionarioCommittente == null) {
                return;
            }
            String filter = this.textFilterCessionarioCommittente.getText().toUpperCase();
            if (filter == null || filter.length() == 0) {
                this.listFilterCessionarioCommittente.setPredicate(s -> true);
                buttonCancelFilterCessionarioCommittente.setDisable(true);
            } else {
                this.listFilterCessionarioCommittente.setPredicate(i -> i.getCessionarioCommittente().toUpperCase().contains(filter));
                buttonCancelFilterCessionarioCommittente.setDisable(false);
            }
            if (this.listFilterCessionarioCommittente.size() > 0) {
                this.listViewCessionarioCommittente.getSelectionModel().select(0);
            }
        });
        vboxCedentePrestatore.getChildren().addAll((Object[])new Node[]{hboxFilterCedentePrestatore, this.listViewCedentePrestatore});
        VBox.setVgrow(this.listViewCedentePrestatore, (Priority)Priority.ALWAYS);
        vboxCessionarioCommittente.getChildren().addAll((Object[])new Node[]{hboxFilterCessionarioCommitente, this.listViewCessionarioCommittente});
        VBox.setVgrow(this.listViewCessionarioCommittente, (Priority)Priority.ALWAYS);
        vboxContatti.getChildren().addAll((Object[])new Node[]{vboxCedentePrestatore, vboxCessionarioCommittente});
        VBox.setVgrow((Node)vboxContatti, (Priority)Priority.ALWAYS);
        StackPane.setAlignment((Node)vboxContatti, (Pos)Pos.TOP_CENTER);
        stackPaneContatti.getChildren().addAll((Object[])new Node[]{vboxContatti});
        StackPane stackPaneFatture = new StackPane();
        stackPaneFatture.setMinWidth(290.0);
        stackPaneFatture.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        VBox vboxFatture = new VBox();
        vboxFatture.setSpacing(10.0);
        vboxFatture.setAlignment(Pos.TOP_LEFT);
        vboxFatture.getStyleClass().add((Object)"vbox-list");
        this.listViewFatture.getStyleClass().add((Object)"list-view-fatture");
        this.comboBoxContrassegnate = new ComboBox();
        this.comboBoxContrassegnate.getItems().addAll(new Object[]{"Tutte", "Solo contrassegnate", "Solo non contrassegnate"});
        this.comboBoxContrassegnate.setValue((Object)"Tutte");
        this.comboBoxContrassegnate.setMinWidth(120.0);
        this.comboBoxContrassegnate.getStyleClass().add((Object)"combo-box-print");
        this.comboBoxContrassegnate.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String t, String t1) {
                ViewMain.this.myFunctions.Logga("comboBoxContrassegnate changed");
                ViewMain.this.AggiornaFattureFiltrate();
            }
        });
        HBox hboxFilterFatture = new HBox();
        hboxFilterFatture.setSpacing(10.0);
        hboxFilterFatture.setAlignment(Pos.CENTER_LEFT);
        hboxFilterFatture.setPadding(new Insets(15.0, 5.0, 0.0, 5.0));
        this.textFilterFatture.getStyleClass().add((Object)"text-field-filter");
        this.textFilterFatture.setPromptText("Cerca...");
        Button buttonCancelFilterFatture = new Button();
        ImageView imgCancelFilterFatture = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/cancel.png").toString()));
        buttonCancelFilterFatture.setGraphic((Node)imgCancelFilterFatture);
        buttonCancelFilterFatture.setStyle("-fx-background-color: transparent; -fx-min-width: 16px; -fx-min-height: 16px; -fx-max-width: 16px; -fx-max-height: 16px;");
        buttonCancelFilterFatture.setDisable(true);
        buttonCancelFilterFatture.setCursor(Cursor.HAND);
        buttonCancelFilterFatture.setTooltip(new Tooltip("Cancella contenuto..."));
        buttonCancelFilterFatture.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ViewMain.this.textFilterFatture.clear();
                ViewMain.this.myFunctions.Logga("buttonCancelFilterFatture setOnAction");
                ViewMain.this.AggiornaFattureFiltrate();
            }
        });
        ImageView iconCessionarioCommitente = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("/res/spacer.png").toString()));
        this._badgeNumFatture.setControl((Node)iconCessionarioCommitente);
        this._badgeNumFatture.getStyleClass().add((Object)"icons-badge-all-large");
        this._badgeNumFatture.setText("0");
        this._badgeNumFatture.setPadding(new Insets(1.0, 0.0, 1.0, 0.0));
        this.btnDeleteFiles.getStyleClass().add((Object)"buttonCustom");
        this.btnDeleteFiles.setCursor(Cursor.HAND);
        this.btnDeleteFiles.setTooltip(new Tooltip("Elimina le fatture selezionate"));
        this.btnDeleteFiles.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ObservableList listFatture = ViewMain.this.listViewFatture.getSelectionModel().getSelectedItems();
                if (listFatture.toArray().length > 0) {
                    Optional<ButtonType> result;
                    String msgAlert = "Procedendo, il file della fattura selezionata verr\u00e0 DEFINITIVAMENTE eliminato.";
                    if (listFatture.toArray().length > 1) {
                        msgAlert = String.format("Procedendo, i file delle %d fatture selezionate verranno DEFINITIVAMENTE eliminati.", listFatture.toArray().length);
                    }
                    if ((result = ViewMain.this.myFunctions.alert("ATTENZIONE", msgAlert, "", ((ViewMain)ViewMain.this).myFunctions.imageViewLogo, Alert.AlertType.CONFIRMATION, true)).get() == ButtonType.OK) {
                        int i = 0;
                        while (i < listFatture.toArray().length) {
                            try {
                                String fileCanc = ((Invoice)listFatture.get(i)).getNomeFileSorgenteSuDisco();
                                ViewMain.this.myFunctions.Logga(String.format("Richiesta cancellazione file %s", fileCanc));
                                if (Files.exists(Paths.get(fileCanc, new String[0]), new LinkOption[0])) {
                                    Files.delete(Paths.get(fileCanc, new String[0]));
                                } else {
                                    ViewMain.this.myFunctions.Logga("Warning, il file da cancellare non esiste");
                                }
                            }
                            catch (Exception e2) {
                                ViewMain.this.myFunctions.Logga(String.format("CATCH: %s", e2.getMessage()));
                            }
                            ++i;
                        }
                        ViewMain.this.directory = new File(settings.get("directoryDefault", ""));
                        ViewMain.this.Loading();
                    }
                }
            }
        });
        this.btnPrint.getStyleClass().add((Object)"buttonCustom");
        this.btnPrint.setCursor(Cursor.HAND);
        this.btnPrint.setTooltip(new Tooltip("Stampa fatture le fatture selezionate"));
        this.btnPrint.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                final ArrayList files = new ArrayList();
                Task task = new Task(){

                    protected Object call() throws Exception {
                        ViewMain.this.sceneMain.setCursor(Cursor.WAIT);
                        ObservableList listFatture = ViewMain.this.listViewFatture.getSelectionModel().getSelectedItems();
                        if (listFatture.toArray().length > 1) {
                            int i = 0;
                            while (i < listFatture.toArray().length) {
                                String returnFilename = ViewMain.this.myFunctions.applyStyleSheetsXml(new File(((Invoice)listFatture.get(i)).getPathXML()));
                                files.add(returnFilename);
                                ++i;
                            }
                            ViewMain.this.sceneMain.setCursor(Cursor.DEFAULT);
                        }
                        return null;
                    }
                };
                Thread th = new Thread((Runnable)task);
                th.setDaemon(true);
                th.start();
                task.setOnSucceeded(e2 -> ViewMain.this.PrintDocument((Node)ViewMain.this.btnPrint, files));
            }
        });
        hboxFilterFatture.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("res/search.png"))), this.comboBoxContrassegnate, this.textFilterFatture, buttonCancelFilterFatture, this._badgeNumFatture, this.btnPrint, this.btnDeleteFiles});
        this.textFilterFatture.textProperty().addListener(obs -> {
            this.AggiornaFattureFiltrate();
            String filter = this.textFilterFatture.getText().toUpperCase();
            buttonCancelFilterFatture.setDisable(filter == null || filter.length() == 0);
        });
        vboxFatture.getChildren().addAll((Object[])new Node[]{hboxFilterFatture, this.listViewFatture});
        VBox.setVgrow(this.listViewFatture, (Priority)Priority.ALWAYS);
        StackPane.setAlignment((Node)vboxFatture, (Pos)Pos.TOP_CENTER);
        stackPaneFatture.getChildren().add((Object)vboxFatture);
        StackPane stackPanePreview = new StackPane();
        stackPanePreview.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        stackPanePreview.setMinWidth(500.0);
        HBox hboxContatto = new HBox();
        hboxContatto.getStyleClass().add((Object)"hbox-contatto");
        hboxContatto.setSpacing(10.0);
        hboxContatto.setAlignment(Pos.CENTER_LEFT);
        hboxContatto.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        HBox hboxComandi = new HBox();
        hboxComandi.setSpacing(10.0);
        hboxComandi.setAlignment(Pos.CENTER_RIGHT);
        hboxComandi.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        this.btnOpenFolder.getStyleClass().add((Object)"buttonCustom");
        this.btnOpenFolder.setCursor(Cursor.HAND);
        this.btnOpenFolder.setOnAction(event -> {
            Invoice fattura = (Invoice)this.listViewFatture.getSelectionModel().getSelectedItem();
            if (fattura != null) {
                try {
                    DesktopApi.browse(Paths.get(fattura.getNomeFileSorgenteSuDisco(), new String[0]).getParent().toUri());
                }
                catch (Exception exception) {}
            } else {
                this.myFunctions.notifier("Attenzione", "Selezionare un documento prima di continuare!", Alert.AlertType.WARNING, 1500.0);
            }
        });
        this.btnOpenFolder.setTooltip(new Tooltip("Apri cartella su disco..."));
        this.btnExportFile.getStyleClass().add((Object)"buttonCustom");
        this.btnExportFile.setCursor(Cursor.HAND);
        this.btnExportFile.setOnAction(event -> {
            Invoice fattura = (Invoice)this.listViewFatture.getSelectionModel().getSelectedItem();
            if (fattura != null) {
                String returnFilename = this.myFunctions.applyStyleSheetsXml(new File(fattura.getPathXML()));
                FileChooser fileChooser = new FileChooser();
                fileChooser.setInitialFileName(Paths.get(returnFilename, new String[0]).getFileName().toString());
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("HTML", new String[]{"*.html"}));
                File fileDest = fileChooser.showSaveDialog((Window)this.mainStage);
                if (fileDest != null) {
                    try {
                        FileUtils.copyFile(new File(returnFilename), fileDest);
                        this.myFunctions.notifier("Esportazione", "Esportazione avvenuta correttamente!", Alert.AlertType.NONE, 3000.0);
                    }
                    catch (Exception e2) {
                        this.myFunctions.notifier("Attenzione", "Esportazione avvenuta con errori!\nVerificare il documento o il path di destinazione", Alert.AlertType.WARNING, 3000.0);
                    }
                }
            } else {
                this.myFunctions.notifier("Attenzione", "Selezionare un documento prima di continuare!", Alert.AlertType.WARNING, 1500.0);
            }
        });
        this.btnExportFile.setTooltip(new Tooltip("Esporta singola fattura..."));
        this.btnPrintFile.getStyleClass().add((Object)"buttonCustom");
        this.btnPrintFile.setCursor(Cursor.HAND);
        this.btnPrintFile.setOnAction(event -> {
            Invoice fattura = (Invoice)this.listViewFatture.getSelectionModel().getSelectedItem();
            if (fattura != null) {
                String returnFilename = this.myFunctions.applyStyleSheetsXml(new File(fattura.getPathXML()));
                ArrayList<String> files = new ArrayList<String>();
                files.add(returnFilename);
                this.PrintDocument((Node)this.btnPrintFile, files);
            } else {
                this.myFunctions.notifier("Attenzione", "Selezionare un documento prima di continuare!", Alert.AlertType.WARNING, 1500.0);
            }
        });
        this.btnPrintFile.setTooltip(new Tooltip("Stampa singola fattura..."));
        this.btnVerifySign.getStyleClass().add((Object)"buttonCustom");
        this.btnVerifySign.setCursor(Cursor.HAND);
        this.btnVerifySign.setOnAction(event -> {
            Invoice fattura = (Invoice)this.listViewFatture.getSelectionModel().getSelectedItem();
            if (fattura != null) {
                this.VerifySignMark((Node)this.btnVerifySign, fattura.getPathOriginale());
            } else {
                this.myFunctions.notifier("Attenzione", "Selezionare un documento prima di continuare!", Alert.AlertType.WARNING, 1500.0);
            }
        });
        this.btnVerifySign.setTooltip(new Tooltip("Dati di firma"));
        hboxComandi.getChildren().addAll((Object[])new Node[]{this.btnOpenFolder, this.btnExportFile, this.btnPrintFile, this.btnVerifySign});
        final VBox vboxRagSoc = new VBox();
        vboxRagSoc.setSpacing(5.0);
        vboxRagSoc.setAlignment(Pos.CENTER);
        HBox hboxTitleCedentePrestatore = new HBox();
        hboxTitleCedentePrestatore.setSpacing(10.0);
        hboxTitleCedentePrestatore.setAlignment(Pos.CENTER);
        hboxTitleCedentePrestatore.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        ImageView imageTitleCedentePrestatore = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/titleCedentePrestatore.png").toString()));
        hboxTitleCedentePrestatore.getChildren().addAll((Object[])new Node[]{imageTitleCedentePrestatore, this.lblTitleCedentePrestatore});
        this.lblNomeFileSuDisco.setTextFill((Paint)this.colAzzurroScuro);
        vboxRagSoc.getChildren().addAll((Object[])new Node[]{hboxTitleCedentePrestatore, this.lblNomeFileSuDisco});
        this.comboBoxStileFattura = new ComboBox();
        this.comboBoxStileFattura.getItems().addAll(new Object[]{"MyInvoice", "Ministeriale"});
        this.comboBoxStileFattura.setMinWidth(130.0);
        this.comboBoxStileFattura.getStyleClass().add((Object)"combo-box-print");
        if (this.comboBoxStileFattura.getItems().contains((Object)this.myFunctions.getVisualizzazioneInUso())) {
            this.comboBoxStileFattura.setValue((Object)this.myFunctions.getVisualizzazioneInUso());
        } else {
            this.comboBoxStileFattura.setValue((Object)"MyInvoice");
        }
        this.comboBoxStileFattura.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String t, String t1) {
                ViewMain.this.myFunctions.setVisualizzazioneInUso(t1);
                if (t1.equalsIgnoreCase("ministeriale")) {
                    ViewMain.this.myFunctions.setXslInUso(ViewMain.this.myFunctions.getXslMinisterialeWork());
                    ViewMain.this.myFunctions.setStyleSheetsFatt(String.valueOf(ViewMain.this.myFunctions.getPathTmp()) + ViewMain.this.myFunctions.getXslInUso());
                    settings.put("styleSheetsDefaulPath", String.valueOf(ViewMain.this.myFunctions.getPathTmp()) + ViewMain.this.myFunctions.getXslInUso());
                    settings.put("styleSheetsDefaulName", ViewMain.this.myFunctions.getXslInUso());
                } else {
                    ViewMain.this.myFunctions.setXslInUso(ViewMain.this.myFunctions.getXslMyInvoiceWork());
                    ViewMain.this.myFunctions.setStyleSheetsFatt(String.valueOf(ViewMain.this.myFunctions.getPathTmp()) + ViewMain.this.myFunctions.getXslInUso());
                    settings.put("styleSheetsDefaulPath", String.valueOf(ViewMain.this.myFunctions.getPathTmp()) + ViewMain.this.myFunctions.getXslInUso());
                    settings.put("styleSheetsDefaulName", ViewMain.this.myFunctions.getXslInUso());
                }
                ViewMain.this.myFunctions.deleteHtmlTmp(new File(ViewMain.this.myFunctions.getPathTmp()));
                ViewMain.this.RicaricaFatturaCorrente();
            }
        });
        hboxContatto.getChildren().addAll((Object[])new Node[]{this.comboBoxStileFattura, vboxRagSoc, hboxComandi});
        engine.loadContent("<!DOCTYPE html><html><body><br><div style='width:200px; margin:auto; align:center'><p style='text-align:center;font-family:arial;font-size:14px'>Seleziona il documento per visualizzarlo qui!</p><img style='margin:0px auto;display:block' src='" + ((Object)((Object)this)).getClass().getResource("res/loghi/logoPreview.png").toString() + "' alt='' height='54' width='54'>" + "</div>" + "</body>" + "</html>");
        Label labelZoomPercentage = new Label("Zoom: 100%");
        labelZoomPercentage.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
        ZoomingPane zoomingPane = new ZoomingPane((Node)webView, labelZoomPercentage);
        HBox hboxUtilitySlider = new HBox();
        hboxUtilitySlider.setSpacing(4.0);
        hboxUtilitySlider.setAlignment(Pos.CENTER);
        ImageView imageZoom = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/zoom.png").toString()));
        imageZoom.setViewport(new Rectangle2D(0.0, -3.0, 16.0, 20.0));
        this.slider.setTooltip(new Tooltip("Zoom In / Zoom Out"));
        this.slider.setCursor(Cursor.HAND);
        zoomingPane.zoomFactorProperty().bind((ObservableValue)this.slider.valueProperty());
        Button btnZoomActualSize = new Button("", (Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/actualSize.png").toString())));
        btnZoomActualSize.getStyleClass().add((Object)"buttonCustom");
        btnZoomActualSize.setCursor(Cursor.HAND);
        btnZoomActualSize.setOnAction(event -> this.slider.setValue(1.0));
        btnZoomActualSize.setTooltip(new Tooltip("Dimensioni originali..."));
        hboxUtilitySlider.getChildren().addAll((Object[])new Node[]{imageZoom, this.slider, btnZoomActualSize});
        this.vboxPreview.setPrefWidth(500.0);
        this.vboxPreview.setPrefHeight(600.0);
        this.vboxPreview.setAlignment(Pos.CENTER);
        this.vboxPreview.getStyleClass().add((Object)"vbox-list");
        this.vboxPreview.setPadding(new Insets(15.0, 0.0, 10.0, 0.0));
        this.vboxPreview.getChildren().addAll((Object[])new Node[]{hboxContatto, zoomingPane, hboxUtilitySlider, labelZoomPercentage});
        VBox.setVgrow((Node)zoomingPane, (Priority)Priority.ALWAYS);
        StackPane.setAlignment((Node)vboxFatture, (Pos)Pos.TOP_CENTER);
        stackPanePreview.getChildren().add((Object)this.vboxPreview);
        HBox hboxFilterFeed = new HBox();
        hboxFilterFeed.setSpacing(10.0);
        hboxFilterFeed.setAlignment(Pos.CENTER_LEFT);
        hboxFilterFeed.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        this.textFilterFeed.getStyleClass().add((Object)"text-field-filter");
        this.textFilterFeed.setPromptText("Cerca...");
        Button buttonCancelFilterFeed = new Button();
        ImageView imgCancelFilterFeed = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/cancel.png").toString()));
        buttonCancelFilterFeed.setGraphic((Node)imgCancelFilterFeed);
        buttonCancelFilterFeed.setStyle("-fx-background-color: transparent; -fx-min-width: 16px; -fx-min-height: 16px; -fx-max-width: 16px; -fx-max-height: 16px;");
        buttonCancelFilterFeed.setDisable(true);
        buttonCancelFilterFeed.setCursor(Cursor.HAND);
        buttonCancelFilterFeed.setTooltip(new Tooltip("Cancella contenuto..."));
        buttonCancelFilterFeed.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ViewMain.this.textFilterFeed.clear();
            }
        });
        Button buttonRefreshFeed = new Button();
        ImageView imgRefreshFilterFeed = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/refresh.png").toString()));
        buttonRefreshFeed.setGraphic((Node)imgRefreshFilterFeed);
        buttonRefreshFeed.getStyleClass().add((Object)"buttonCustom");
        buttonRefreshFeed.setTooltip(new Tooltip("Ricarica..."));
        buttonRefreshFeed.setCursor(Cursor.HAND);
        buttonRefreshFeed.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ViewMain.this.LoadFeed();
            }
        });
        hboxFilterFeed.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("res/search.png"))), this.textFilterFeed, buttonCancelFilterFeed, buttonRefreshFeed});
        this.textFilterFeed.textProperty().addListener(obs -> {
            if (this.listFilterFeed == null) {
                return;
            }
            String filter = this.textFilterFeed.getText().toUpperCase();
            if (filter == null || filter.length() == 0) {
                this.listFilterFeed.setPredicate(s -> true);
                buttonCancelFilterFeed.setDisable(true);
            } else {
                buttonCancelFilterFeed.setDisable(false);
                this.listFilterFeed.setPredicate(i -> i.getTitle().toUpperCase().contains(filter) || this.formatDate.format(i.getPubDate()).toUpperCase().contains(filter) || i.getAuthor().contains(filter));
            }
            if (this.listFilterFeed.size() > 0) {
                this.listViewFeed.getSelectionModel().clearSelection();
                this.listViewFeed.scrollTo(0);
                this.listViewFeed.getSelectionModel().select(0);
            }
        });
        StackPane stackPaneFeed = new StackPane();
        stackPaneFeed.setMaxHeight(400.0);
        stackPaneFeed.setMinHeight(150.0);
        stackPaneFeed.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        VBox vboxFeed = new VBox();
        vboxFeed.setSpacing(10.0);
        vboxFeed.setAlignment(Pos.TOP_LEFT);
        vboxFeed.getStyleClass().add((Object)"vbox-list");
        this.listViewFeed.getStyleClass().add((Object)"list-view-fatture");
        this.LoadFeed();
        this.listViewFeed.setCellFactory((Callback)new Callback<ListView<Feed>, ListCell<Feed>>(){

            public ListCell<Feed> call(ListView<Feed> param) {
                ListCell<Feed> cell = new ListCell<Feed>(){

                    protected void updateItem(final Feed item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    if (event.getClickCount() > 1) {
                                        try {
                                            DesktopApi.browse(new URI(item.getLink()));
                                        }
                                        catch (URISyntaxException e2) {
                                            ViewMain.this.myFunctions.notifier("Attenzione", "Impossibile aprire il link selezionato!", Alert.AlertType.WARNING, 2500.0);
                                        }
                                    }
                                }
                            });
                            VBox vboxFeed = new VBox();
                            vboxFeed.setSpacing(5.0);
                            vboxFeed.setAlignment(Pos.CENTER);
                            GridPane gridFeed = new GridPane();
                            gridFeed.setPadding(new Insets(5.0, 5.0, 5.0, 0.0));
                            ImageView iconRss = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("/res/rss.png").toString()));
                            GridPane.setMargin((Node)iconRss, (Insets)new Insets(0.0, 0.0, 5.0, 5.0));
                            gridFeed.add((Node)iconRss, 0, 0);
                            HBox hboxTitle = new HBox();
                            hboxTitle.setSpacing(5.0);
                            hboxTitle.setAlignment(Pos.CENTER_LEFT);
                            Text tTitle = new Text(item.getTitle());
                            tTitle.setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                            hboxTitle.getChildren().addAll((Object[])new Node[]{tTitle});
                            GridPane.setMargin((Node)hboxTitle, (Insets)new Insets(0.0, 0.0, 5.0, 5.0));
                            gridFeed.add((Node)hboxTitle, 1, 0);
                            HBox hboxAuthor = new HBox();
                            hboxAuthor.setSpacing(5.0);
                            hboxAuthor.setAlignment(Pos.CENTER_LEFT);
                            ImageView iconAuthor = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("/res/author.png").toString()));
                            Text tAuthor = new Text(item.getAuthor());
                            tAuthor.setFill((Paint)Color.rgb((int)12, (int)132, (int)186));
                            tAuthor.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
                            Text tDate = new Text("(" + ViewMain.this.formatDateFeedRSS.format(item.getPubDate()) + ")");
                            tDate.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
                            Button buttonPreview = new Button("", (Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResource("/res/preview.png").toString())));
                            buttonPreview.getStyleClass().add((Object)"buttonCustom");
                            buttonPreview.setTooltip(new Tooltip("Apri il link..."));
                            buttonPreview.setCursor(Cursor.HAND);
                            buttonPreview.setOnAction(event -> {
                                try {
                                    DesktopApi.browse(new URI(item.getLink()));
                                }
                                catch (URISyntaxException e2) {
                                    ViewMain.this.myFunctions.notifier("Attenzione", "Impossibile aprire il link selezionato!", Alert.AlertType.WARNING, 2500.0);
                                }
                            });
                            hboxAuthor.getChildren().addAll((Object[])new Node[]{iconAuthor, tAuthor, tDate, buttonPreview});
                            GridPane.setMargin((Node)hboxAuthor, (Insets)new Insets(0.0, 0.0, 5.0, 5.0));
                            gridFeed.add((Node)hboxAuthor, 1, 1);
                            vboxFeed.getChildren().addAll((Object[])new Node[]{gridFeed});
                            vboxFeed.setOpacity(0.0);
                            FadeTransition f2 = new FadeTransition();
                            f2.setDuration(Duration.millis((double)500.0));
                            f2.setFromValue(0.0);
                            f2.setToValue(1.0);
                            f2.setNode((Node)vboxFeed);
                            f2.play();
                            this.setGraphic((Node)vboxFeed);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                return cell;
            }
        });
        Label lblTitleNews = new Label("Ultime notizie (fatturazione-elettronica.online):");
        lblTitleNews.setPadding(new Insets(10.0, 0.0, 0.0, 10.0));
        lblTitleNews.setFont(this.customFontTitle);
        vboxFeed.getChildren().addAll((Object[])new Node[]{lblTitleNews, hboxFilterFeed, this.listViewFeed});
        VBox.setVgrow(this.listViewFeed, (Priority)Priority.ALWAYS);
        StackPane.setAlignment((Node)vboxFeed, (Pos)Pos.TOP_CENTER);
        stackPaneFeed.getChildren().add((Object)vboxFeed);
        this.splitPaneMain.setOrientation(Orientation.VERTICAL);
        this.splitPaneContatti.setOrientation(Orientation.HORIZONTAL);
        this.splitPaneContatti.getItems().addAll((Object[])new Node[]{stackPaneContatti, stackPaneFatture});
        this.splitPaneMain.getItems().addAll((Object[])new Node[]{this.splitPaneContatti, stackPaneFeed});
        this.splitPaneGlobal.setOrientation(Orientation.HORIZONTAL);
        this.splitPaneGlobal.getItems().addAll((Object[])new Node[]{this.splitPaneMain, stackPanePreview});
        this.vboxMain.setSpacing(5.0);
        this.vboxMain.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        this.vboxMain.getChildren().addAll((Object[])new Node[]{this.hboxHeader, this.splitPaneGlobal});
        VBox.setVgrow((Node)this.splitPaneGlobal, (Priority)Priority.ALWAYS);
        this.vboxMain.requestLayout();
        stage.setOnCloseRequest(event -> this.exit(event));
        this.contextMenuApp.setAutoHide(true);
        MenuItem mnuInfo = new MenuItem("Informazioni");
        this.contextMenuApp.getItems().add((Object)mnuInfo);
        mnuInfo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ViewMain.this.ShowInfoApp((Node)ViewMain.this.btnSettings);
            }
        });
        MenuItem mnuTutorial = new MenuItem("Visualizza tutorial");
        this.contextMenuApp.getItems().add((Object)mnuTutorial);
        mnuTutorial.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ViewMain.this.ShowTutorial((Node)ViewMain.this.vboxMain);
            }
        });
        SeparatorMenuItem mnuSeparator4 = new SeparatorMenuItem();
        this.contextMenuApp.getItems().add((Object)mnuSeparator4);
        MenuItem mnuReset = new MenuItem("Resetta impostazioni di default");
        this.contextMenuApp.getItems().add((Object)mnuReset);
        mnuReset.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ViewMain.this.Reset(event);
            }
        });
        SeparatorMenuItem mnuSeparator6 = new SeparatorMenuItem();
        this.contextMenuApp.getItems().add((Object)mnuSeparator6);
        MenuItem mnuChiudi = new MenuItem("Chiudi");
        this.contextMenuApp.getItems().add((Object)mnuChiudi);
        mnuChiudi.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ViewMain.this.exit((Event)event);
            }
        });
        this.listViewCedentePrestatore.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (t.getButton() == MouseButton.SECONDARY && !ViewMain.this.tabPaneYears.isDisable()) {
                    ViewMain.this.contextMenuApp.show((Node)ViewMain.this.listViewCedentePrestatore, t.getScreenX(), t.getScreenY());
                }
            }
        });
        this.listViewCessionarioCommittente.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (t.getButton() == MouseButton.SECONDARY && !ViewMain.this.tabPaneYears.isDisable()) {
                    ViewMain.this.contextMenuApp.show((Node)ViewMain.this.listViewCessionarioCommittente, t.getScreenX(), t.getScreenY());
                }
            }
        });
        this.listViewFatture.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (t.getButton() == MouseButton.SECONDARY && !ViewMain.this.tabPaneYears.isDisable()) {
                    ViewMain.this.contextMenuApp.show((Node)ViewMain.this.listViewFatture, t.getScreenX(), t.getScreenY());
                }
            }
        });
        this.splitPaneMain.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (t.getButton() == MouseButton.SECONDARY) {
                    if (!ViewMain.this.tabPaneYears.isDisable()) {
                        ViewMain.this.contextMenuApp.show((Node)ViewMain.this.splitPaneMain, t.getScreenX(), t.getScreenY());
                    }
                } else {
                    ViewMain.this.contextMenuApp.hide();
                }
            }
        });
        this.vboxMain.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (t.getButton() == MouseButton.SECONDARY) {
                    if (!ViewMain.this.tabPaneYears.isDisable()) {
                        ViewMain.this.contextMenuApp.show((Node)ViewMain.this.vboxMain, t.getScreenX(), t.getScreenY());
                    }
                } else {
                    ViewMain.this.contextMenuApp.hide();
                }
            }
        });
        this.contextMenuApp.getStyleClass().add((Object)"context-menu-vbox");
        this.vboxMain.getStyleClass().add((Object)"vboxCustom");
        ((Group)this.sceneMain.getRoot()).getChildren().addAll((Object[])new Node[]{this.vboxMain});
        this.tabPaneYears.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> arg0, Tab arg1, Tab mostRecentlySelectedTab) {
                ViewMain.this.myFunctions.Logga("tabPaneYears changed");
                ViewMain.this.AggiornaFattureFiltrate();
            }
        });
        this.tabPaneMonths.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> arg0, Tab arg1, Tab mostRecentlySelectedTab) {
                ViewMain.this.myFunctions.Logga("tabPaneMonths changed");
                ViewMain.this.AggiornaFattureFiltrate();
            }
        });
        ((MultipleSelectionModel)this.listViewCedentePrestatore.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)new ChangeListener<Invoice>(){

            public void changed(ObservableValue<? extends Invoice> observable, Invoice oldValue, Invoice newValue) {
                ViewMain.this.myFunctions.Logga("listViewCedentePrestatore changed");
                ViewMain.this.AggiornaFattureFiltrate();
            }
        });
        ((MultipleSelectionModel)this.listViewCessionarioCommittente.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)new ChangeListener<Invoice>(){

            public void changed(ObservableValue<? extends Invoice> observable, Invoice oldValue, Invoice newValue) {
                ViewMain.this.myFunctions.Logga("listViewCessionarioCommittente changed");
                ViewMain.this.AggiornaFattureFiltrate();
            }
        });
        this.sceneMain.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneWidth, Number newSceneWidth) {
                ViewMain.this.splitPaneGlobal.setPrefWidth((Double)newSceneWidth - ViewMain.this.splitPaneGlobal.getLayoutX() * 2.0);
                ViewMain.this.splitPaneGlobal.setDividerPositions(new double[]{0.48f, 0.52f});
                ViewMain.this.splitPaneContatti.setDividerPositions(new double[]{0.1f, 0.9f});
                ViewMain.this.splitPaneMain.setDividerPositions(new double[]{0.7f, 0.3f});
                ViewMain.this.textFilterCedentePrestatore.setPrefWidth(((Double)newSceneWidth).doubleValue());
                ViewMain.this.textFilterCessionarioCommittente.setPrefWidth(((Double)newSceneWidth).doubleValue());
                ViewMain.this.textFilterFatture.setPrefWidth(((Double)newSceneWidth).doubleValue());
                ViewMain.this.textFilterFeed.setPrefWidth(((Double)newSceneWidth).doubleValue());
                ViewMain.this.hboxCloseTutorial.setPrefWidth(((Double)newSceneWidth).doubleValue());
                vboxRagSoc.setPrefWidth(((Double)newSceneWidth).doubleValue());
                ViewMain.this.vboxMain.setPrefWidth(((Double)newSceneWidth).doubleValue());
            }
        });
        this.sceneMain.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneHeight, Number newSceneHeight) {
                ViewMain.this.splitPaneGlobal.setPrefHeight((Double)newSceneHeight - ViewMain.this.splitPaneGlobal.getLayoutY());
                ViewMain.this.splitPaneContatti.setDividerPositions(new double[]{0.1f, 0.9f});
                ViewMain.this.splitPaneMain.setDividerPositions(new double[]{0.7f, 0.3f});
            }
        });
        this.sceneMain.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("res/ControlStyle.css").toExternalForm());
        stage.setScene(this.sceneMain);
        stage.addEventHandler(WindowEvent.WINDOW_SHOWN, (EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent window) {
                if (settings.get("tutorial", "").isEmpty()) {
                    ViewMain.this.ShowTutorial((Node)ViewMain.this.vboxMain);
                    settings.put("tutorial", "1");
                }
            }
        });
        stage.sizeToScene();
        stage.setMaximized(true);
        this.myFunctions.Logga("Prima show ViewMain");
        stage.show();
        this.myFunctions.Logga("Dopo show ViewMain");
        this.myFunctions.Logga("Fine start ViewMain");
        this.myFunctions.Logga("--------------------------------------------------------------------------------");
    }

    private void AggiornaFattureFiltrate() {
        if (!this.evitaAggiornaFattureFiltrate) {
            this.myFunctions.Logga("Inizio AggiornaFattureFiltrate");
            if (this.listFilterFatture == null) {
                return;
            }
            String filter = this.textFilterFatture.getText().toUpperCase();
            Invoice cedentePrestatore = (Invoice)this.listViewCedentePrestatore.getSelectionModel().getSelectedItem();
            Invoice cessionarioCommittente = (Invoice)this.listViewCessionarioCommittente.getSelectionModel().getSelectedItem();
            this.selectedYear = 0;
            if (this.tabPaneYears.getSelectionModel().getSelectedItem() != null) {
                this.selectedYear = Integer.valueOf(((Tab)this.tabPaneYears.getSelectionModel().getSelectedItem()).getId());
            }
            this.selectedMonth = 0;
            if (this.tabPaneMonths.getSelectionModel().getSelectedItem() != null) {
                this.selectedMonth = Integer.valueOf(((Tab)this.tabPaneMonths.getSelectionModel().getSelectedItem()).getId());
            }
            this.listFilterFatture.setPredicate(i -> !(!this.comboBoxContrassegnate.getValue().equals("Tutte") && (!this.comboBoxContrassegnate.getValue().equals("Solo contrassegnate") || i.getIsContrassegnata() == false) && (!this.comboBoxContrassegnate.getValue().equals("Solo non contrassegnate") || i.getIsContrassegnata() != false) || !i.getCedentePrestatore().toUpperCase().contains(filter) && !i.getCessionarioCommittente().toUpperCase().contains(filter) && !i.getNumero().toUpperCase().contains(filter) && !this.formatDate.format(i.getDataFattura()).toUpperCase().contains(filter) && !i.getTipoDocumento().contains(filter) || cedentePrestatore != null && !cedentePrestatore.getPivaCedentePrestatore().equals("0") && !i.getPivaCedentePrestatore().equals(cedentePrestatore.getPivaCedentePrestatore()) || cessionarioCommittente != null && !cessionarioCommittente.getPivaCFCessionarioCommittente().equals("0") && !i.getPivaCFCessionarioCommittente().equals(cessionarioCommittente.getPivaCFCessionarioCommittente()) || this.selectedYear != 0 && this.myFunctions.getCalendarFromDate(i.getDataFattura(), 1) != this.selectedYear || this.selectedMonth != 0 && this.myFunctions.getCalendarFromDate(i.getDataFattura(), 2) + 1 != this.selectedMonth));
            if (this.listFilterFatture.size() > 0) {
                this.listViewFatture.getSelectionModel().select(0);
            }
            this._badgeNumFatture.setText(String.valueOf(this.listFilterFatture.size()));
            this.myFunctions.Logga("Fine AggiornaFattureFiltrate");
        }
    }

    private void LoadFeed() {
        this.listViewFeed.setPlaceholder((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/loadingFeed.gif").toString())));
        Task<Boolean> taskFeed = new Task<Boolean>(){

            public Boolean call() throws Exception {
                ViewMain.this.listFeed.clear();
                ReadXML readRSSFeed = new ReadXML("https://fatturazione-elettronica.arxivar.it/news?format=feed&type=rss");
                try {
                    List<Feed> feeds = readRSSFeed.readFeed();
                    ViewMain.this.listFeed.addAll(feeds);
                }
                catch (Exception e2) {
                    ViewMain.this.listFilterFeed = new FilteredList(FXCollections.observableList((List)ViewMain.this.listFeed), FeedMessage -> true);
                }
                return true;
            }
        };
        taskFeed.setOnSucceeded(e2 -> {
            this.listViewFeed.setPlaceholder((Node)this.lblNoFeedFound);
            this.listFilterFeed = new FilteredList(FXCollections.observableList(this.listFeed), FeedMessage -> true);
            this.listViewFeed.setItems(this.listFilterFeed);
        });
        Thread th = new Thread((Runnable)taskFeed);
        th.setDaemon(true);
        th.start();
    }

    private void BuildListView() {
        Map<String, List<Invoice>> mapListCedentiPrestatori = this.listFatture.stream().collect(Collectors.groupingBy(Invoice::getPivaCedentePrestatore));
        ArrayList<Invoice> tmpList = new ArrayList<Invoice>(mapListCedentiPrestatori.size());
        if (this.listFatture.size() > 0) {
            tmpList.add(new Invoice("0", " \u2022 Tutti i Cedenti Prestatori \u2022 ", "", "", "", new Date(), "", "", "", 0, false, false, "", "", new ArrayList<Attachments>()));
        }
        for (Map.Entry<String, List<Invoice>> entry : mapListCedentiPrestatori.entrySet()) {
            if (entry.getValue().get(0).getCedentePrestatore().isEmpty()) continue;
            tmpList.add(entry.getValue().get(0));
        }
        Comparator<Invoice> comparator_byCedentePrestatore = new Comparator<Invoice>(){

            @Override
            public int compare(Invoice o1, Invoice o2) {
                return o1.getCedentePrestatore().compareToIgnoreCase(o2.getCedentePrestatore());
            }
        };
        this.listFilterCedentePrestatore = new FilteredList((ObservableList)FXCollections.observableList(tmpList).sorted((Comparator)comparator_byCedentePrestatore), invoice -> true);
        this.listViewCedentePrestatore.setItems(this.listFilterCedentePrestatore);
        this.listViewCedentePrestatore.setCellFactory((Callback)new Callback<ListView<Invoice>, ListCell<Invoice>>(){

            public ListCell<Invoice> call(ListView<Invoice> param) {
                ListCell<Invoice> cell = new ListCell<Invoice>(){

                    protected void updateItem(Invoice item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            FilteredList filteredData = new FilteredList(FXCollections.observableList((List)ViewMain.this.listFatture), invoice -> true);
                            if (!item.getPivaCedentePrestatore().equals("0")) {
                                filteredData.setPredicate(s -> s.getPivaCedentePrestatore().equals(item.getPivaCedentePrestatore()));
                            }
                            HBox hboxCedentePrestatore = new HBox();
                            hboxCedentePrestatore.setSpacing(5.0);
                            hboxCedentePrestatore.setAlignment(Pos.CENTER_LEFT);
                            HBox hboxIconBadge = new HBox();
                            hboxIconBadge.setSpacing(5.0);
                            ImageView iconCedentePrestatore = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("/res/user.png").toString()));
                            if (item.getPivaCedentePrestatore().equals("0")) {
                                iconCedentePrestatore.setImage(new Image(((Object)((Object)this)).getClass().getResource("/res/userAll.png").toString()));
                            }
                            Badge badge = new Badge();
                            badge.setControl((Node)iconCedentePrestatore);
                            if (item.getPivaCedentePrestatore().equals("0")) {
                                if (filteredData.size() < 1000) {
                                    badge.getStyleClass().add((Object)"icons-badge-all");
                                } else if (filteredData.size() <= 9999) {
                                    badge.getStyleClass().add((Object)"icons-badge-all-large");
                                } else {
                                    badge.getStyleClass().add((Object)"icons-badge-all-xlarge");
                                }
                            } else if (filteredData.size() < 1000) {
                                badge.getStyleClass().add((Object)"icons-badge");
                            } else if (filteredData.size() <= 9999) {
                                badge.getStyleClass().add((Object)"icons-badge-large");
                            } else {
                                badge.getStyleClass().add((Object)"icons-badge-xlarge");
                            }
                            badge.setText(String.valueOf(filteredData.size()));
                            if (filteredData.size() > 0) {
                                hboxIconBadge.getChildren().add((Object)badge);
                            }
                            Label labelCedentePrestatore = new Label(item.getCedentePrestatore());
                            if (item.getPivaCedentePrestatore().equals("0")) {
                                labelCedentePrestatore.getStyleClass().add((Object)"labelUsers");
                                labelCedentePrestatore.setTextAlignment(TextAlignment.CENTER);
                            }
                            hboxCedentePrestatore.getChildren().addAll((Object[])new Node[]{iconCedentePrestatore, hboxIconBadge, labelCedentePrestatore});
                            this.setGraphic((Node)hboxCedentePrestatore);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                return cell;
            }
        });
        Map<String, List<Invoice>> mapListCessionariCommitenti = this.listFatture.stream().collect(Collectors.groupingBy(Invoice::getPivaCFCessionarioCommittente));
        ArrayList<Invoice> tmpListCessionariCommitenti = new ArrayList<Invoice>(mapListCessionariCommitenti.size());
        if (this.listFatture.size() > 0) {
            tmpListCessionariCommitenti.add(new Invoice("", "", "0", " \u2022 Tutti i Cessionari Committenti \u2022 ", "", new Date(), "", "", "", 0, false, false, "", "", new ArrayList<Attachments>()));
        }
        for (Map.Entry<String, List<Invoice>> entry : mapListCessionariCommitenti.entrySet()) {
            if (entry.getValue().get(0).getCessionarioCommittente().isEmpty()) continue;
            tmpListCessionariCommitenti.add(entry.getValue().get(0));
        }
        Comparator<Invoice> comparator_byCessionarioCommittente = new Comparator<Invoice>(){

            @Override
            public int compare(Invoice o1, Invoice o2) {
                return o1.getCessionarioCommittente().compareToIgnoreCase(o2.getCessionarioCommittente());
            }
        };
        this.listFilterCessionarioCommittente = new FilteredList((ObservableList)FXCollections.observableList(tmpListCessionariCommitenti).sorted((Comparator)comparator_byCessionarioCommittente), invoice -> true);
        this.listViewCessionarioCommittente.setItems(this.listFilterCessionarioCommittente);
        this.listViewCessionarioCommittente.setCellFactory((Callback)new Callback<ListView<Invoice>, ListCell<Invoice>>(){

            public ListCell<Invoice> call(ListView<Invoice> param) {
                ListCell<Invoice> cell = new ListCell<Invoice>(){

                    protected void updateItem(Invoice item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            FilteredList filteredData = new FilteredList(FXCollections.observableList((List)ViewMain.this.listFatture), invoice -> true);
                            if (!item.getPivaCFCessionarioCommittente().equals("0")) {
                                filteredData.setPredicate(s -> s.getPivaCFCessionarioCommittente().equals(item.getPivaCFCessionarioCommittente()));
                            }
                            HBox hboxCessionarioCommitente = new HBox();
                            hboxCessionarioCommitente.setSpacing(5.0);
                            hboxCessionarioCommitente.setAlignment(Pos.CENTER_LEFT);
                            HBox hboxIconBadge = new HBox();
                            hboxIconBadge.setSpacing(5.0);
                            ImageView iconCessionarioCommitente = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("/res/user.png").toString()));
                            if (item.getPivaCFCessionarioCommittente().equals("0")) {
                                iconCessionarioCommitente.setImage(new Image(((Object)((Object)this)).getClass().getResource("/res/userAll.png").toString()));
                            }
                            Badge badge = new Badge();
                            badge.setControl((Node)iconCessionarioCommitente);
                            if (item.getPivaCFCessionarioCommittente().equals("0")) {
                                if (filteredData.size() < 1000) {
                                    badge.getStyleClass().add((Object)"icons-badge-all");
                                } else if (filteredData.size() <= 9999) {
                                    badge.getStyleClass().add((Object)"icons-badge-all-large");
                                } else {
                                    badge.getStyleClass().add((Object)"icons-badge-all-xlarge");
                                }
                            } else if (filteredData.size() < 1000) {
                                badge.getStyleClass().add((Object)"icons-badge");
                            } else if (filteredData.size() <= 9999) {
                                badge.getStyleClass().add((Object)"icons-badge-large");
                            } else {
                                badge.getStyleClass().add((Object)"icons-badge-xlarge");
                            }
                            badge.setText(String.valueOf(filteredData.size()));
                            if (filteredData.size() > 0) {
                                hboxIconBadge.getChildren().add((Object)badge);
                            }
                            Label labelCessionarioCommittente = new Label(item.getCessionarioCommittente());
                            if (item.getPivaCFCessionarioCommittente().equals("0")) {
                                labelCessionarioCommittente.getStyleClass().add((Object)"labelUsers");
                                labelCessionarioCommittente.setTextAlignment(TextAlignment.CENTER);
                            }
                            hboxCessionarioCommitente.getChildren().addAll((Object[])new Node[]{iconCessionarioCommitente, hboxIconBadge, labelCessionarioCommittente});
                            this.setGraphic((Node)hboxCessionarioCommitente);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                return cell;
            }
        });
        Comparator<Invoice> comparatorInvoice_byData = new Comparator<Invoice>(){

            @Override
            public int compare(Invoice o1, Invoice o2) {
                return o1.getDataFattura().compareTo(o2.getDataFattura());
            }
        };
        Collections.sort(this.listFatture, comparatorInvoice_byData);
        this.listFilterFatture = new FilteredList(FXCollections.observableList(this.listFatture));
        this.listViewFatture.setItems(this.listFilterFatture);
        this.listViewFatture.setCellFactory((Callback)new Callback<ListView<Invoice>, ListCell<Invoice>>(){

            public ListCell<Invoice> call(ListView<Invoice> param) {
                ListCell<Invoice> cell = new ListCell<Invoice>(){

                    protected void updateItem(final Invoice item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    if (event.getClickCount() > 1) {
                                        ViewMain.this.Apri(item.getPathXML());
                                    }
                                }
                            });
                            GridPane gridFattura = new GridPane();
                            gridFattura.setPadding(new Insets(5.0, 5.0, 5.0, 0.0));
                            VBox vboxFattura = new VBox();
                            vboxFattura.setSpacing(5.0);
                            vboxFattura.setAlignment(Pos.CENTER);
                            HBox hboxFatture = new HBox();
                            hboxFatture.setAlignment(Pos.CENTER);
                            VBox vboxLotto = new VBox();
                            vboxLotto.setSpacing(5.0);
                            vboxLotto.setAlignment(Pos.CENTER);
                            VBox vboxContatto = new VBox();
                            vboxContatto.setSpacing(5.0);
                            vboxContatto.setAlignment(Pos.CENTER);
                            HBox hboxCheckbox = new HBox();
                            hboxCheckbox.setSpacing(10.0);
                            hboxCheckbox.setAlignment(Pos.TOP_CENTER);
                            final CheckBox chkContrassegno = new CheckBox();
                            chkContrassegno.setCursor(Cursor.HAND);
                            chkContrassegno.setSelected(item.getIsContrassegnata().booleanValue());
                            chkContrassegno.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                                public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                                    item.setIsContrassegnata(chkContrassegno.isSelected());
                                    ViewMain.this._listFattureContrassegnate.remove(item.getHashFatturaSuDisco());
                                    if (chkContrassegno.isSelected()) {
                                        ViewMain.this._listFattureContrassegnate.add(item.getHashFatturaSuDisco());
                                    }
                                    ViewMain.this.myFunctions.SalvaListaContrassegnateSuDisco(ViewMain.this._listFattureContrassegnate);
                                }
                            });
                            hboxCheckbox.getChildren().add((Object)chkContrassegno);
                            GridPane.setMargin((Node)hboxCheckbox, (Insets)new Insets(-2.0, 0.0, 0.0, 5.0));
                            gridFattura.add((Node)hboxCheckbox, 0, 0);
                            HBox hboxLotto = new HBox();
                            hboxLotto.setSpacing(10.0);
                            hboxLotto.setAlignment(Pos.CENTER_LEFT);
                            ImageView imgLotto = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/lotto@16.png").toString()));
                            Button button = new Button();
                            button.setGraphic((Node)imgLotto);
                            button.setStyle("-fx-background-color: transparent;");
                            button.setTooltip(new Tooltip("Documento " + String.valueOf(item.getNumeroLotto() + " del lotto di fatture")));
                            button.setVisible(item.getShowLotto().booleanValue());
                            hboxLotto.getChildren().add((Object)button);
                            GridPane.setMargin((Node)hboxLotto, (Insets)new Insets(0.0, 0.0, 5.0, 5.0));
                            gridFattura.add((Node)hboxLotto, 1, 0);
                            HBox hboxNumero = new HBox();
                            hboxNumero.setSpacing(10.0);
                            hboxNumero.setAlignment(Pos.CENTER_LEFT);
                            Text tValueNumero = new Text(item.getNumero());
                            tValueNumero.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
                            tValueNumero.setWrappingWidth(140.0);
                            ImageView imgNumero = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/numero@16.png").toString()));
                            hboxNumero.getChildren().addAll((Object[])new Node[]{imgNumero, tValueNumero});
                            GridPane.setMargin((Node)hboxNumero, (Insets)new Insets(0.0, 0.0, 5.0, 5.0));
                            gridFattura.add((Node)hboxNumero, 2, 0);
                            HBox hboxData = new HBox();
                            hboxData.setSpacing(10.0);
                            hboxData.setAlignment(Pos.CENTER_LEFT);
                            Text tValueDataFattura = new Text();
                            if (item.getDataFattura() != null) {
                                tValueDataFattura.setText(ViewMain.this.formatDate.format(item.getDataFattura()));
                            }
                            tValueDataFattura.setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                            ImageView imgDataFattura = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/data@16.png").toString()));
                            hboxData.getChildren().addAll((Object[])new Node[]{imgDataFattura, tValueDataFattura});
                            GridPane.setMargin((Node)hboxData, (Insets)new Insets(0.0, 0.0, 5.0, 5.0));
                            gridFattura.add((Node)hboxData, 3, 0);
                            HBox hboxTipoDoc = new HBox();
                            hboxTipoDoc.setSpacing(3.0);
                            hboxTipoDoc.setAlignment(Pos.CENTER_LEFT);
                            Text tValueTipoDocumento = new Text(item.getTipoDocumento());
                            tValueTipoDocumento.setFill((Paint)ViewMain.this.colAzzurroScuro);
                            tValueTipoDocumento.setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                            Button buttonDoc = new Button();
                            buttonDoc.setStyle("-fx-background-color: transparent;-fx-pref-width: 24.0;-fx-pref-height: 24.0;");
                            ImageView imgDoc = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/doc@16.png").toString()));
                            ImageView imgDocSign = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/docSign@16.png").toString()));
                            ImageView imgDocMark = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/docMark@16.png").toString()));
                            if (item.getPathOriginale().toLowerCase().endsWith(".p7m") || item.getIsX509Certificate().booleanValue()) {
                                buttonDoc.setGraphic((Node)imgDocSign);
                                buttonDoc.setTooltip(new Tooltip("Documento firmato digitalmente"));
                            } else if (item.getPathOriginale().toLowerCase().endsWith(".tsd")) {
                                buttonDoc.setGraphic((Node)imgDocMark);
                                buttonDoc.setTooltip(new Tooltip("Documento marcato temporalmente"));
                            } else {
                                buttonDoc.setGraphic((Node)imgDoc);
                            }
                            hboxTipoDoc.getChildren().addAll((Object[])new Node[]{buttonDoc, tValueTipoDocumento});
                            GridPane.setMargin((Node)hboxTipoDoc, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
                            gridFattura.add((Node)hboxTipoDoc, 4, 0);
                            HBox hboxPEC = new HBox();
                            hboxPEC.setSpacing(10.0);
                            hboxPEC.setAlignment(Pos.CENTER_LEFT);
                            ImageView imgPEC = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/pec@16.png").toString()));
                            Button buttonPEC = new Button();
                            buttonPEC.setGraphic((Node)imgPEC);
                            buttonPEC.setStyle("-fx-background-color: transparent;");
                            buttonPEC.setTooltip(new Tooltip("La fattura proviene da una mail PEC"));
                            buttonPEC.setVisible(item.getShowMail().booleanValue());
                            hboxPEC.getChildren().add((Object)buttonPEC);
                            GridPane.setMargin((Node)hboxPEC, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
                            gridFattura.add((Node)hboxPEC, 1, 1);
                            HBox hboxCedentePrestatore = new HBox();
                            hboxCedentePrestatore.setSpacing(10.0);
                            hboxCedentePrestatore.setAlignment(Pos.CENTER_LEFT);
                            Text tValueCedentePrestatore = new Text(item.getCedentePrestatore().isEmpty() ? "Non impostato" : item.getCedentePrestatore());
                            tValueCedentePrestatore.setFill((Paint)ViewMain.this.colAzzurroScuro);
                            tValueCedentePrestatore.setStyle("-fx-font-style: italic; -fx-font-family: Arial; -fx-font-size: 8pt");
                            tValueCedentePrestatore.setWrappingWidth(140.0);
                            ImageView imgCedentePrestatore = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/titleCedentePrestatore@16.png").toString()));
                            hboxCedentePrestatore.getChildren().addAll((Object[])new Node[]{imgCedentePrestatore, tValueCedentePrestatore});
                            GridPane.setMargin((Node)hboxCedentePrestatore, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
                            gridFattura.add((Node)hboxCedentePrestatore, 2, 1);
                            HBox hboxCessionarioCommittente = new HBox();
                            hboxCessionarioCommittente.setSpacing(10.0);
                            hboxCessionarioCommittente.setAlignment(Pos.CENTER_LEFT);
                            Text tValueCessionarioCommittente = new Text(item.getCessionarioCommittente().isEmpty() ? "Non impostato" : item.getCessionarioCommittente());
                            tValueCessionarioCommittente.setFill((Paint)ViewMain.this.colAzzurroScuro);
                            tValueCessionarioCommittente.setStyle("-fx-font-style: italic; -fx-font-family: Arial; -fx-font-size: 8pt");
                            tValueCessionarioCommittente.setWrappingWidth(140.0);
                            ImageView imgCessionarioCommittente = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/cessionarioCommittente@16.png").toString()));
                            hboxCessionarioCommittente.getChildren().addAll((Object[])new Node[]{imgCessionarioCommittente, tValueCessionarioCommittente});
                            GridPane.setMargin((Node)hboxCessionarioCommittente, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
                            gridFattura.add((Node)hboxCessionarioCommittente, 3, 1);
                            if (item.getAttachments().size() > 0) {
                                HBox hboxAllegati = new HBox();
                                hboxAllegati.setSpacing(7.0);
                                hboxAllegati.setAlignment(Pos.CENTER_LEFT);
                                ImageView imgAllegati = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/attach@16.png").toString()));
                                Text tValueAllegati = new Text("N\u00b0 allegati: (" + String.valueOf(String.valueOf(item.getAttachments().size()) + ")"));
                                tValueAllegati.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
                                Button buttonDownload = new Button();
                                ImageView imgDownload = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/download.png").toString()));
                                buttonDownload.setGraphic((Node)imgDownload);
                                buttonDownload.getStyleClass().add((Object)"buttonCustom");
                                buttonDownload.setTooltip(new Tooltip("Esporta allegati..."));
                                buttonDownload.setCursor(Cursor.HAND);
                                buttonDownload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent e2) {
                                        DirectoryChooser fileChooser = new DirectoryChooser();
                                        fileChooser.setTitle("Seleziona cartella");
                                        ViewMain.this.directory = fileChooser.showDialog((Window)ViewMain.this.mainStage);
                                        if (ViewMain.this.directory != null && ViewMain.this.directory.exists()) {
                                            int errorExport = 0;
                                            int numEsportati = 0;
                                            for (Attachments attach : item.getAttachments()) {
                                                if (attach != null) {
                                                    if (attach.getNome() != null) {
                                                        Throwable throwable;
                                                        String nomeNormalizzato = ViewMain.this.myFunctions.NormalizzaNomeFile(attach.getNome());
                                                        try {
                                                            Throwable throwable2 = null;
                                                            throwable = null;
                                                            try (FileOutputStream fos = new FileOutputStream((ViewMain.this.directory + "\\" + nomeNormalizzato).replace("\\", "//"));){
                                                                fos.write(Base64.getMimeDecoder().decode(attach.getAttachment()));
                                                                fos.close();
                                                                ++numEsportati;
                                                            }
                                                            catch (Throwable throwable3) {
                                                                if (throwable2 == null) {
                                                                    throwable2 = throwable3;
                                                                } else if (throwable2 != throwable3) {
                                                                    throwable2.addSuppressed(throwable3);
                                                                }
                                                                throw throwable2;
                                                            }
                                                        }
                                                        catch (IOException ex) {
                                                            nomeNormalizzato = "allegato_" + Integer.toString(attach.hashCode());
                                                            if (attach.getFormato() != null) {
                                                                nomeNormalizzato = String.valueOf(nomeNormalizzato) + "." + attach.getFormato();
                                                            }
                                                            try {
                                                                throwable = null;
                                                                Object var10_15 = null;
                                                                try (FileOutputStream fos = new FileOutputStream((ViewMain.this.directory + "\\" + nomeNormalizzato).replace("\\", "//"));){
                                                                    fos.write(Base64.getMimeDecoder().decode(attach.getAttachment()));
                                                                    fos.close();
                                                                    ++numEsportati;
                                                                }
                                                                catch (Throwable throwable4) {
                                                                    if (throwable == null) {
                                                                        throwable = throwable4;
                                                                    } else if (throwable != throwable4) {
                                                                        throwable.addSuppressed(throwable4);
                                                                    }
                                                                    throw throwable;
                                                                }
                                                            }
                                                            catch (IOException ex2) {
                                                                ++errorExport;
                                                            }
                                                        }
                                                        continue;
                                                    }
                                                    ++errorExport;
                                                    continue;
                                                }
                                                ++errorExport;
                                            }
                                            if (errorExport > 0) {
                                                ViewMain.this.myFunctions.notifier("Attenzione", "Esportazione avvenuta con errori!\nVerificare il documento o il path di destinazione", Alert.AlertType.WARNING, 3000.0);
                                            } else if (numEsportati > 1) {
                                                ViewMain.this.myFunctions.notifier("Esportazione", String.valueOf(numEsportati) + " allegati esportati correttamente!", Alert.AlertType.NONE, 3000.0);
                                            } else {
                                                ViewMain.this.myFunctions.notifier("Esportazione", "1 allegato esportato correttamente!", Alert.AlertType.NONE, 3000.0);
                                            }
                                        }
                                    }
                                });
                                Button buttonDownload2 = new Button();
                                ImageView imgDownload2 = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/preview.png").toString()));
                                buttonDownload2.setGraphic((Node)imgDownload2);
                                buttonDownload2.getStyleClass().add((Object)"buttonCustom");
                                buttonDownload2.setTooltip(new Tooltip("Anteprima allegati..."));
                                buttonDownload2.setCursor(Cursor.HAND);
                                buttonDownload2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent e2) {
                                        ViewMain.this.ShowAllegati(item);
                                    }
                                });
                                hboxAllegati.getChildren().addAll((Object[])new Node[]{imgAllegati, tValueAllegati, buttonDownload, buttonDownload2});
                                GridPane.setMargin((Node)hboxAllegati, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
                                gridFattura.add((Node)hboxAllegati, 4, 1);
                            }
                            gridFattura.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(24.0), new ColumnConstraints(36.0), new ColumnConstraints(170.0), new ColumnConstraints(170.0)});
                            vboxContatto.getChildren().add((Object)gridFattura);
                            hboxFatture.getChildren().add((Object)vboxContatto);
                            hboxFatture.setAlignment(Pos.CENTER_LEFT);
                            vboxFattura.getChildren().addAll((Object[])new Node[]{hboxFatture});
                            this.setGraphic((Node)vboxFattura);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                return cell;
            }
        });
    }

    private void Load(File invoice, ReadXML xmlReader, Sign sign) {
        block25: {
            if (invoice.getName().toLowerCase().endsWith(".msg") || invoice.getName().toLowerCase().endsWith(".eml") || invoice.getName().toLowerCase().endsWith(".xml") || invoice.getName().toLowerCase().endsWith(".p7m") || invoice.getName().toLowerCase().endsWith(".tsd")) {
                if (invoice.getName().toLowerCase().endsWith(".msg") || invoice.getName().toLowerCase().endsWith(".eml")) {
                    try {
                        block24: {
                            this.email = new Email(this.myFunctions);
                            String returnFile = this.email.getMessage(invoice.getAbsolutePath(), false).trim();
                            if (!returnFile.isEmpty()) {
                                if (returnFile.toLowerCase().endsWith(".p7m") || returnFile.toLowerCase().endsWith(".tsd")) {
                                    try {
                                        String fileExtract = sign.extractSignAndMark(new File(returnFile), this.myFunctions, false);
                                        if (fileExtract == null) {
                                            ++this.errorLoading;
                                        }
                                        if (fileExtract.toLowerCase().endsWith(".xml")) {
                                            this.ReadXML(xmlReader, fileExtract, returnFile, invoice.getName(), invoice.getAbsolutePath());
                                            break block24;
                                        }
                                        ++this.errorLoading;
                                    }
                                    catch (IOException | CMSException e2) {
                                        ++this.errorLoading;
                                    }
                                    catch (Exception e3) {
                                        ++this.errorLoading;
                                    }
                                } else if (returnFile.toLowerCase().endsWith(".xml")) {
                                    this.ReadXML(xmlReader, returnFile, returnFile, invoice.getName(), invoice.getAbsolutePath());
                                } else {
                                    ++this.errorLoading;
                                }
                            } else {
                                ++this.errorLoading;
                            }
                        }
                        this.email = null;
                    }
                    catch (IOException | CMSException e4) {
                        ++this.errorLoading;
                    }
                    catch (Exception e5) {
                        ++this.errorLoading;
                    }
                } else if (invoice.getName().toLowerCase().endsWith(".p7m") || invoice.getName().toLowerCase().endsWith(".tsd")) {
                    try {
                        String fileExtract = sign.extractSignAndMark(new File(invoice.getAbsolutePath()), this.myFunctions, false);
                        if (fileExtract == null) {
                            ++this.errorLoading;
                            break block25;
                        }
                        if (fileExtract.toLowerCase().endsWith(".xml")) {
                            this.ReadXML(xmlReader, fileExtract, invoice.getAbsolutePath(), invoice.getName(), invoice.getAbsolutePath());
                            break block25;
                        }
                        ++this.errorLoading;
                    }
                    catch (IOException | CMSException e6) {
                        ++this.errorLoading;
                    }
                    catch (Exception e7) {
                        ++this.errorLoading;
                    }
                } else {
                    this.ReadXML(xmlReader, invoice.getAbsolutePath(), invoice.getAbsolutePath(), invoice.getName(), invoice.getAbsolutePath());
                }
            }
        }
    }

    private void ReadXML(ReadXML xmlReader, String workfile, String returnFilename, String originalFilename, String nomeFileSorgenteSuDisco) {
        int bodyXML = 0;
        try {
            bodyXML = xmlReader.readBodyXML(workfile);
            int i = 0;
            while (i < bodyXML) {
                Invoice fattura = new Invoice("", "", "", "", "", new Date(), "", "", "", 0, false, false, "", "", new ArrayList<Attachments>());
                if ((fattura = xmlReader.read(fattura, workfile, i)) != null) {
                    fattura.setShowLotto(bodyXML > 1);
                    fattura.setShowMail(originalFilename.toLowerCase().endsWith(".msg") || originalFilename.toLowerCase().endsWith(".eml"));
                    fattura.setPathOriginale(returnFilename);
                    fattura.setNomeFileSorgenteSuDisco(nomeFileSorgenteSuDisco);
                    fattura.setIsContrassegnata(this._listFattureContrassegnate.contains(fattura.getHashFatturaSuDisco()));
                    this.listFatture.add(fattura);
                } else {
                    ++this.errorLoading;
                }
                ++i;
            }
        }
        catch (Exception e2) {
            ++this.errorLoading;
        }
    }

    private Boolean VerifyLoading() {
        if (this.directory == null || this.directory.getParent() == null || this.directory.getAbsolutePath().equals(System.getenv("AppData")) || this.directory.getAbsolutePath().equals(System.getenv("SystemRoot")) || this.directory.getAbsolutePath().equals(System.getenv("ProgramData")) || this.directory.getAbsolutePath().equals(System.getenv("ProgramFiles")) || this.directory.getAbsolutePath().equals(System.getenv("ProgramFiles(x86)"))) {
            this.myFunctions.notifier("Attenzione", "Directory di lavoro non disponibile, impossibile continuare!", Alert.AlertType.WARNING, 2500.0);
            return false;
        }
        return true;
    }

    private void Loading() {
        this.myFunctions.Logga("Inizio loading fatture");
        if (!this.VerifyLoading().booleanValue()) {
            this.myFunctions.Logga("Verifica loading fallita");
            return;
        }
        this.evitaAggiornaFattureFiltrate = true;
        this.myFunctions.Logga("directory=" + this.directory.getAbsolutePath());
        File directoryRoot = this.directory;
        this.arrayFiles.clear();
        try {
            this.arrayFiles = Files.walk(Paths.get(this.directory.getAbsolutePath(), new String[0]), 10, new FileVisitOption[0]).limit(1000000L).filter(p -> p.toString().toLowerCase().endsWith(".xml") || p.toString().toLowerCase().endsWith(".eml") || p.toString().toLowerCase().endsWith(".msg") || p.toString().toLowerCase().endsWith(".p7m") || p.toString().toLowerCase().endsWith(".tsd")).map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException e2) {
            this.myFunctions.Logga("IOException:" + e2.getMessage());
            e2.printStackTrace();
        }
        catch (Exception ex) {
            this.myFunctions.Logga("Exception:" + ex.getMessage());
            ex.printStackTrace();
        }
        this.myFunctions.Logga("   arrayFiles.size=" + this.arrayFiles.size());
        this.errorLoading = 0;
        this.interrompiCaricamento = false;
        this.listFatture.clear();
        settings.put("directoryDefault", directoryRoot.getAbsolutePath());
        this.Loader();
        Task<Boolean> task = new Task<Boolean>(){

            public Boolean call() throws Exception {
                this.updateMessage("Caricamento...");
                this.LoadInvoice();
                return true;
            }

            private void LoadInvoice() {
                AtomicInteger progress = new AtomicInteger();
                ViewMain.this.arrayFiles.stream().forEach(file -> {
                    if (!ViewMain.this.interrompiCaricamento) {
                        progress.incrementAndGet();
                        ViewMain.this.Load(file, ViewMain.this.readXML, ViewMain.this.sign);
                        this.updateProgress(progress.get() + 1, ViewMain.this.arrayFiles.size());
                        this.updateMessage("Caricamento (" + String.valueOf(Math.round((double)progress.get() / (double)ViewMain.this.arrayFiles.size() * 100.0)) + "%)");
                    }
                });
            }
        };
        task.setOnRunning(arg_0 -> this.lambda$26((Task)task, arg_0));
        task.setOnSucceeded(arg_0 -> this.lambda$28((Task)task, directoryRoot, arg_0));
        Thread th = new Thread((Runnable)task);
        th.setDaemon(true);
        th.start();
    }

    private void CaricaAnniFatture() {
        this.tabPaneYears.getTabs().clear();
        Tab tabAllYears = new Tab();
        tabAllYears.setClosable(false);
        tabAllYears.setId("0");
        Label labelAllYears = new Label("Tutti gli anni");
        labelAllYears.setFont(this.customFontTitle);
        tabAllYears.setGraphic((Node)labelAllYears);
        this.tabPaneYears.getStyleClass().add((Object)"tab-pane-year");
        this.tabPaneYears.getTabs().add((Object)tabAllYears);
        Map<Date, List<Invoice>> mapListFatture = this.listFatture.stream().collect(Collectors.groupingBy(Invoice::getDataFattura));
        ArrayList<Integer> years = new ArrayList<Integer>();
        for (Map.Entry<Date, List<Invoice>> entry : mapListFatture.entrySet()) {
            Invoice fattura = entry.getValue().get(0);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(fattura.getDataFattura());
            int year = calendar.get(1);
            if (years.contains(year)) continue;
            years.add(year);
        }
        Comparator<Integer> comparatorInvoice_byData = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        };
        Collections.sort(years, comparatorInvoice_byData);
        int i = 0;
        while (i < years.size()) {
            Tab tab = new Tab();
            tab.setClosable(false);
            tab.setId(String.valueOf(years.get(i)));
            Label labelYear = new Label(String.valueOf(years.get(i)));
            labelYear.setFont(this.customFontTitle);
            tab.setGraphic((Node)labelYear);
            this.tabPaneYears.getTabs().add((Object)tab);
            ++i;
        }
    }

    private void DisableControl(Boolean Disable) {
        this.tabPaneYears.setDisable(Disable.booleanValue());
        this.tabPaneMonths.setDisable(Disable.booleanValue());
        this.splitPaneMain.setDisable(Disable.booleanValue());
        this.splitPaneGlobal.setDisable(Disable.booleanValue());
        this.btnSettings.setDisable(Disable.booleanValue());
    }

    private void ShowTutorial(Node node) {
        this.DisableControl(true);
        this.hboxHeader.getChildren().add((Object)this.hboxCloseTutorial);
        this.timelineDirectory = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), ae -> {
            Label lblSettings = new Label("Seleziona la cartella di lavoro contenente le fatture elettroniche da consultare\ned il foglio di stile desiderato per poterle visualizzare.");
            lblSettings.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverDirectory = Functions.popover((Node)this.btnSettings, PopOver.ArrowLocation.TOP_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/1.png").toString())), lblSettings}), false, false);
        }, new KeyValue[0])});
        this.timelineDirectory.play();
        this.timelineYears = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)6500.0), ae -> {
            this.popOverDirectory.hide();
            Label lblYears = new Label("Seleziona l'anno di interesse");
            lblYears.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverTabYears = Functions.popover((Node)this.tabPaneYears, PopOver.ArrowLocation.TOP_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/2.png").toString())), lblYears}), false, false);
        }, new KeyValue[0])});
        this.timelineYears.play();
        this.timelineMonth = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)8500.0), ae -> {
            this.popOverTabYears.hide();
            Label lblMonth = new Label("Seleziona il mese di interesse");
            lblMonth.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverTabMonth = Functions.popover((Node)this.tabPaneMonths, PopOver.ArrowLocation.TOP_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/3.png").toString())), lblMonth}), false, false);
        }, new KeyValue[0])});
        this.timelineMonth.play();
        this.timelineCedentePrestatore = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)10500.0), ae -> {
            this.popOverTabMonth.hide();
            Label lblListCedentePrestatore = new Label("Seleziona il Cedente Prestatore");
            lblListCedentePrestatore.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverCedentePrestatore = Functions.popover(this.listViewCedentePrestatore, PopOver.ArrowLocation.BOTTOM_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/4.png").toString())), lblListCedentePrestatore}), false, false);
        }, new KeyValue[0])});
        this.timelineCedentePrestatore.play();
        this.timelineCessionarioCommitente = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)12500.0), ae -> {
            this.popOverCedentePrestatore.hide();
            Label lblListCessionarioCommitente = new Label("Seleziona il Cessionario Commitente");
            lblListCessionarioCommitente.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverCessionarioCommitente = Functions.popover(this.listViewCessionarioCommittente, PopOver.ArrowLocation.BOTTOM_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/5.png").toString())), lblListCessionarioCommitente}), false, false);
        }, new KeyValue[0])});
        this.timelineCessionarioCommitente.play();
        this.timelineContrassegnate = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)14500.0), ae -> {
            this.popOverCessionarioCommitente.hide();
            Label lblContrassegnate = new Label("Visualizza tutte le fatture o solo le contrassegnate");
            lblContrassegnate.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverContrassegnate = Functions.popover((Node)this.comboBoxContrassegnate, PopOver.ArrowLocation.BOTTOM_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/6.png").toString())), lblContrassegnate}), false, false);
        }, new KeyValue[0])});
        this.timelineContrassegnate.play();
        this.timelineFatture = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)16500.0), ae -> {
            this.popOverContrassegnate.hide();
            Label lblListFatture = new Label("Seleziona la fattura desiderata per la consultazione");
            lblListFatture.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverListFatture = Functions.popover(this.listViewFatture, PopOver.ArrowLocation.BOTTOM_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/7.png").toString())), lblListFatture}), false, false);
        }, new KeyValue[0])});
        this.timelineFatture.play();
        this.timelinePrintAll = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)18500.0), ae -> {
            this.popOverListFatture.hide();
            Label lblButtonPrintAll = new Label("Stampa le fatture selezionate");
            lblButtonPrintAll.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverButtonPrintAll = Functions.popover((Node)this.btnPrint, PopOver.ArrowLocation.BOTTOM_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/8.png").toString())), lblButtonPrintAll}), false, false);
        }, new KeyValue[0])});
        this.timelinePrintAll.play();
        this.timelineDeleteFiles = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)20500.0), ae -> {
            this.popOverButtonPrintAll.hide();
            Label lblButtonDeleteFiles = new Label("Elimina le fatture selezionate");
            lblButtonDeleteFiles.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverButtonDeleteFiles = Functions.popover((Node)this.btnDeleteFiles, PopOver.ArrowLocation.TOP_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/9.png").toString())), lblButtonDeleteFiles}), false, false);
        }, new KeyValue[0])});
        this.timelineDeleteFiles.play();
        this.timelineCompletaSemplificata = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)22500.0), ae -> {
            this.popOverButtonDeleteFiles.hide();
            Label lblButtonCompletaSemplificata = new Label("Selezionare il tipo di visualizzazione delle fatture");
            lblButtonCompletaSemplificata.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverButtonCompletaSemplificata = Functions.popover((Node)this.comboBoxStileFattura, PopOver.ArrowLocation.BOTTOM_LEFT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/10.png").toString())), lblButtonCompletaSemplificata}), false, false);
        }, new KeyValue[0])});
        this.timelineCompletaSemplificata.play();
        this.timelineOpenFolder = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)24500.0), ae -> {
            this.popOverButtonCompletaSemplificata.hide();
            Label lblButtonOpenFolder = new Label("Apri cartella su disco della fattura visualizzata");
            lblButtonOpenFolder.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverButtonOpenFolder = Functions.popover((Node)this.btnOpenFolder, PopOver.ArrowLocation.RIGHT_TOP, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/11.png").toString())), lblButtonOpenFolder}), false, false);
        }, new KeyValue[0])});
        this.timelineOpenFolder.play();
        this.timelineExport = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)26500.0), ae -> {
            this.popOverButtonOpenFolder.hide();
            Label lblButtonExport = new Label("Esporta la fattura visualizzata");
            lblButtonExport.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverButtonExport = Functions.popover((Node)this.btnExportFile, PopOver.ArrowLocation.TOP_RIGHT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/12.png").toString())), lblButtonExport}), false, false);
        }, new KeyValue[0])});
        this.timelineExport.play();
        this.timelinePrint = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)28500.0), ae -> {
            this.popOverButtonExport.hide();
            Label lblButtonPrint = new Label("Stampa la fattura visualizzata");
            lblButtonPrint.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverButtonPrint = Functions.popover((Node)this.btnPrintFile, PopOver.ArrowLocation.BOTTOM_RIGHT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/13.png").toString())), lblButtonPrint}), false, false);
        }, new KeyValue[0])});
        this.timelinePrint.play();
        this.timelineSignMark = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)30500.0), ae -> {
            this.popOverButtonPrint.hide();
            Label lblButtonSingMark = new Label("Verifica la firma digitale della fattura visualizzata");
            lblButtonSingMark.setFont(Font.font((String)"Arial", (double)12.0));
            this.popOverButtonSignMark = Functions.popover((Node)this.btnVerifySign, PopOver.ArrowLocation.TOP_RIGHT, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/14.png").toString())), lblButtonSingMark}), false, false);
        }, new KeyValue[0])});
        this.timelineSignMark.play();
        this.timelineEnd = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)32500.0), ae -> {
            this.popOverButtonSignMark.hide();
            this.DisableControl(false);
            this.hboxHeader.getChildren().remove((Object)this.hboxCloseTutorial);
        }, new KeyValue[0])});
        this.timelineEnd.play();
    }

    private void CloseTutorial() {
        if (this.timelineDirectory.getStatus() == Animation.Status.RUNNING) {
            this.timelineDirectory.stop();
        }
        this.popOverDirectory.hide();
        if (this.timelineYears.getStatus() == Animation.Status.RUNNING) {
            this.timelineYears.stop();
        }
        this.popOverTabYears.hide();
        if (this.timelineMonth.getStatus() == Animation.Status.RUNNING) {
            this.timelineMonth.stop();
        }
        this.popOverTabMonth.hide();
        if (this.timelineCedentePrestatore.getStatus() == Animation.Status.RUNNING) {
            this.timelineCedentePrestatore.stop();
        }
        this.popOverCedentePrestatore.hide();
        if (this.timelineCessionarioCommitente.getStatus() == Animation.Status.RUNNING) {
            this.timelineCessionarioCommitente.stop();
        }
        this.popOverCessionarioCommitente.hide();
        if (this.timelineContrassegnate.getStatus() == Animation.Status.RUNNING) {
            this.timelineContrassegnate.stop();
        }
        this.popOverContrassegnate.hide();
        if (this.timelineFatture.getStatus() == Animation.Status.RUNNING) {
            this.timelineFatture.stop();
        }
        this.popOverListFatture.hide();
        if (this.timelinePrintAll.getStatus() == Animation.Status.RUNNING) {
            this.timelinePrintAll.stop();
        }
        this.popOverButtonPrintAll.hide();
        if (this.timelineDeleteFiles.getStatus() == Animation.Status.RUNNING) {
            this.timelineDeleteFiles.stop();
        }
        this.popOverButtonDeleteFiles.hide();
        if (this.timelineCompletaSemplificata.getStatus() == Animation.Status.RUNNING) {
            this.timelineCompletaSemplificata.stop();
        }
        this.popOverButtonCompletaSemplificata.hide();
        if (this.timelineOpenFolder.getStatus() == Animation.Status.RUNNING) {
            this.timelineOpenFolder.stop();
        }
        this.popOverButtonOpenFolder.hide();
        if (this.timelineExport.getStatus() == Animation.Status.RUNNING) {
            this.timelineExport.stop();
        }
        this.popOverButtonExport.hide();
        if (this.timelinePrint.getStatus() == Animation.Status.RUNNING) {
            this.timelinePrint.stop();
        }
        this.popOverButtonPrint.hide();
        if (this.timelineSignMark.getStatus() == Animation.Status.RUNNING) {
            this.timelineSignMark.stop();
        }
        this.popOverButtonSignMark.hide();
        if (this.timelineEnd.getStatus() == Animation.Status.RUNNING) {
            this.timelineEnd.stop();
        }
        this.DisableControl(false);
        this.hboxHeader.getChildren().remove((Object)this.hboxCloseTutorial);
    }

    private void Apri(String filename) {
        Platform.runLater(() -> this.sceneMain.setCursor(Cursor.WAIT));
        String returnFilename = this.myFunctions.applyStyleSheetsXml(new File(filename));
        File lFile = new File(returnFilename);
        lFile.setReadOnly();
        DesktopApi.open(lFile);
        Platform.runLater(() -> this.sceneMain.setCursor(Cursor.DEFAULT));
    }

    private void VerifySignMark(Node nodeInvoke, String filename) {
        block5: {
            Platform.runLater(() -> this.sceneMain.setCursor(Cursor.WAIT));
            try {
                try {
                    VBox vboxInfoSign = new VBox();
                    vboxInfoSign = this.sign.verify(filename);
                    Platform.runLater(() -> this.sceneMain.setCursor(Cursor.DEFAULT));
                    this.popOverVerifySign.setAnimated(true);
                    this.popOverVerifySign.setTitle("Dati di firma");
                    this.popOverVerifySign.setHeaderAlwaysVisible(true);
                    this.popOverVerifySign.setCornerRadius(5.0);
                    this.popOverVerifySign.setHideOnEscape(true);
                    this.popOverVerifySign.setAutoFix(true);
                    this.popOverVerifySign.setDetachable(false);
                    this.popOverVerifySign.setArrowLocation(PopOver.ArrowLocation.RIGHT_TOP);
                    this.popOverVerifySign.setContentNode((Node)new TextFlow(new Node[]{vboxInfoSign}));
                    this.popOverVerifySign.show(nodeInvoke);
                }
                catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException | ParseException | CMSException | OperatorCreationException | TSPException eVerifySign) {
                    Functions.popover(nodeInvoke, PopOver.ArrowLocation.RIGHT_TOP, (Collection<Node>)FXCollections.observableArrayList((Object[])new Node[]{new Label(eVerifySign.getLocalizedMessage())}), true, true);
                    eVerifySign.printStackTrace();
                    Platform.runLater(() -> this.sceneMain.setCursor(Cursor.DEFAULT));
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.sceneMain.setCursor(Cursor.DEFAULT));
                throw throwable;
            }
            Platform.runLater(() -> this.sceneMain.setCursor(Cursor.DEFAULT));
        }
    }

    private void PrintDocument(Node nodeInvoke, List<String> files) {
        VBox vboxPrint = new VBox();
        vboxPrint = this.createWindowPrint(files);
        if (vboxPrint != null) {
            this.popOverPrint.setAnimated(true);
            this.popOverPrint.setTitle("Stampa");
            this.popOverPrint.setHeaderAlwaysVisible(true);
            this.popOverPrint.setCornerRadius(5.0);
            this.popOverPrint.setHideOnEscape(true);
            this.popOverPrint.setAutoFix(true);
            this.popOverPrint.setDetachable(false);
            this.popOverPrint.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
            this.popOverPrint.setContentNode((Node)vboxPrint);
            this.popOverPrint.show(nodeInvoke);
        }
    }

    private void Reset(ActionEvent event) {
        Optional<ButtonType> result = this.myFunctions.alert("MyInvoice", "Si desidera eliminare i settings di default?", "", this.myFunctions.imageViewLogo, Alert.AlertType.CONFIRMATION, true);
        if (result.get() == ButtonType.OK) {
            settings.remove("directoryDefault");
            settings.remove("styleSheetsDefaulPath");
            settings.remove("styleSheetsDefaulName");
            settings.remove("optMessageMoreFiles");
        } else {
            event.consume();
        }
    }

    private void ShowLegends(Node node) {
        VBox vboxLegends = new VBox();
        vboxLegends.setSpacing(10.0);
        vboxLegends.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        HBox hboxNumber = new HBox();
        hboxNumber.setSpacing(5.0);
        hboxNumber.setAlignment(Pos.CENTER_LEFT);
        Label lblNumber = new Label("Numero");
        lblNumber.setFont(Font.font((String)"Arial", (double)12.0));
        hboxNumber.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/numero.png").toString())), lblNumber});
        HBox hboxData = new HBox();
        hboxData.setSpacing(5.0);
        hboxData.setAlignment(Pos.CENTER_LEFT);
        Label lblData = new Label("Data fattura");
        lblData.setFont(Font.font((String)"Arial", (double)12.0));
        hboxData.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/data.png").toString())), lblData});
        HBox hboxTipoDoc = new HBox();
        hboxTipoDoc.setSpacing(5.0);
        hboxTipoDoc.setAlignment(Pos.CENTER_LEFT);
        Label lblTipoDoc = new Label("Tipo documento");
        lblTipoDoc.setFont(Font.font((String)"Arial", (double)12.0));
        hboxTipoDoc.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/doc.png").toString())), lblTipoDoc});
        HBox hboxTipoDocSign = new HBox();
        hboxTipoDocSign.setSpacing(5.0);
        hboxTipoDocSign.setAlignment(Pos.CENTER_LEFT);
        Label lblTipoDocSign = new Label("Documento firmato digitalmente");
        lblTipoDocSign.setFont(Font.font((String)"Arial", (double)12.0));
        hboxTipoDocSign.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/docSign.png").toString())), lblTipoDocSign});
        HBox hboxTipoDocMark = new HBox();
        hboxTipoDocMark.setSpacing(5.0);
        hboxTipoDocMark.setAlignment(Pos.CENTER_LEFT);
        Label lblTipoDocMark = new Label("Documento marcato temporalmente");
        lblTipoDocMark.setFont(Font.font((String)"Arial", (double)12.0));
        hboxTipoDocMark.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/docMark.png").toString())), lblTipoDocMark});
        HBox hboxCedentePrestatore = new HBox();
        hboxCedentePrestatore.setSpacing(5.0);
        hboxCedentePrestatore.setAlignment(Pos.CENTER_LEFT);
        Label lblCedentePrestatore = new Label("Cedente Prestatore");
        lblCedentePrestatore.setFont(Font.font((String)"Arial", (double)12.0));
        hboxCedentePrestatore.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/titleCedentePrestatore.png").toString())), lblCedentePrestatore});
        HBox hboxCessCommittente = new HBox();
        hboxCessCommittente.setSpacing(5.0);
        hboxCessCommittente.setAlignment(Pos.CENTER_LEFT);
        Label lblCessCommitente = new Label("Cessionario Committente");
        lblCessCommitente.setFont(Font.font((String)"Arial", (double)12.0));
        hboxCessCommittente.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/cessionarioCommittente.png").toString())), lblCessCommitente});
        HBox hboxAttach = new HBox();
        hboxAttach.setSpacing(5.0);
        hboxAttach.setAlignment(Pos.CENTER_LEFT);
        Label lblAttach = new Label("Allegati");
        lblAttach.setFont(Font.font((String)"Arial", (double)12.0));
        hboxAttach.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/attach.png").toString())), lblAttach});
        HBox hboxDownloadAttach = new HBox();
        hboxDownloadAttach.setSpacing(5.0);
        hboxDownloadAttach.setAlignment(Pos.CENTER_LEFT);
        Label lblDownloadAttach = new Label("Esporta allegati");
        lblDownloadAttach.setFont(Font.font((String)"Arial", (double)12.0));
        hboxDownloadAttach.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/downloadAttach.png").toString())), lblDownloadAttach});
        HBox hboxLotto = new HBox();
        hboxLotto.setSpacing(5.0);
        hboxLotto.setAlignment(Pos.CENTER_LEFT);
        Label lblLotto = new Label("Lotto di fatture");
        lblLotto.setFont(Font.font((String)"Arial", (double)12.0));
        hboxLotto.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/lotto.png").toString())), lblLotto});
        HBox hboxProvenienza = new HBox();
        hboxProvenienza.setSpacing(5.0);
        hboxProvenienza.setAlignment(Pos.CENTER_LEFT);
        Label lblProvenienza = new Label("La fattura proviene da una mail PEC");
        lblProvenienza.setFont(Font.font((String)"Arial", (double)12.0));
        hboxProvenienza.getChildren().addAll((Object[])new Node[]{new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/pec.png").toString())), lblProvenienza});
        vboxLegends.getChildren().addAll((Object[])new Node[]{hboxNumber, hboxData, hboxTipoDoc, hboxTipoDocSign, hboxTipoDocMark, hboxCedentePrestatore, hboxCessCommittente, hboxAttach, hboxDownloadAttach, hboxLotto, hboxProvenienza});
        this.popOverGuide.setAnimated(true);
        this.popOverGuide.setTitle("Legenda");
        this.popOverGuide.setHeaderAlwaysVisible(true);
        this.popOverGuide.setCornerRadius(5.0);
        this.popOverGuide.setHideOnEscape(true);
        this.popOverGuide.setAutoHide(true);
        this.popOverGuide.setAutoFix(true);
        this.popOverGuide.setDetachable(false);
        this.popOverGuide.setContentNode((Node)vboxLegends);
        this.popOverGuide.show(node);
    }

    private void ShowInfoApp(Node node) {
        String headerText = "";
        headerText = applicationVersion != "" ? "MyInvoice " + applicationVersion : "MyInvoice";
        VBox vboxAbout = new VBox();
        vboxAbout.setSpacing(10.0);
        vboxAbout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        HBox hboxTitle = new HBox();
        hboxTitle.setSpacing(10.0);
        hboxTitle.setAlignment(Pos.CENTER);
        Label lblTitleApp = new Label(headerText);
        lblTitleApp.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0));
        Label lblProducer = new Label("Able Tech Srl\nVia Mantova, 2/G\n25017 Lonato del Garda BS\nTelefono: 030.965.06.88\nFax: 030.81.93.11.60\nE-Mail:");
        Label lblIndirizziWeb = new Label("\nIndirizzi Web:");
        lblProducer.setFont(Font.font((String)"Arial", (double)12.0));
        Label lblTech = new Label("Java version: " + System.getProperty("java.version") + "\n" + "javafx runtime version: " + System.getProperties().get("javafx.runtime.version"));
        lblTech.setFont(Font.font((String)"Arial", (double)12.0));
        Hyperlink linkEmailArxivar = new Hyperlink();
        linkEmailArxivar.setPadding(new Insets(-5.0, 0.0, 0.0, 0.0));
        linkEmailArxivar.setText("info@abletech.it");
        linkEmailArxivar.setFont(new Font("Arial", 12.0));
        linkEmailArxivar.setTooltip(new Tooltip("Inviaci una mail direttamente..."));
        linkEmailArxivar.setStyle("-fx-focus-color: transparent;");
        linkEmailArxivar.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e2) {
                try {
                    DesktopApi.openMail(new URI("mailto:info@abletech.it?subject=Richiesta%20informazioni"));
                }
                catch (URISyntaxException ext) {
                    ViewMain.this.myFunctions.notifier("Attenzione", ext.getLocalizedMessage(), Alert.AlertType.WARNING, 2500.0);
                }
            }
        });
        Hyperlink linkSitoArxivar = new Hyperlink();
        linkSitoArxivar.setPadding(new Insets(-5.0, 0.0, 0.0, 0.0));
        linkSitoArxivar.setText("https://www.arxivar.it");
        linkSitoArxivar.setFont(new Font("Arial", 12.0));
        linkSitoArxivar.setTooltip(new Tooltip("Sito ufficiale ARXivar..."));
        linkSitoArxivar.setStyle("-fx-focus-color: transparent;");
        linkSitoArxivar.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e2) {
                try {
                    DesktopApi.browse(new URI("https://www.arxivar.it"));
                }
                catch (URISyntaxException ext) {
                    ViewMain.this.myFunctions.notifier("Attenzione", ext.getLocalizedMessage(), Alert.AlertType.WARNING, 2500.0);
                }
            }
        });
        Hyperlink linkSitoMyInvoice = new Hyperlink();
        linkSitoMyInvoice.setPadding(new Insets(-5.0, 0.0, 0.0, 0.0));
        linkSitoMyInvoice.setText("Sito ufficiale MyInvoice");
        linkSitoMyInvoice.setFont(new Font("Arial", 12.0));
        linkSitoMyInvoice.setStyle("-fx-focus-color: transparent;");
        linkSitoMyInvoice.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e2) {
                try {
                    DesktopApi.browse(new URI("https://fatturazione-elettronica.arxivar.it"));
                }
                catch (URISyntaxException ext) {
                    ViewMain.this.myFunctions.notifier("Attenzione", ext.getLocalizedMessage(), Alert.AlertType.WARNING, 2500.0);
                }
            }
        });
        hboxTitle.getChildren().addAll((Object[])new Node[]{lblTitleApp, this.myFunctions.imageViewLogo});
        vboxAbout.getChildren().addAll((Object[])new Node[]{hboxTitle, lblProducer, linkEmailArxivar, lblIndirizziWeb, linkSitoArxivar, linkSitoMyInvoice, new Label(), lblTech});
        this.popOverAbout.setAnimated(true);
        this.popOverAbout.setTitle("Informazioni");
        this.popOverAbout.setHeaderAlwaysVisible(true);
        this.popOverAbout.setCornerRadius(5.0);
        this.popOverAbout.setHideOnEscape(true);
        this.popOverAbout.setAutoHide(true);
        this.popOverAbout.setAutoFix(true);
        this.popOverAbout.setDetachable(false);
        this.popOverAbout.setContentNode((Node)vboxAbout);
        this.popOverAbout.show(node);
    }

    private void ShowAllegati(Invoice item) {
        VBox vboxAnteprimaAllegato = new VBox();
        vboxAnteprimaAllegato = this.createWindowAnteprimaAllegato(item);
        if (vboxAnteprimaAllegato != null) {
            this.popOverAnteprimaAllegato.setAnimated(true);
            this.popOverAnteprimaAllegato.setTitle("Anteprima allegati");
            this.popOverAnteprimaAllegato.setHeaderAlwaysVisible(true);
            this.popOverAnteprimaAllegato.setCornerRadius(5.0);
            this.popOverAnteprimaAllegato.setHideOnEscape(true);
            this.popOverAnteprimaAllegato.setAutoHide(true);
            this.popOverAnteprimaAllegato.setAutoFix(true);
            this.popOverAnteprimaAllegato.setDetachable(false);
            this.popOverAnteprimaAllegato.setArrowSize(0.0);
            this.popOverAnteprimaAllegato.setContentNode((Node)vboxAnteprimaAllegato);
            this.popOverAnteprimaAllegato.show((Window)this.mainStage);
        }
    }

    private void ShowCondizioniUso(String condizioniInUso) {
        this.popupCondizioniUso = new Stage();
        this.popupCondizioniUso.initModality(Modality.APPLICATION_MODAL);
        this.popupCondizioniUso.initStyle(StageStyle.UNDECORATED);
        this.popupCondizioniUso.setTitle("MyInvoice");
        this.popupCondizioniUso.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("res/icon.png").toString()));
        this.popupCondizioniUso.setIconified(false);
        this.popupCondizioniUso.setResizable(false);
        VBox vboxCondizioniUso = new VBox();
        vboxCondizioniUso = this.createWindowCondizioniUso(condizioniInUso);
        vboxCondizioniUso.setStyle("-fx-padding: 8; -fx-background-color: #CEE3ED; -fx-background-radius: 1em;-fx-border-width: 1.5; -fx-border-radius: 1em;-fx-border-color: linear-gradient(to bottom, #2EAFEB, derive(#2EAFEB, 50%));");
        Scene scene = new Scene((Parent)vboxCondizioniUso, 800.0, 600.0);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("res/ControlStyle.css").toExternalForm());
        this.popupCondizioniUso.setScene(scene);
        this.popupCondizioniUso.showAndWait();
    }

    private void ShowConfigProxy() {
        VBox vboxConfigProxy = new VBox();
        vboxConfigProxy = this.createWindowConfigProxy();
        if (vboxConfigProxy != null) {
            this.popOverConfigProxy.setAnimated(true);
            this.popOverConfigProxy.setTitle("Configurazione connessione Internet");
            this.popOverConfigProxy.setHeaderAlwaysVisible(true);
            this.popOverConfigProxy.setCornerRadius(5.0);
            this.popOverConfigProxy.setHideOnEscape(true);
            this.popOverConfigProxy.setAutoHide(false);
            this.popOverConfigProxy.setAutoFix(true);
            this.popOverConfigProxy.setDetachable(false);
            this.popOverConfigProxy.setArrowSize(0.0);
            this.popOverConfigProxy.setContentNode((Node)vboxConfigProxy);
            this.popOverConfigProxy.show((Window)this.mainStage);
        }
    }

    private void exit(Event event) {
        Optional<ButtonType> result = this.myFunctions.alert("MyInvoice", "Si desidera uscire?", "", this.myFunctions.imageViewLogo, Alert.AlertType.CONFIRMATION, true);
        if (result.get() == ButtonType.OK) {
            this.myFunctions.deleteAllTmp(new File(this.myFunctions.getPathTmp()));
            Platform.exit();
            System.exit(0);
        } else {
            event.consume();
        }
    }

    private void createMenuOSX() {
        if (DesktopApi.getOs() == DesktopApi.EnumOS.macos) {
            MenuToolkit tk = MenuToolkit.toolkit();
            Menu defaultApplicationMenu = tk.createDefaultApplicationMenu("MyInvoice");
            tk.setApplicationMenu(defaultApplicationMenu);
            ((MenuItem)defaultApplicationMenu.getItems().get(0)).setText("Informazioni su MyInvoice");
            ((MenuItem)defaultApplicationMenu.getItems().get(0)).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ViewMain.this.ShowInfoApp((Node)ViewMain.this.btnSettings);
                }
            });
            ((MenuItem)defaultApplicationMenu.getItems().get(6)).setText("Chiudi");
            ((MenuItem)defaultApplicationMenu.getItems().get(6)).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ViewMain.this.exit((Event)event);
                }
            });
        }
    }

    private void previewFiles(String filename) {
        if (filename != null && !filename.isEmpty()) {
            this.loadFile("file:///" + filename);
        }
    }

    private void loadFile(String file) {
        Platform.runLater(() -> engine.load(file));
    }

    private VBox createWindowPrint(final List<String> files) {
        final TextField textCopies = new TextField();
        final ToggleGroup groupLayout = new ToggleGroup();
        RadioButton optPortrait = new RadioButton("Verticale");
        optPortrait.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
        RadioButton optLandscape = new RadioButton("Orizzontale");
        optLandscape.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
        final ImageView imgLayout = new ImageView();
        Label lblPrinters = new Label("Seleziona stampante:");
        lblPrinters.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
        final ComboBox comboBoxPrinters = new ComboBox();
        Platform.runLater(() -> {
            if (DesktopApi.getOs() == DesktopApi.EnumOS.macos) {
                try {
                    Runtime.getRuntime().exec("lpstat -p");
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            ObservableList options = FXCollections.observableArrayList((Collection)Printer.getAllPrinters());
            comboBoxPrinters.setItems(options);
            if (DesktopApi.getOs() == DesktopApi.EnumOS.macos) {
                this.createMenuOSX();
            }
            if (options.size() == 0) {
                this.myFunctions.notifier("Attenzione", "Verificare di aver installato almeno una stampante prima di continuare!", Alert.AlertType.WARNING, 2000.0);
                return;
            }
            comboBoxPrinters.setValue((Object)Printer.getDefaultPrinter());
            comboBoxPrinters.setEditable(false);
            comboBoxPrinters.getStyleClass().add((Object)"combo-box-print");
        });
        Label lblCopies = new Label("Numero copie:");
        lblCopies.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-weight: normal");
        textCopies.setAlignment(Pos.CENTER_RIGHT);
        textCopies.getStyleClass().add((Object)"text-field-print");
        Pattern validNumberText = Pattern.compile("[0-9]*");
        TextFormatter textFormatter = new TextFormatter(change -> {
            String newText = change.getControlNewText();
            if (validNumberText.matcher(newText).matches() && newText.length() <= 3) {
                if (!newText.isEmpty()) {
                    if (Integer.valueOf(newText) >= 1) {
                        return change;
                    }
                    return null;
                }
                return null;
            }
            return null;
        });
        textCopies.setTextFormatter(textFormatter);
        textCopies.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().toString().equals("ENTER") && (!textCopies.getText().isEmpty() || comboBoxPrinters.getValue() != null) && Integer.valueOf(textCopies.getText()) >= 1) {
                    ViewMain.this.sceneMain.setCursor(Cursor.WAIT);
                    Task<Void> task = new Task<Void>(){

                        public Void call() {
                            try {
                                ViewMain.this.myFunctions.printFile(files, 0, (Printer)comboBoxPrinters.getValue(), Integer.valueOf(textCopies.getText()), (PageOrientation)groupLayout.getSelectedToggle().getUserData());
                            }
                            catch (Exception e2) {
                                ViewMain.this.sceneMain.setCursor(Cursor.DEFAULT);
                            }
                            return null;
                        }
                    };
                    task.setOnSucceeded(e2 -> {
                        ViewMain.this.sceneMain.setCursor(Cursor.DEFAULT);
                        ViewMain.this.popOverPrint.hide();
                    });
                    new Thread((Runnable)task).start();
                }
            }
        });
        textCopies.setText("1");
        HBox hboxCopies = new HBox();
        hboxCopies.setSpacing(10.0);
        hboxCopies.setAlignment(Pos.CENTER_RIGHT);
        hboxCopies.getChildren().addAll((Object[])new Node[]{lblCopies, textCopies});
        TitledPane tpLayout = new TitledPane();
        tpLayout.setText("Orientamento:");
        tpLayout.setStyle("-fx-text-fill: black;-fx-font-size: 9pt;-fx-font-family: 'Arial';-fx-font-style: normal");
        tpLayout.setAnimated(false);
        tpLayout.setCollapsible(false);
        tpLayout.setPrefHeight(170.0);
        tpLayout.getStyleClass().add((Object)"paneTitleprint");
        optPortrait.setToggleGroup(groupLayout);
        optPortrait.setUserData((Object)PageOrientation.PORTRAIT);
        optPortrait.setSelected(true);
        optLandscape.setToggleGroup(groupLayout);
        optLandscape.setUserData((Object)PageOrientation.LANDSCAPE);
        imgLayout.setImage(new Image(((Object)((Object)this)).getClass().getResource("res/portrait.png").toString()));
        groupLayout.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> ov, Toggle old_toggle, Toggle new_toggle) {
                if (groupLayout.getSelectedToggle() != null) {
                    if (groupLayout.getSelectedToggle().getUserData() == PageOrientation.PORTRAIT) {
                        imgLayout.setImage(new Image(this.getClass().getResource("res/portrait.png").toString()));
                    } else {
                        imgLayout.setImage(new Image(this.getClass().getResource("res/landscape.png").toString()));
                    }
                }
            }
        });
        VBox vboxLayout = new VBox();
        vboxLayout.setSpacing(10.0);
        vboxLayout.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        vboxLayout.getChildren().addAll((Object[])new Node[]{optPortrait, optLandscape, imgLayout});
        HBox hboxLayout = new HBox();
        hboxLayout.setSpacing(10.0);
        hboxLayout.setAlignment(Pos.CENTER);
        hboxLayout.getChildren().addAll((Object[])new Node[]{vboxLayout, imgLayout});
        tpLayout.setContent((Node)hboxLayout);
        VBox vboxUtility = new VBox();
        vboxUtility.setSpacing(10.0);
        vboxUtility.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        vboxUtility.getChildren().addAll((Object[])new Node[]{lblPrinters, comboBoxPrinters, hboxCopies, tpLayout});
        HBox hboxOkAnnulla = new HBox();
        hboxOkAnnulla.setSpacing(10.0);
        hboxOkAnnulla.setAlignment(Pos.CENTER_RIGHT);
        Button btnOK = new Button("OK");
        btnOK.getStyleClass().add((Object)"buttonActionsPrint");
        btnOK.setOnAction(event -> {
            if (Integer.valueOf(textCopies.getText()) >= 1) {
                this.sceneMain.setCursor(Cursor.WAIT);
                Task<Void> task = new Task<Void>(){

                    public Void call() {
                        try {
                            ViewMain.this.myFunctions.printFile(files, 0, (Printer)comboBoxPrinters.getValue(), Integer.valueOf(textCopies.getText()), (PageOrientation)groupLayout.getSelectedToggle().getUserData());
                        }
                        catch (Exception e2) {
                            ViewMain.this.sceneMain.setCursor(Cursor.DEFAULT);
                        }
                        return null;
                    }
                };
                task.setOnSucceeded(e2 -> {
                    this.sceneMain.setCursor(Cursor.DEFAULT);
                    this.popOverPrint.hide();
                });
                new Thread((Runnable)task).start();
            }
        });
        VBox vboxOk = new VBox();
        vboxOk.setAlignment(Pos.CENTER_RIGHT);
        vboxOk.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        vboxOk.getChildren().add((Object)btnOK);
        VBox vboxPrinters = new VBox();
        vboxPrinters.setSpacing(10.0);
        vboxPrinters.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vboxPrinters.getChildren().addAll((Object[])new Node[]{vboxUtility, vboxOk});
        return vboxPrinters;
    }

    private VBox createWindowAnteprimaAllegato(Invoice item) {
        Label lblAllegati = new Label("Seleziona l'allegato");
        ObservableList listAllegati = FXCollections.observableArrayList((Collection)FXCollections.observableList(item.getAttachments()));
        ComboBox cbAllegati = new ComboBox(listAllegati);
        cbAllegati.getSelectionModel().selectFirst();
        cbAllegati.valueProperty().addListener((ChangeListener)new ChangeListener<Attachments>(){

            public void changed(ObservableValue ov, Attachments t, Attachments t1) {
                ViewMain.this.CaricaAllegatoInAnteprima(t1);
            }
        });
        HBox hboxElenco = new HBox();
        hboxElenco.setSpacing(10.0);
        hboxElenco.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        hboxElenco.setAlignment(Pos.BOTTOM_LEFT);
        hboxElenco.getChildren().addAll((Object[])new Node[]{lblAllegati, cbAllegati});
        this.browserAnteprima = new WebView();
        this.browserAnteprima.setMinWidth(896.0);
        this.browserAnteprima.setMinHeight(696.0);
        this.browserAnteprima.setMaxWidth(896.0);
        this.browserAnteprima.setMaxHeight(696.0);
        this.webEngineAnteprima = this.browserAnteprima.getEngine();
        this.CaricaAllegatoInAnteprima((Attachments)cbAllegati.getValue());
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setMinWidth(900.0);
        scrollPane.setMinHeight(700.0);
        scrollPane.setMaxWidth(900.0);
        scrollPane.setMaxHeight(700.0);
        scrollPane.setContent((Node)this.browserAnteprima);
        VBox vboxAnteprima = new VBox();
        vboxAnteprima.setSpacing(10.0);
        vboxAnteprima.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vboxAnteprima.getChildren().addAll((Object[])new Node[]{hboxElenco, scrollPane});
        return vboxAnteprima;
    }

    private VBox createWindowCondizioniUso(String condizioniInUso) {
        String headerText = "";
        headerText = applicationVersion != "" ? "Condizioni d'uso - MyInvoice " + applicationVersion : "Condizioni d'uso - MyInvoice";
        Label lblTitleApp = new Label(headerText);
        lblTitleApp.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0));
        WebView view1 = new WebView();
        WebEngine engine1 = view1.getEngine();
        try {
            this.myFunctions.CopiaFileResInLocaleSeNecessario("CondizioniContrattuali.htm", true);
            engine1.load("file:///" + this.myFunctions.getPathTmp() + "CondizioniContrattuali.htm");
        }
        catch (Exception ex) {
            engine1.loadContent("Impossibile caricare il file CondizioniContrattuali.htm");
        }
        Button btnApprovo1 = new Button("Approvo");
        btnApprovo1.getStyleClass().add((Object)"buttonConferma");
        btnApprovo1.setCursor(Cursor.HAND);
        Button btnNonApprovo1 = new Button("Non approvo");
        btnNonApprovo1.getStyleClass().add((Object)"buttonConferma");
        btnNonApprovo1.setCursor(Cursor.HAND);
        HBox hboxPulsanti1 = new HBox();
        hboxPulsanti1.setSpacing(10.0);
        hboxPulsanti1.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        hboxPulsanti1.setAlignment(Pos.BOTTOM_RIGHT);
        hboxPulsanti1.getChildren().addAll((Object[])new Node[]{btnApprovo1, btnNonApprovo1});
        btnApprovo1.setOnAction(event -> {
            this.myFunctions.setCondizioniUso(condizioniInUso);
            this.popupCondizioniUso.close();
        });
        btnNonApprovo1.setOnAction(event -> {
            this.myFunctions.setCondizioniUso("");
            this.exit(event);
        });
        VBox vboxCondizioniUso = new VBox();
        vboxCondizioniUso.setSpacing(10.0);
        vboxCondizioniUso.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vboxCondizioniUso.getChildren().addAll((Object[])new Node[]{lblTitleApp, view1, hboxPulsanti1});
        return vboxCondizioniUso;
    }

    private VBox createWindowConfigProxy() {
        final CheckBox chkUsaProxy = new CheckBox("Utilizza un server proxy per la connessione Internet");
        chkUsaProxy.setCursor(Cursor.HAND);
        chkUsaProxy.setSelected(this.myFunctions.getProxyAbilitato());
        chkUsaProxy.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                ViewMain.this.tbProxyIndirizzoIP.setDisable(!chkUsaProxy.isSelected());
                ViewMain.this.tbProxyPorta.setDisable(!chkUsaProxy.isSelected());
                ViewMain.this.tbProxyUsername.setDisable(!chkUsaProxy.isSelected());
                ViewMain.this.tbProxyPassword.setDisable(!chkUsaProxy.isSelected());
            }
        });
        Label lbParametriProxy = new Label("PARAMETRI SERVER PROXY");
        Label lbIndirizzoIP = new Label("Indirizzo IP:");
        lbIndirizzoIP.setMinWidth(80.0);
        this.tbProxyIndirizzoIP = new TextField();
        this.tbProxyIndirizzoIP.getStyleClass().add((Object)"text-field-proxy");
        this.tbProxyIndirizzoIP.setText(this.myFunctions.getProxyIndirizzoIP());
        HBox hboxIndirizzoIP = new HBox();
        hboxIndirizzoIP.getChildren().addAll((Object[])new Node[]{lbIndirizzoIP, this.tbProxyIndirizzoIP});
        Label lbPorta = new Label("Porta:");
        lbPorta.setMinWidth(80.0);
        this.tbProxyPorta = new TextField();
        this.tbProxyPorta.getStyleClass().add((Object)"text-field-proxy");
        this.tbProxyPorta.setText(this.myFunctions.getProxyPorta());
        HBox hboxPorta = new HBox();
        hboxPorta.getChildren().addAll((Object[])new Node[]{lbPorta, this.tbProxyPorta});
        Label lbUsername = new Label("Username:");
        lbUsername.setMinWidth(80.0);
        this.tbProxyUsername = new TextField();
        this.tbProxyUsername.getStyleClass().add((Object)"text-field-proxy");
        this.tbProxyUsername.setText(this.myFunctions.getProxyUsername());
        HBox hboxUsername = new HBox();
        hboxUsername.getChildren().addAll((Object[])new Node[]{lbUsername, this.tbProxyUsername});
        Label lbPassword = new Label("Password:");
        lbPassword.setMinWidth(80.0);
        this.tbProxyPassword = new PasswordField();
        this.tbProxyPassword.getStyleClass().add((Object)"text-field-proxy");
        this.tbProxyPassword.setText(this.myFunctions.getProxyPassword());
        HBox hboxPassword = new HBox();
        hboxPassword.getChildren().addAll((Object[])new Node[]{lbPassword, this.tbProxyPassword});
        Button btnConferma = new Button("Conferma");
        btnConferma.getStyleClass().add((Object)"buttonConferma");
        btnConferma.setCursor(Cursor.HAND);
        btnConferma.setOnAction(event -> {
            this.myFunctions.setProxyAbilitato(chkUsaProxy.isSelected());
            this.myFunctions.setProxyIndirizzoIP(this.tbProxyIndirizzoIP.getText());
            this.myFunctions.setProxyPorta(this.tbProxyPorta.getText());
            this.myFunctions.setProxyUsername(this.tbProxyUsername.getText());
            this.myFunctions.setProxyPassword(this.tbProxyPassword.getText());
            this.popOverConfigProxy.hide();
        });
        Button btnAnnulla = new Button("Annulla");
        btnAnnulla.getStyleClass().add((Object)"buttonConferma");
        btnAnnulla.setCursor(Cursor.HAND);
        btnAnnulla.setOnAction(event -> this.popOverConfigProxy.hide());
        HBox hboxPulsanti = new HBox();
        hboxPulsanti.setSpacing(20.0);
        hboxPulsanti.setAlignment(Pos.CENTER);
        hboxPulsanti.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        hboxPulsanti.getChildren().addAll((Object[])new Node[]{btnConferma, btnAnnulla});
        VBox vboxConfigProxy = new VBox();
        vboxConfigProxy.setSpacing(10.0);
        vboxConfigProxy.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vboxConfigProxy.getChildren().addAll((Object[])new Node[]{chkUsaProxy, lbParametriProxy, hboxIndirizzoIP, hboxPorta, hboxUsername, hboxPassword, hboxPulsanti});
        this.tbProxyIndirizzoIP.setDisable(!chkUsaProxy.isSelected());
        this.tbProxyPorta.setDisable(!chkUsaProxy.isSelected());
        this.tbProxyUsername.setDisable(!chkUsaProxy.isSelected());
        this.tbProxyPassword.setDisable(!chkUsaProxy.isSelected());
        return vboxConfigProxy;
    }

    private void CaricaAllegatoInAnteprima(Attachments allegato) {
        FileOutputStream fos22;
        Throwable throwable;
        String htmlMsg = "<b>Anteprima non disponibile</b><br>";
        Boolean bErroreAnteprima = false;
        String nomeNormalizzato = this.myFunctions.NormalizzaNomeFile(allegato.getNome());
        String nomeFileAllegato = (String.valueOf(this.myFunctions.getPathTmp()) + nomeNormalizzato).replace("\\", "//");
        try {
            Throwable throwable2 = null;
            throwable = null;
            try {
                fos22 = new FileOutputStream(nomeFileAllegato);
                try {
                    fos22.write(Base64.getMimeDecoder().decode(allegato.getAttachment()));
                    fos22.close();
                }
                finally {
                    if (fos22 != null) {
                        fos22.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException ex) {
            nomeNormalizzato = "allegato_" + Integer.toString(allegato.hashCode());
            if (allegato.getFormato() != null) {
                nomeNormalizzato = String.valueOf(nomeNormalizzato) + "." + allegato.getFormato();
            }
            nomeFileAllegato = (String.valueOf(this.myFunctions.getPathTmp()) + nomeNormalizzato).replace("\\", "//");
            try {
                throwable = null;
                fos22 = null;
                try (FileOutputStream fos = new FileOutputStream(nomeFileAllegato);){
                    fos.write(Base64.getMimeDecoder().decode(allegato.getAttachment()));
                    fos.close();
                }
                catch (Throwable fos22) {
                    if (throwable == null) {
                        throwable = fos22;
                    } else if (throwable != fos22) {
                        throwable.addSuppressed(fos22);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex2) {
                htmlMsg = String.valueOf(htmlMsg) + "Errore durante il salvataggio dell'allegato nella cartella temporanea.<br>";
                bErroreAnteprima = true;
                nomeFileAllegato = "";
            }
        }
        String strFormatoAllegato = FilenameUtils.getExtension(nomeFileAllegato);
        this.webEngineAnteprima.loadContent("");
        if (strFormatoAllegato.equalsIgnoreCase("pdf")) {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            File fileViewerHtml = new File(String.valueOf(this.myFunctions.getPathTmp()) + "viewer/viewer.html");
            File fileViewerOrigJs = new File(String.valueOf(this.myFunctions.getPathTmp()) + "viewer/viewer.orig.js");
            File fileViewerJs = new File(String.valueOf(this.myFunctions.getPathTmp()) + "viewer/viewer.js");
            File filePdfJs = new File(String.valueOf(this.myFunctions.getPathTmp()) + "viewer/pdf.js");
            File filePdfWorkerJs = new File(String.valueOf(this.myFunctions.getPathTmp()) + "viewer/pdf.worker.js");
            try {
                FileUtils.copyInputStreamToFile(classLoader.getResourceAsStream("res/viewer/viewer.html"), fileViewerHtml);
                FileUtils.copyInputStreamToFile(classLoader.getResourceAsStream("res/viewer/viewer.orig.js"), fileViewerOrigJs);
                FileUtils.copyInputStreamToFile(classLoader.getResourceAsStream("res/viewer/viewer.js"), fileViewerJs);
                FileUtils.copyInputStreamToFile(classLoader.getResourceAsStream("res/viewer/pdf.js"), filePdfJs);
                FileUtils.copyInputStreamToFile(classLoader.getResourceAsStream("res/viewer/pdf.worker.js"), filePdfWorkerJs);
            }
            catch (Exception ex) {
                htmlMsg = String.valueOf(htmlMsg) + "Errore files viewer mancanti.<br>";
                bErroreAnteprima = true;
            }
            if (!bErroreAnteprima.booleanValue()) {
                try {
                    String s;
                    FileReader fr = new FileReader(fileViewerOrigJs.getAbsolutePath());
                    String totalStr = "";
                    BufferedReader br = new BufferedReader(fr);
                    while ((s = br.readLine()) != null) {
                        totalStr = String.valueOf(totalStr) + s + System.lineSeparator();
                    }
                    br.close();
                    totalStr = totalStr.replaceAll("INSERIRE_QUI_IL_NOME_FILE_PDF", "file:///" + nomeFileAllegato);
                    FileWriter fw = new FileWriter(fileViewerJs.getAbsolutePath());
                    fw.write(totalStr);
                    fw.close();
                }
                catch (IOException ex) {
                    htmlMsg = String.valueOf(htmlMsg) + "Errore durante la valorizzazione del tag contenente il nome del file PDF.<br>";
                    bErroreAnteprima = true;
                }
            }
            if (!bErroreAnteprima.booleanValue()) {
                try {
                    this.webEngineAnteprima.load("file:///" + fileViewerHtml.getAbsolutePath());
                }
                catch (Exception ex) {
                    htmlMsg = String.valueOf(htmlMsg) + "Errore durante il caricamento del file da visualizzare.<br>";
                    bErroreAnteprima = true;
                }
            }
        } else if (strFormatoAllegato.equalsIgnoreCase("jpg") || strFormatoAllegato.equalsIgnoreCase("png") || strFormatoAllegato.equalsIgnoreCase("bmp")) {
            try {
                this.webEngineAnteprima.load("file:///" + nomeFileAllegato);
            }
            catch (Exception ex) {
                htmlMsg = String.valueOf(htmlMsg) + "Errore durante il caricamento del file da visualizzare.<br>";
                bErroreAnteprima = true;
            }
        } else {
            htmlMsg = String.valueOf(htmlMsg) + "Formato del file " + strFormatoAllegato + " non supportato.";
            bErroreAnteprima = true;
        }
        if (bErroreAnteprima.booleanValue()) {
            this.webEngineAnteprima.loadContent(htmlMsg);
        }
    }

    private void Loader() {
        ImageView imgLoader = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/loghi/logo.png").toString()));
        ImageView imgLoading = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/loadingSplash.gif").toString()));
        VBox vBoxLoader = new VBox();
        vBoxLoader.setSpacing(10.0);
        this.labelProgress.setAlignment(Pos.CENTER);
        this.labelProgress.setTextAlignment(TextAlignment.CENTER);
        this.labelProgress.setFont(this.customFont);
        this.labelProgress.setPrefWidth(380.0);
        this.pProgress = new ProgressBar();
        this.pProgress.setPrefWidth(360.0);
        Hyperlink linkInterrompiCaricamento = new Hyperlink();
        linkInterrompiCaricamento.setPadding(new Insets(-5.0, 0.0, 0.0, 0.0));
        linkInterrompiCaricamento.setText("(clicca per interrompere il caricamento in corso)");
        linkInterrompiCaricamento.setFont(new Font("Arial", 12.0));
        linkInterrompiCaricamento.setStyle("-fx-focus-color: transparent;");
        linkInterrompiCaricamento.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e2) {
                ViewMain.this.interrompiCaricamento = true;
            }
        });
        vBoxLoader.setAlignment(Pos.CENTER);
        vBoxLoader.getChildren().addAll((Object[])new Node[]{imgLoader, this.pProgress, imgLoading, this.labelProgress, linkInterrompiCaricamento});
        VBox.setVgrow((Node)this.labelProgress, (Priority)Priority.ALWAYS);
        this.loaderLayout = new VBox();
        this.loaderLayout.getChildren().addAll((Object[])new Node[]{vBoxLoader});
        this.loaderLayout.setStyle("-fx-padding: 8; -fx-background-color: #CEE3ED; -fx-background-radius: 1em;-fx-border-width: 1.5; -fx-border-radius: 1em;-fx-border-color: linear-gradient(to bottom, #2EAFEB, derive(#2EAFEB, 50%));");
        this.loaderLayout.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("res/ControlStyle.css").toExternalForm());
        Scene splashScene = new Scene((Parent)this.loaderLayout, (Paint)Color.TRANSPARENT);
        this.pProgress.progressProperty().unbind();
        this.pProgress.setProgress(1.0);
        this.loaderStage = new Stage();
        this.loaderStage.setTitle("MyInvoice");
        this.loaderStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("res/icon.png").toString()));
        this.loaderStage.setScene(splashScene);
        this.loaderStage.setResizable(false);
        this.loaderStage.setMaximized(false);
        this.loaderStage.setIconified(false);
        this.loaderStage.resizableProperty().setValue(Boolean.FALSE);
        this.loaderStage.centerOnScreen();
        this.loaderStage.initStyle(StageStyle.TRANSPARENT);
        this.loaderStage.getScene().setCursor(Cursor.NONE);
        this.loaderStage.setAlwaysOnTop(true);
        this.loaderStage.show();
        Platform.runLater(() -> splashScene.setCursor(Cursor.WAIT));
    }

    private void RicaricaFatturaCorrente() {
        Invoice fattura;
        if (this.listViewFatture.getSelectionModel().getSelectedItem() != null && (fattura = (Invoice)this.listViewFatture.getSelectionModel().getSelectedItem()) != null) {
            String returnFilename = this.myFunctions.applyStyleSheetsXml(new File(fattura.getPathXML()));
            this.previewFiles(returnFilename);
        }
    }

    private /* synthetic */ void lambda$26(Task task, WorkerStateEvent e2) {
        Platform.runLater(() -> this.sceneMain.setCursor(Cursor.WAIT));
        this.labelProgress.textProperty().bind((ObservableValue)task.messageProperty());
        this.pProgress.progressProperty().bind((ObservableValue)task.progressProperty());
        this.DisableControl(true);
    }

    private /* synthetic */ void lambda$28(Task task, File file, WorkerStateEvent e2) {
        Platform.runLater(() -> this.sceneMain.setCursor(Cursor.DEFAULT));
        this.labelProgress.textProperty().bind((ObservableValue)task.messageProperty());
        this.pProgress.progressProperty().unbind();
        this.pProgress.setProgress(1.0);
        this.loaderStage.close();
        this.DisableControl(false);
        this.mainStage.setTitle("MyInvoice");
        this.BuildListView();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ViewMain.this.myFunctions.Logga("Inizio Run loading fatture CaricaAnniFatture");
                ViewMain.this.CaricaAnniFatture();
                ViewMain.this.tabPaneMonths.getSelectionModel().select(0);
                ViewMain.this.myFunctions.Logga("Fine Run loading fatture CaricaAnniFatture");
            }
        });
        this.myFunctions.Logga("Loading fatture terminato");
        this.myFunctions.Logga("   listFatture.size=" + this.listFatture.size());
        this.myFunctions.Logga("   errorLoading=" + this.errorLoading);
        if (this.interrompiCaricamento) {
            this.myFunctions.notifier("Attenzione", "Il caricamento \u00e8 stato interrotto dall'utente", Alert.AlertType.ERROR, 2500.0);
            this.interrompiCaricamento = false;
        }
        if (this.errorLoading > 0) {
            String strMsg = "Un documento non \u00e8 stato importato per errori durante l'elaborazione!";
            if (this.errorLoading > 1) {
                strMsg = String.format("%d documenti non sono stati importati per errori durante l'elaborazione!", this.errorLoading);
            }
            this.myFunctions.notifier("Attenzione", strMsg, Alert.AlertType.WARNING, 5000.0);
        }
        if (this.myFunctions.getStyleSheetsFatt() == null) {
            this.myFunctions.notifier("Attenzione", "Non \u00e8 stato associato un foglio di stile!\nControllare le impostazioni!", Alert.AlertType.WARNING, 5000.0);
        }
        if (this.listFatture.size() > 0) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ViewMain.this.myFunctions.Logga("Inizio Run loading fatture listFatture");
                    ViewMain.this.evitaAggiornaFattureFiltrate = true;
                    ViewMain.this.listViewCedentePrestatore.getSelectionModel().select(0);
                    ViewMain.this.listViewCessionarioCommittente.getSelectionModel().select(0);
                    ViewMain.this.listViewFatture.getSelectionModel().select(0);
                    ViewMain.this.evitaAggiornaFattureFiltrate = false;
                    ViewMain.this.myFunctions.Logga("Fine Run loading fatture listFatture");
                }
            });
            settings.put("directoryDefault", file.getAbsolutePath());
            this.labelNomeDirectory.setText(file.getAbsolutePath());
            this.labelNomeDirectory.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0));
            this.labelNomeDirectory.setTextFill((Paint)this.colAzzurro);
        } else {
            this.myFunctions.notifier("Attenzione", "Nessuna fattura elettronica trovata!\nCambiare la directory di lavoro.", Alert.AlertType.WARNING, 2500.0);
        }
        this.evitaAggiornaFattureFiltrate = false;
        this.myFunctions.Logga("Fine loading fatture");
    }
}

