/*
 * Decompiled with CFR 0.152.
 */
import de.codecentric.centerdevice.MenuToolkit;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.prefs.Preferences;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.FilenameUtils;
import utility.DesktopApi;
import utility.Functions;

public class ViewSplash
extends Application {
    private static final int SPLASH_WIDTH = 400;
    private Pane splashLayout;
    private Label labelProgress;
    private Stage mainStage;
    private static Preferences preferences = Preferences.userRoot();
    private static Preferences settings = preferences.node("settings");
    private static Functions functions = new Functions();
    private Font customFont = Font.loadFont((String)((Object)((Object)this)).getClass().getResource("/res/EngraversGothic.ttf").toExternalForm(), (double)16.0);

    public static void main(String[] args) throws GeneralSecurityException, IOException {
        ViewSplash.launch((String[])args);
    }

    public void init() {
        ImageView splash = new ImageView();
        splash.setImage(new Image(((Object)((Object)this)).getClass().getResource("res/loghi/logo_splash.png").toString()));
        ImageView abletech = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/loghi/abletech.png").toString()));
        abletech.setPreserveRatio(true);
        VBox vBoxSplash = new VBox();
        vBoxSplash.setSpacing(10.0);
        HBox hBoxSplash = new HBox();
        hBoxSplash.setSpacing(10.0);
        hBoxSplash.setAlignment(Pos.CENTER);
        hBoxSplash.getChildren().addAll((Object[])new Node[]{splash});
        VBox vBoxAbletech = new VBox();
        vBoxAbletech.setSpacing(20.0);
        HBox hBoxAbletech = new HBox();
        hBoxAbletech.setSpacing(10.0);
        hBoxAbletech.setAlignment(Pos.BOTTOM_RIGHT);
        hBoxAbletech.getChildren().addAll((Object[])new Node[]{abletech});
        vBoxAbletech.getChildren().addAll((Object[])new Node[]{hBoxAbletech});
        this.labelProgress = new Label("Avvio in corso");
        this.labelProgress.setAlignment(Pos.CENTER);
        this.labelProgress.setFont(this.customFont);
        this.labelProgress.setPrefWidth(380.0);
        ImageView imgLoader = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("res/loadingSplash.gif").toString()));
        vBoxSplash.setAlignment(Pos.CENTER);
        vBoxSplash.setPrefHeight(150.0);
        vBoxSplash.getChildren().addAll((Object[])new Node[]{hBoxSplash, this.labelProgress, imgLoader});
        this.splashLayout = new VBox();
        this.splashLayout.getChildren().addAll((Object[])new Node[]{vBoxSplash, vBoxAbletech});
        this.splashLayout.setStyle("-fx-padding: 8; -fx-background-color: #CEE3ED; -fx-background-radius: 1em;-fx-border-width: 1.5; -fx-border-radius: 1em;-fx-border-color: linear-gradient(to bottom, #2EAFEB, derive(#2EAFEB, 50%));");
        this.splashLayout.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("res/ControlStyle.css").toExternalForm());
    }

    public void start(Stage primaryStage) throws Exception {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws InterruptedException {
                Thread.sleep(3000L);
                return null;
            }
        };
        primaryStage.setTitle("MyInvoice");
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("res/icon.png").toString()));
        if (DesktopApi.getOs() == DesktopApi.EnumOS.macos) {
            MenuToolkit tk = MenuToolkit.toolkit();
            Menu defaultApplicationMenu = tk.createDefaultApplicationMenu("MyInvoice");
            tk.setApplicationMenu(defaultApplicationMenu);
            ((MenuItem)defaultApplicationMenu.getItems().get(0)).setText("Informazioni su MyInvoice");
            ((MenuItem)defaultApplicationMenu.getItems().get(6)).setText("Chiudi");
            ((MenuItem)defaultApplicationMenu.getItems().get(6)).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    Optional<ButtonType> result = functions.alert("MyInvoice", "Si desidera uscire?", "", functions.imageViewLogo, Alert.AlertType.CONFIRMATION, true);
                    if (result.get() == ButtonType.OK) {
                        functions.deleteAllTmp(new File(functions.getPathTmp()));
                        Platform.exit();
                        System.exit(0);
                    } else {
                        event.consume();
                    }
                }
            });
        }
        this.showSplash(primaryStage, task, () -> {
            try {
                Functions myFunctions = new Functions();
                myFunctions.Logga("--------------------------------------------------------------------------------");
                myFunctions.Logga("Inizio fase inizializzazione [" + myFunctions.getVersion() + "]");
                myFunctions.Logga("user.dir=" + System.getProperty("user.dir"));
                myFunctions.Logga("SourceFolder=" + myFunctions.getSourceFolderFromSetup(""));
                myFunctions.Logga("EnableSettings=" + myFunctions.getEnableSettingsFromSetup(true));
                myFunctions.Logga("Verifica se necessario copiare in locale myinvoice.properties");
                boolean bSovrascriviConEmbeddedFiles = false;
                if (!myFunctions.getVersion().equalsIgnoreCase(myFunctions.getVersioneInUso())) {
                    bSovrascriviConEmbeddedFiles = true;
                    myFunctions.Logga("Copia in locale myinvoice.properties");
                    myFunctions.CopiaFileResInLocaleSeNecessario("myinvoice.properties", true);
                    myFunctions.setVersioneInUso(myFunctions.getVersion());
                }
                boolean bErroreServer = false;
                myFunctions.Logga("Copia in locale " + myFunctions.getXslMyInvoiceWork() + " [SovrascriviConEmbeddedFiles=" + bSovrascriviConEmbeddedFiles + "]");
                myFunctions.CopiaFileResInLocaleSeNecessario(myFunctions.getXslMyInvoiceWork(), bSovrascriviConEmbeddedFiles);
                myFunctions.Logga("url_xsl_myinvoice=" + myFunctions.getUrlXslMyInvoice());
                if (myFunctions.getUrlXslMyInvoice() != null && !bErroreServer) {
                    if (myFunctions.downloadFile(myFunctions.getUrlXslMyInvoice(), myFunctions.getPathTmp())) {
                        int nEsitoAggiornamento;
                        String strNomeFileMyInvoice = FilenameUtils.getName(myFunctions.getUrlXslMyInvoice());
                        if (strNomeFileMyInvoice.contains(".zip")) {
                            ZipFile zipFile = new ZipFile(String.valueOf(myFunctions.getPathTmp()) + "/" + strNomeFileMyInvoice);
                            zipFile.extractAll(myFunctions.getPathTmp());
                            strNomeFileMyInvoice = strNomeFileMyInvoice.replaceAll(".zip", ".xsl");
                        }
                        if ((nEsitoAggiornamento = myFunctions.VerificaAggiornamentoFoglioDiStile(myFunctions.getPathTmp(), strNomeFileMyInvoice, myFunctions.getXslMyInvoiceWork())) > 0) {
                            myFunctions.Logga("Il foglio di stile MyInvoice \u00e8 stato aggiornato dal server.");
                        } else if (nEsitoAggiornamento < 0) {
                            myFunctions.Logga("Rilevato errore nel file sorgente, probabilmente lo zip non contiene il file corretto.");
                        } else {
                            myFunctions.Logga("Il foglio di stile MyInvoice \u00e8 gi\u00e0 aggiornato.");
                        }
                    } else {
                        myFunctions.Logga("Attenzione, non \u00e8 possibile scaricare il foglio di stile MyInvoice dal server.");
                        bErroreServer = true;
                    }
                }
                myFunctions.Logga("Copia in locale " + myFunctions.getXslMinisterialeWork() + " [SovrascriviConEmbeddedFiles=" + bSovrascriviConEmbeddedFiles + "]");
                myFunctions.CopiaFileResInLocaleSeNecessario(myFunctions.getXslMinisterialeWork(), bSovrascriviConEmbeddedFiles);
                myFunctions.Logga("url_xsl_ministeriale=" + myFunctions.getUrlXslMinisteriale());
                if (myFunctions.getUrlXslMinisteriale() != null && !bErroreServer) {
                    if (myFunctions.downloadFile(myFunctions.getUrlXslMinisteriale(), myFunctions.getPathTmp())) {
                        int nEsitoAggiornamento;
                        String strNomeFileMinisteriale = FilenameUtils.getName(myFunctions.getUrlXslMinisteriale());
                        if (strNomeFileMinisteriale.contains(".zip")) {
                            ZipFile zipFile = new ZipFile(String.valueOf(myFunctions.getPathTmp()) + "/" + strNomeFileMinisteriale);
                            zipFile.extractAll(myFunctions.getPathTmp());
                            strNomeFileMinisteriale = strNomeFileMinisteriale.replaceAll(".zip", ".xsl");
                        }
                        if ((nEsitoAggiornamento = myFunctions.VerificaAggiornamentoFoglioDiStile(myFunctions.getPathTmp(), strNomeFileMinisteriale, myFunctions.getXslMinisterialeWork())) > 0) {
                            myFunctions.Logga("Il foglio di stile ministeriale \u00e8 stato aggiornato dal server.");
                        } else if (nEsitoAggiornamento < 0) {
                            myFunctions.Logga("Rilevato errore nel file sorgente, probabilmente lo zip non contiene il file corretto.");
                        } else {
                            myFunctions.Logga("Il foglio di stile ministeriale \u00e8 gi\u00e0 aggiornato.");
                        }
                    } else {
                        myFunctions.Logga("Attenzione, non \u00e8 possibile scaricare il foglio di stile ministeriale dal server.");
                    }
                }
                myFunctions.setStyleSheetsFatt(String.valueOf(myFunctions.getPathTmp()) + myFunctions.getXslInUso());
                settings.put("styleSheetsDefaulPath", String.valueOf(myFunctions.getPathTmp()) + myFunctions.getXslInUso());
                settings.put("styleSheetsDefaulName", myFunctions.getXslInUso());
                myFunctions.Logga("Fine fase inizializzazione");
                myFunctions.Logga("--------------------------------------------------------------------------------");
                this.showMainStage();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        });
        new Thread((Runnable)task).start();
    }

    private void showSplash(Stage initStage, Task<?> task, InitCompletionHandler initCompletionHandler) {
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                initStage.toFront();
                FadeTransition fadeSplash = new FadeTransition(new Duration(1500.0), (Node)initStage.getScene().getRoot());
                fadeSplash.setFromValue(1.0);
                fadeSplash.setToValue(0.0);
                fadeSplash.setCycleCount(1);
                fadeSplash.setInterpolator(Interpolator.LINEAR);
                fadeSplash.setOnFinished(actionEvent -> initStage.hide());
                fadeSplash.play();
                initCompletionHandler.complete();
            }
        });
        Scene splashScene = new Scene((Parent)this.splashLayout, (Paint)Color.TRANSPARENT);
        Screen.getPrimary().getVisualBounds();
        initStage.setScene(splashScene);
        initStage.setResizable(false);
        initStage.resizableProperty().setValue(Boolean.FALSE);
        initStage.centerOnScreen();
        initStage.initStyle(StageStyle.TRANSPARENT);
        if (DesktopApi.getOs() == DesktopApi.EnumOS.linux) {
            initStage.getScene().setCursor(Cursor.NONE);
        }
        initStage.setAlwaysOnTop(true);
        initStage.show();
    }

    private void showMainStage() throws Exception {
        this.mainStage = new Stage(StageStyle.DECORATED);
        this.mainStage.setTitle("MyInvoice");
        this.mainStage.setHeight(700.0);
        this.mainStage.setMinHeight(700.0);
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        if (DesktopApi.getOs() != DesktopApi.EnumOS.macos) {
            this.mainStage.setWidth(primaryScreenBounds.getWidth() / 2.0);
            this.mainStage.setMinWidth(primaryScreenBounds.getWidth() / 2.0);
            this.mainStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("res/icon.png").toString()));
        } else {
            this.mainStage.setWidth(920.0);
            this.mainStage.setMinWidth(700.0);
        }
        ViewMain main = new ViewMain(functions);
        main.start(this.mainStage);
    }

    public static interface InitCompletionHandler {
        public void complete();
    }
}

