/*
 * Decompiled with CFR 0.152.
 */
package com.independentsoft.io.structuredstorage;

import com.independentsoft.io.structuredstorage.DirectoryEntryList;
import com.independentsoft.io.structuredstorage.DirectoryEntryType;
import com.independentsoft.io.structuredstorage.RootDirectoryEntry;
import com.independentsoft.io.structuredstorage.Storage;
import com.independentsoft.io.structuredstorage.Stream;
import com.independentsoft.io.structuredstorage.a;
import com.independentsoft.io.structuredstorage.c;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryEntry
implements Comparable<DirectoryEntry> {
    protected String name;
    protected DirectoryEntryType type = DirectoryEntryType.INVALID;
    protected int color$1c29b67f = 2;
    protected c leftSiblingSid = new c(0);
    protected c rightSiblingSid = new c(0);
    protected c childSid = new c(0);
    protected byte[] classId = new byte[16];
    protected c userFlags = new c(0);
    protected Date createdTime;
    protected Date lastModifiedTime;
    protected c startSector = new c(0);
    protected c size = new c(0);
    protected static final short PROPERTY_TYPE = 0;
    protected byte[] buffer;
    protected DirectoryEntryList directoryEntries = new DirectoryEntryList();
    protected DirectoryEntry parent;

    static DirectoryEntry a(ByteBuffer object) {
        Object object2 = new byte[64];
        ((ByteBuffer)object).get((byte[])object2);
        short s = ((ByteBuffer)object).getShort();
        Charset charset = Charset.forName("UTF-16LE");
        String string = charset.decode(ByteBuffer.wrap(object2)).toString();
        object2 = string;
        object2 = string.substring(0, s / 2 - 1);
        int n = ((ByteBuffer)object).get();
        s = (short)n;
        int n2 = n;
        Object object3 = n == 5 ? DirectoryEntryType.ROOT : (n2 == 4 ? DirectoryEntryType.PROPERTY : (n2 == 3 ? DirectoryEntryType.LOCK_BYTES : (n2 == 2 ? DirectoryEntryType.STREAM : (n2 == 1 ? DirectoryEntryType.STORAGE : DirectoryEntryType.INVALID))));
        int n3 = ((ByteBuffer)object).get();
        n2 = n3;
        n2 = n3;
        n2 = n3 == 0 ? 1 : 2;
        Object object4 = new byte[4];
        ((ByteBuffer)object).get((byte[])object4, 0, 4);
        object4 = new c((byte[])object4);
        Object object5 = new byte[4];
        ((ByteBuffer)object).get((byte[])object5, 0, 4);
        object5 = new c((byte[])object5);
        Object object6 = new byte[4];
        ((ByteBuffer)object).get((byte[])object6, 0, 4);
        object6 = new c((byte[])object6);
        byte[] byArray = new byte[16];
        ((ByteBuffer)object).get(byArray, 0, 16);
        Object object7 = new byte[4];
        ((ByteBuffer)object).get((byte[])object7, 0, 4);
        object7 = new c((byte[])object7);
        Object object8 = new byte[4];
        ((ByteBuffer)object).get((byte[])object8, 0, 4);
        object8 = new c((byte[])object8);
        Object object9 = new byte[4];
        ((ByteBuffer)object).get((byte[])object9, 0, 4);
        object9 = new c((byte[])object9);
        long l = ((c)object8).longValue();
        long l2 = ((c)object9).longValue();
        object8 = a.a(l, l2);
        object9 = new byte[4];
        ((ByteBuffer)object).get((byte[])object9, 0, 4);
        object9 = new c((byte[])object9);
        Object object10 = new byte[4];
        ((ByteBuffer)object).get((byte[])object10, 0, 4);
        object10 = new c((byte[])object10);
        long l3 = ((c)object9).longValue();
        long l4 = object10.longValue();
        object9 = a.a(l3, l4);
        object10 = new byte[4];
        ((ByteBuffer)object).get((byte[])object10, 0, 4);
        object10 = new c((byte[])object10);
        byte[] byArray2 = new byte[4];
        ((ByteBuffer)object).get(byArray2, 0, 4);
        object = new c(byArray2);
        if (object3 == DirectoryEntryType.ROOT) {
            object3 = new RootDirectoryEntry();
            new RootDirectoryEntry().type = DirectoryEntryType.ROOT;
            ((RootDirectoryEntry)object3).name = object2;
            ((RootDirectoryEntry)object3).color$1c29b67f = n2;
            ((RootDirectoryEntry)object3).leftSiblingSid = object4;
            ((RootDirectoryEntry)object3).rightSiblingSid = object5;
            ((RootDirectoryEntry)object3).childSid = object6;
            ((RootDirectoryEntry)object3).classId = byArray;
            ((RootDirectoryEntry)object3).userFlags = object7;
            ((RootDirectoryEntry)object3).createdTime = object8;
            ((RootDirectoryEntry)object3).lastModifiedTime = object9;
            ((RootDirectoryEntry)object3).startSector = object10;
            ((RootDirectoryEntry)object3).size = object;
            return object3;
        }
        if (object3 == DirectoryEntryType.STREAM) {
            object3 = new Stream();
            new Stream().type = DirectoryEntryType.STREAM;
            ((Stream)object3).name = object2;
            ((Stream)object3).color$1c29b67f = n2;
            ((Stream)object3).leftSiblingSid = object4;
            ((Stream)object3).rightSiblingSid = object5;
            ((Stream)object3).childSid = object6;
            ((Stream)object3).classId = byArray;
            ((Stream)object3).userFlags = object7;
            ((Stream)object3).createdTime = object8;
            ((Stream)object3).lastModifiedTime = object9;
            ((Stream)object3).startSector = object10;
            ((Stream)object3).size = object;
            return object3;
        }
        if (object3 == DirectoryEntryType.STORAGE) {
            object3 = new Storage();
            new Storage().type = DirectoryEntryType.STORAGE;
            ((Storage)object3).name = object2;
            ((Storage)object3).color$1c29b67f = n2;
            ((Storage)object3).leftSiblingSid = object4;
            ((Storage)object3).rightSiblingSid = object5;
            ((Storage)object3).childSid = object6;
            ((Storage)object3).classId = byArray;
            ((Storage)object3).userFlags = object7;
            ((Storage)object3).createdTime = object8;
            ((Storage)object3).lastModifiedTime = object9;
            ((Storage)object3).startSector = object10;
            ((Storage)object3).size = object;
            return object3;
        }
        object3 = new Storage();
        new Storage().type = DirectoryEntryType.INVALID;
        ((Storage)object3).name = object2;
        ((Storage)object3).color$1c29b67f = n2;
        ((Storage)object3).leftSiblingSid = object4;
        ((Storage)object3).rightSiblingSid = object5;
        ((Storage)object3).childSid = object6;
        ((Storage)object3).classId = byArray;
        ((Storage)object3).userFlags = object7;
        ((Storage)object3).createdTime = object8;
        ((Storage)object3).lastModifiedTime = object9;
        ((Storage)object3).startSector = object10;
        ((Storage)object3).size = object;
        return object3;
    }

    final byte[] a() {
        long l;
        long l2;
        long l3;
        int n;
        byte[] byArray = new byte[128];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] object = new byte[64];
        Object object2 = Charset.forName("UTF-16LE");
        object2 = ((Charset)object2).encode(this.name).array();
        for (n = 0; n < ((Object)object2).length; ++n) {
            object[n] = (byte)object2[n];
        }
        byteBuffer.put(object);
        byteBuffer.putShort((short)(this.name.length() + 1 << 1));
        DirectoryEntryType by = this.type;
        n = by == DirectoryEntryType.ROOT ? 5 : (by == DirectoryEntryType.PROPERTY ? 4 : (by == DirectoryEntryType.LOCK_BYTES ? 3 : (by == DirectoryEntryType.STREAM ? 2 : (by == DirectoryEntryType.STORAGE ? 1 : 0))));
        byteBuffer.put((byte)n);
        int calendar = this.color$1c29b67f;
        byte calendar2 = calendar == 1 ? (byte)0 : 1;
        byteBuffer.put(calendar2);
        byteBuffer.put(this.leftSiblingSid.a());
        byteBuffer.put(this.rightSiblingSid.a());
        byteBuffer.put(this.childSid.a());
        byteBuffer.put(this.classId);
        byteBuffer.put(this.userFlags.a());
        if (this.createdTime != null) {
            Calendar calendar3 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            calendar3.set(1601, 0, 1, 0, 0, 0);
            l3 = calendar3.getTimeInMillis();
            Calendar calendar4 = Calendar.getInstance();
            calendar4.setTime(this.createdTime);
            l2 = calendar4.getTimeInMillis();
            l = (l2 - l3) * 10000L;
            byteBuffer.putLong(l);
        } else {
            byteBuffer.put(new c(0).a());
            byteBuffer.put(new c(0).a());
        }
        if (this.lastModifiedTime != null) {
            Calendar calendar5 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            calendar5.set(1601, 0, 1, 0, 0, 0);
            l3 = calendar5.getTimeInMillis();
            Calendar calendar6 = Calendar.getInstance();
            calendar6.setTime(this.lastModifiedTime);
            l2 = calendar6.getTimeInMillis();
            l = (l2 - l3) * 10000L;
            byteBuffer.putLong(l);
        } else {
            byteBuffer.put(new c(0).a());
            byteBuffer.put(new c(0).a());
        }
        byteBuffer.put(this.startSector.a());
        byteBuffer.put(this.size.a());
        return byArray;
    }

    @Override
    public int compareTo(DirectoryEntry entry) {
        if (entry.getName().length() < this.name.length()) {
            return 1;
        }
        if (entry.getName().length() == this.name.length()) {
            for (int i = 0; i < this.name.length(); ++i) {
                char c2;
                char c3 = entry.name.charAt(i);
                if (c3 < (c2 = this.name.charAt(i))) {
                    return 1;
                }
                if (c3 <= c2) continue;
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getSize() {
        return this.size.longValue();
    }

    public byte[] getClassId() {
        return this.classId;
    }

    /*
     * WARNING - void declaration
     */
    public void setClassId(byte[] classId) {
        void var1_1;
        this.classId = var1_1;
    }
}

