/*
 * Decompiled with CFR 0.152.
 */
package com.independentsoft.msg;

import com.independentsoft.msg.ExtendedPropertyTag;
import com.independentsoft.msg.PropertyType;
import com.independentsoft.msg.g;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ExtendedProperty {
    private ExtendedPropertyTag a;
    private byte[] b;

    public ExtendedProperty() {
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedProperty(ExtendedPropertyTag tag) {
        void var1_1;
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedProperty(ExtendedPropertyTag tag, String value) {
        void var2_2;
        Charset charset;
        if (tag == null) {
            throw new IllegalArgumentException("tag is null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null.");
        }
        this.a = tag;
        if (((ExtendedPropertyTag)((Object)charset)).getType() == PropertyType.STRING) {
            charset = Charset.forName("UTF-16LE");
            this.b = charset.encode(value).array();
            return;
        }
        charset = Charset.forName("UTF-8");
        this.b = charset.encode((String)var2_2).array();
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedProperty(ExtendedPropertyTag tag, short value) {
        void var2_2;
        ByteBuffer byteBuffer;
        this.a = byteBuffer;
        byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort((short)var2_2);
        this.b = byteBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedProperty(ExtendedPropertyTag tag, int value) {
        void var2_2;
        ByteBuffer byteBuffer;
        this.a = byteBuffer;
        byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt((int)var2_2);
        this.b = byteBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedProperty(ExtendedPropertyTag tag, long value) {
        void var2_2;
        ByteBuffer byteBuffer;
        this.a = byteBuffer;
        byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong((long)var2_2);
        this.b = byteBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedProperty(ExtendedPropertyTag tag, double value) {
        void var2_2;
        ByteBuffer byteBuffer;
        this.a = byteBuffer;
        byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putDouble((double)var2_2);
        this.b = byteBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedProperty(ExtendedPropertyTag tag, boolean value) {
        void var2_2;
        ByteBuffer byteBuffer;
        this.a = byteBuffer;
        byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (var2_2 != false) {
            byteBuffer.putShort((short)1);
        } else {
            byteBuffer.putShort((short)0);
        }
        this.b = byteBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedProperty(ExtendedPropertyTag tag, Date value) {
        void var2_2;
        Comparable<Calendar> comparable;
        this.a = comparable;
        comparable = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        ((Calendar)comparable).set(1601, 0, 1, 0, 0, 0);
        long l = ((Calendar)comparable).getTimeInMillis();
        comparable = Calendar.getInstance();
        ((Calendar)comparable).setTime((Date)var2_2);
        long l2 = ((Calendar)comparable).getTimeInMillis();
        long l3 = (l2 - l) * 10000L;
        comparable = ByteBuffer.allocate(8);
        ((ByteBuffer)comparable).order(ByteOrder.LITTLE_ENDIAN);
        ((ByteBuffer)comparable).putLong(l3);
        this.b = ((ByteBuffer)comparable).array();
    }

    public ExtendedProperty(ExtendedPropertyTag tag, String[] value) throws IOException {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null.");
        }
        this.a = tag;
        if (value != null && value.length > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n = value.length;
                Object object = ByteBuffer.allocate(4);
                ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
                ((ByteBuffer)object).putInt(n);
                object = ((ByteBuffer)object).array();
                byteArrayOutputStream.write((byte[])object);
                for (int i = 0; i < n; ++i) {
                    ByteBuffer byteBuffer;
                    Object object2;
                    if (tag.getType() == PropertyType.STRING) {
                        object2 = Charset.forName("UTF-16LE");
                        byte[] byArray = ((Charset)object2).encode(value[i]).array();
                        object2 = byArray;
                        byteBuffer = ByteBuffer.allocate(byArray.length + 4);
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        byteBuffer.putInt(((Object)object2).length);
                        byteBuffer.put((byte[])object2);
                        byteArrayOutputStream.write(byteBuffer.array());
                        continue;
                    }
                    object2 = Charset.forName("UTF-8");
                    byte[] byArray = ((Charset)object2).encode(value[i]).array();
                    object2 = byArray;
                    byteBuffer = ByteBuffer.allocate(byArray.length + 4);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    byteBuffer.putInt(((Object)object2).length);
                    byteBuffer.put((byte[])object2);
                    byteArrayOutputStream.write(byteBuffer.array());
                }
                this.b = byteArrayOutputStream.toByteArray();
                return;
            }
            finally {
                byteArrayOutputStream.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedProperty(ExtendedPropertyTag tag, byte[] value) {
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.b = var2_2;
    }

    public String getStringValue() {
        if (this.b != null) {
            if (this.a.getType() == PropertyType.STRING) {
                Charset charset = Charset.forName("UTF-16LE");
                return charset.decode(ByteBuffer.wrap(this.b)).toString();
            }
            if (this.a.getType() == PropertyType.STRING8) {
                Charset charset = Charset.forName("UTF-8");
                return charset.decode(ByteBuffer.wrap(this.b)).toString();
            }
            return null;
        }
        return null;
    }

    public String[] getStringArrayValue() {
        if (this.b != null) {
            if (this.a.getType() == PropertyType.MULTIPLE_STRING) {
                return g.a(this.b, "UTF-16LE");
            }
            if (this.a.getType() == PropertyType.MULTIPLE_STRING8) {
                return g.a(this.b, "UTF-8");
            }
            return null;
        }
        return null;
    }

    public boolean getBooleanValue() {
        if (this.b != null) {
            if (this.a.getType() == PropertyType.BOOLEAN && this.b.length == 2) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.b);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                short s = byteBuffer.getShort();
                return s == 0;
            }
            return false;
        }
        return false;
    }

    public short getShortValue() {
        if (this.b != null) {
            if (this.a.getType() == PropertyType.INTEGER16 && this.b.length == 2) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.b);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                return byteBuffer.getShort();
            }
            return Short.MIN_VALUE;
        }
        return Short.MIN_VALUE;
    }

    public int getIntegerValue() {
        if (this.b != null) {
            if (this.a.getType() == PropertyType.INTEGER32 && this.b.length == 4) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.b);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                return byteBuffer.getInt();
            }
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    public long getLongValue() {
        if (this.b != null) {
            if (this.a.getType() == PropertyType.INTEGER64 && this.b.length == 8) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.b);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                return byteBuffer.getLong();
            }
            return Long.MIN_VALUE;
        }
        return Long.MIN_VALUE;
    }

    public float getFloatValue() {
        if (this.b != null) {
            if (this.a.getType() == PropertyType.FLOATING32 && this.b.length == 4) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.b);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                return byteBuffer.getFloat();
            }
            return Float.MIN_VALUE;
        }
        return Float.MIN_VALUE;
    }

    public double getDoubleValue() {
        if (this.b != null) {
            if (this.a.getType() == PropertyType.FLOATING64 && this.b.length == 8) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.b);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                return byteBuffer.getDouble();
            }
            return Double.MIN_VALUE;
        }
        return Double.MIN_VALUE;
    }

    public Date getDateTimeValue() {
        if (this.b != null) {
            if ((this.a.getType() == PropertyType.TIME || this.a.getType() == PropertyType.FLOATING_TIME) && this.b.length == 8) {
                return g.a(this.b);
            }
            return null;
        }
        return null;
    }

    public ExtendedPropertyTag getTag() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public void setTag(ExtendedPropertyTag tag) {
        void var1_1;
        this.a = var1_1;
    }

    public byte[] getValue() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    public void setValue(byte[] value) {
        void var1_1;
        this.b = var1_1;
    }
}

