/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class UUEncoderStream
extends FilterOutputStream {
    private byte[] buffer;
    private int bufsize = 0;
    private boolean wrotePrefix = false;
    protected String name;
    protected int mode;

    public UUEncoderStream(OutputStream out) {
        this(out, "encoder.buf", 644);
    }

    public UUEncoderStream(OutputStream out, String name) {
        this(out, name, 644);
    }

    public UUEncoderStream(OutputStream out, String name, int mode) {
        super(out);
        this.name = name;
        this.mode = mode;
        this.buffer = new byte[45];
    }

    public void setNameMode(String name, int mode) {
        this.name = name;
        this.mode = mode;
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b2[off + i]);
        }
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(int c2) throws IOException {
        this.buffer[this.bufsize++] = (byte)c2;
        if (this.bufsize == 45) {
            this.writePrefix();
            this.encode();
            this.bufsize = 0;
        }
    }

    public void flush() throws IOException {
        if (this.bufsize > 0) {
            this.writePrefix();
            this.encode();
        }
        this.writeSuffix();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void writePrefix() throws IOException {
        if (!this.wrotePrefix) {
            PrintStream ps = new PrintStream(this.out, false, "utf-8");
            ps.println("begin " + this.mode + " " + this.name);
            ps.flush();
            this.wrotePrefix = true;
        }
    }

    private void writeSuffix() throws IOException {
        PrintStream ps = new PrintStream(this.out, false, "us-ascii");
        ps.println(" \nend");
        ps.flush();
    }

    private void encode() throws IOException {
        int i = 0;
        this.out.write((this.bufsize & 0x3F) + 32);
        while (i < this.bufsize) {
            byte c2;
            byte b2;
            byte a2 = this.buffer[i++];
            if (i < this.bufsize) {
                b2 = this.buffer[i++];
                c2 = i < this.bufsize ? this.buffer[i++] : (byte)1;
            } else {
                b2 = 1;
                c2 = 1;
            }
            int c1 = a2 >>> 2 & 0x3F;
            int c22 = a2 << 4 & 0x30 | b2 >>> 4 & 0xF;
            int c3 = b2 << 2 & 0x3C | c2 >>> 6 & 3;
            int c4 = c2 & 0x3F;
            this.out.write(c1 + 32);
            this.out.write(c22 + 32);
            this.out.write(c3 + 32);
            this.out.write(c4 + 32);
        }
        this.out.write(10);
    }
}

