/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;

public class ImplUtils {
    private ImplUtils() {
    }

    public static void injectAsRootPane(Scene scene, Parent injectedParent, boolean useReflection) {
        Parent originalParent = scene.getRoot();
        scene.setRoot(injectedParent);
        if (originalParent != null) {
            ImplUtils.getChildren(injectedParent, useReflection).add(0, (Node)originalParent);
            injectedParent.getProperties().putAll((Map)originalParent.getProperties());
        }
    }

    public static void injectPane(Parent parent, Parent injectedParent, boolean useReflection) {
        if (parent == null) {
            throw new IllegalArgumentException("parent can not be null");
        }
        List<Node> ownerParentChildren = ImplUtils.getChildren(parent.getParent(), useReflection);
        int ownerPos = ownerParentChildren.indexOf(parent);
        ownerParentChildren.remove(ownerPos);
        ownerParentChildren.add(ownerPos, (Node)injectedParent);
        ImplUtils.getChildren(injectedParent, useReflection).add(0, (Node)parent);
        injectedParent.getProperties().putAll((Map)parent.getProperties());
    }

    public static void stripRootPane(Scene scene, Parent originalParent, boolean useReflection) {
        Parent oldParent = scene.getRoot();
        ImplUtils.getChildren(oldParent, useReflection).remove(originalParent);
        originalParent.getStyleClass().remove((Object)"root");
        scene.setRoot(originalParent);
    }

    public static List<Node> getChildren(Node n, boolean useReflection) {
        return n instanceof Parent ? ImplUtils.getChildren((Parent)n, useReflection) : Collections.emptyList();
    }

    public static List<Node> getChildren(Parent p, boolean useReflection) {
        ObservableList children = null;
        if (p instanceof Pane) {
            children = ((Pane)p).getChildren();
        } else if (p instanceof Group) {
            children = ((Group)p).getChildren();
        } else if (p instanceof Control) {
            Control c2 = (Control)p;
            Skin s = c2.getSkin();
            children = s instanceof SkinBase ? ((SkinBase)s).getChildren() : ImplUtils.getChildrenReflectively(p);
        } else if (useReflection) {
            children = ImplUtils.getChildrenReflectively(p);
        }
        if (children == null) {
            throw new RuntimeException("Unable to get children for Parent of type " + p.getClass() + ". useReflection is set to " + useReflection);
        }
        return children == null ? FXCollections.emptyObservableList() : children;
    }

    public static ObservableList<Node> getChildrenReflectively(Parent p) {
        ObservableList children = null;
        try {
            Method getChildrenMethod = Parent.class.getDeclaredMethod("getChildren", new Class[0]);
            if (getChildrenMethod != null) {
                if (!getChildrenMethod.isAccessible()) {
                    getChildrenMethod.setAccessible(true);
                }
                children = (ObservableList)getChildrenMethod.invoke((Object)p, new Object[0]);
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException e2) {
            throw new RuntimeException("Unable to get children for Parent of type " + p.getClass(), e2);
        }
        return children;
    }
}

