/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.lingala.zip4j.crypto.PBKDF2.PRF;

public class MacBasedPRF
implements PRF {
    protected Mac mac;
    protected int hLen;
    protected String macAlgorithm;

    public MacBasedPRF(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
        try {
            this.mac = Mac.getInstance(macAlgorithm);
            this.hLen = this.mac.getMacLength();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
    }

    public MacBasedPRF(String macAlgorithm, String provider) {
        this.macAlgorithm = macAlgorithm;
        try {
            this.mac = Mac.getInstance(macAlgorithm, provider);
            this.hLen = this.mac.getMacLength();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
        catch (NoSuchProviderException e3) {
            throw new RuntimeException(e3);
        }
    }

    public byte[] doFinal(byte[] M) {
        byte[] r = this.mac.doFinal(M);
        return r;
    }

    public byte[] doFinal() {
        byte[] r = this.mac.doFinal();
        return r;
    }

    public int getHLen() {
        return this.hLen;
    }

    public void init(byte[] P) {
        try {
            this.mac.init(new SecretKeySpec(P, this.macAlgorithm));
        }
        catch (InvalidKeyException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void update(byte[] U) {
        try {
            this.mac.update(U);
        }
        catch (IllegalStateException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void update(byte[] U, int start, int len) {
        try {
            this.mac.update(U, start, len);
        }
        catch (IllegalStateException e2) {
            throw new RuntimeException(e2);
        }
    }
}

