/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lingala.zip4j.io.PartInputStream;
import net.lingala.zip4j.unzip.UnzipEngine;

public class InflaterInputStream
extends PartInputStream {
    private Inflater inflater;
    private byte[] buff;
    private byte[] oneByteBuff = new byte[1];
    private UnzipEngine unzipEngine;
    private long bytesWritten;
    private long uncompressedSize;

    public InflaterInputStream(RandomAccessFile raf, long start, long len, UnzipEngine unzipEngine) {
        super(raf, start, len, unzipEngine);
        this.inflater = new Inflater(true);
        this.buff = new byte[4096];
        this.unzipEngine = unzipEngine;
        this.bytesWritten = 0L;
        this.uncompressedSize = unzipEngine.getFileHeader().getUncompressedSize();
    }

    public int read() throws IOException {
        return this.read(this.oneByteBuff, 0, 1) == -1 ? -1 : this.oneByteBuff[0] & 0xFF;
    }

    public int read(byte[] b2) throws IOException {
        if (b2 == null) {
            throw new NullPointerException("input buffer is null");
        }
        return this.read(b2, 0, b2.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new NullPointerException("input buffer is null");
        }
        if (off < 0 || len < 0 || len > b2.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            if (this.bytesWritten >= this.uncompressedSize) {
                this.finishInflating();
                return -1;
            }
            while (true) {
                int n;
                if ((n = this.inflater.inflate(b2, off, len)) != 0) {
                    this.bytesWritten += (long)n;
                    return n;
                }
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    this.finishInflating();
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                this.fill();
            }
        }
        catch (DataFormatException e2) {
            String s = "Invalid ZLIB data format";
            if (e2.getMessage() != null) {
                s = e2.getMessage();
            }
            if (this.unzipEngine != null && this.unzipEngine.getLocalFileHeader().isEncrypted() && this.unzipEngine.getLocalFileHeader().getEncryptionMethod() == 0) {
                s = String.valueOf(s) + " - Wrong Password?";
            }
            throw new IOException(s);
        }
    }

    private void finishInflating() throws IOException {
        byte[] b2 = new byte[1024];
        while (super.read(b2, 0, 1024) != -1) {
        }
        this.checkAndReadAESMacBytes();
    }

    private void fill() throws IOException {
        int len = super.read(this.buff, 0, this.buff.length);
        if (len == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inflater.setInput(this.buff, 0, len);
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        int total = 0;
        byte[] b2 = new byte[512];
        while (total < max) {
            int len = max - total;
            if (len > b2.length) {
                len = b2.length;
            }
            if ((len = this.read(b2, 0, len)) == -1) break;
            total += len;
        }
        return total;
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
    }

    public int available() {
        return this.inflater.finished() ? 0 : 1;
    }

    public void close() throws IOException {
        this.inflater.end();
        super.close();
    }

    public UnzipEngine getUnzipEngine() {
        return super.getUnzipEngine();
    }
}

