/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public final class Borders {
    private static final Color DEFAULT_BORDER_COLOR = Color.DARKGRAY;
    private final Node node;
    private final List<Border> borders;

    public static Borders wrap(Node n) {
        return new Borders(n);
    }

    private Borders(Node n) {
        this.node = n;
        this.borders = new ArrayList<Border>();
    }

    public EmptyBorders emptyBorder() {
        return new EmptyBorders(this);
    }

    public EtchedBorders etchedBorder() {
        return new EtchedBorders(this);
    }

    public LineBorders lineBorder() {
        return new LineBorders(this);
    }

    public Borders addBorder(Border border) {
        this.borders.add(border);
        return this;
    }

    public Node build() {
        Node bundle = this.node;
        for (int i = this.borders.size() - 1; i >= 0; --i) {
            Border border = this.borders.get(i);
            bundle = border.wrap(bundle);
        }
        return bundle;
    }

    static /* synthetic */ Color access$300() {
        return DEFAULT_BORDER_COLOR;
    }

    private static class StrokeBorder
    implements Border {
        private static final int TITLE_PADDING = 3;
        private static final double GAP_PADDING = 5.0;
        private final String title;
        private final BorderStroke[] borderStrokes;

        public StrokeBorder(String title, BorderStroke ... borderStrokes) {
            this.title = title;
            this.borderStrokes = borderStrokes;
        }

        @Override
        public Node wrap(final Node n) {
            StackPane pane = new StackPane(){
                Label titleLabel;
                {
                    this.getChildren().add((Object)n);
                    if (title != null) {
                        this.titleLabel = new Label(title);
                        this.titleLabel.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
                        this.getChildren().add((Object)this.titleLabel);
                    }
                }

                protected void layoutChildren() {
                    super.layoutChildren();
                    if (this.titleLabel != null) {
                        double labelHeight = this.titleLabel.prefHeight(-1.0);
                        double labelWidth = this.titleLabel.prefWidth(labelHeight) + 3.0;
                        this.titleLabel.resize(labelWidth, labelHeight);
                        this.titleLabel.relocate(6.0, -labelHeight / 2.0 - 1.0);
                        ArrayList<BorderStroke> newBorderStrokes = new ArrayList<BorderStroke>(2);
                        for (BorderStroke bs : borderStrokes) {
                            ArrayList<Double> dashList = new ArrayList<Double>();
                            if (bs.getTopStyle().getDashArray().isEmpty()) {
                                dashList.addAll(Arrays.asList(5.0, labelWidth, Double.MAX_VALUE));
                            } else {
                                double origDashWidth = bs.getTopStyle().getDashArray().stream().mapToDouble(d2 -> d2).sum();
                                if (origDashWidth > 5.0) {
                                    dashList.add(5.0);
                                    dashList.add(labelWidth);
                                } else {
                                    int no = (int)(5.0 / origDashWidth);
                                    for (int i = 0; i < no; ++i) {
                                        dashList.addAll(bs.getTopStyle().getDashArray());
                                    }
                                    if ((dashList.size() & 1) == 0) {
                                        dashList.add(0.0);
                                    }
                                    dashList.add(labelWidth + 5.0 - (double)no * origDashWidth);
                                }
                                int i = 0;
                                while ((double)i < (this.getWidth() - labelWidth - origDashWidth) / origDashWidth) {
                                    dashList.addAll(bs.getTopStyle().getDashArray());
                                    ++i;
                                }
                            }
                            BorderStrokeStyle topStrokeStyle = new BorderStrokeStyle(bs.getTopStyle().getType(), bs.getTopStyle().getLineJoin(), bs.getTopStyle().getLineCap(), bs.getTopStyle().getMiterLimit(), bs.getTopStyle().getDashOffset(), dashList);
                            newBorderStrokes.add(new BorderStroke(bs.getTopStroke(), bs.getRightStroke(), bs.getBottomStroke(), bs.getLeftStroke(), topStrokeStyle, bs.getRightStyle(), bs.getBottomStyle(), bs.getLeftStyle(), bs.getRadii(), bs.getWidths(), null));
                        }
                        this.setBorder(new javafx.scene.layout.Border(newBorderStrokes.toArray(new BorderStroke[newBorderStrokes.size()])));
                    }
                }
            };
            pane.setBorder(new javafx.scene.layout.Border(this.borderStrokes));
            return pane;
        }
    }

    @FunctionalInterface
    public static interface Border {
        public Node wrap(Node var1);
    }

    public class LineBorders {
        private final Borders parent;
        private String title;
        private BorderStrokeStyle strokeStyle = BorderStrokeStyle.SOLID;
        private Color topColor = Borders.access$300();
        private Color rightColor = Borders.access$300();
        private Color bottomColor = Borders.access$300();
        private Color leftColor = Borders.access$300();
        private double outerTopPadding = 10.0;
        private double outerRightPadding = 10.0;
        private double outerBottomPadding = 10.0;
        private double outerLeftPadding = 10.0;
        private double innerTopPadding = 15.0;
        private double innerRightPadding = 15.0;
        private double innerBottomPadding = 15.0;
        private double innerLeftPadding = 15.0;
        private double topThickness = 1.0;
        private double rightThickness = 1.0;
        private double bottomThickness = 1.0;
        private double leftThickness = 1.0;
        private double topLeftRadius = 0.0;
        private double topRightRadius = 0.0;
        private double bottomRightRadius = 0.0;
        private double bottomLeftRadius = 0.0;

        private LineBorders(Borders parent) {
            this.parent = parent;
        }

        public LineBorders color(Color color) {
            return this.color(color, color, color, color);
        }

        public LineBorders color(Color topColor, Color rightColor, Color bottomColor, Color leftColor) {
            this.topColor = topColor;
            this.rightColor = rightColor;
            this.bottomColor = bottomColor;
            this.leftColor = leftColor;
            return this;
        }

        public LineBorders strokeStyle(BorderStrokeStyle strokeStyle) {
            this.strokeStyle = strokeStyle;
            return this;
        }

        public LineBorders outerPadding(double padding) {
            return this.outerPadding(padding, padding, padding, padding);
        }

        public LineBorders outerPadding(double topPadding, double rightPadding, double bottomPadding, double leftPadding) {
            this.outerTopPadding = topPadding;
            this.outerRightPadding = rightPadding;
            this.outerBottomPadding = bottomPadding;
            this.outerLeftPadding = leftPadding;
            return this;
        }

        public LineBorders innerPadding(double padding) {
            return this.innerPadding(padding, padding, padding, padding);
        }

        public LineBorders innerPadding(double topPadding, double rightPadding, double bottomPadding, double leftPadding) {
            this.innerTopPadding = topPadding;
            this.innerRightPadding = rightPadding;
            this.innerBottomPadding = bottomPadding;
            this.innerLeftPadding = leftPadding;
            return this;
        }

        public LineBorders thickness(double thickness) {
            return this.thickness(thickness, thickness, thickness, thickness);
        }

        public LineBorders thickness(double topThickness, double rightThickness, double bottomThickness, double leftThickness) {
            this.topThickness = topThickness;
            this.rightThickness = rightThickness;
            this.bottomThickness = bottomThickness;
            this.leftThickness = leftThickness;
            return this;
        }

        public LineBorders radius(double radius) {
            return this.radius(radius, radius, radius, radius);
        }

        public LineBorders radius(double topLeft, double topRight, double bottomRight, double bottomLeft) {
            this.topLeftRadius = topLeft;
            this.topRightRadius = topRight;
            this.bottomRightRadius = bottomRight;
            this.bottomLeftRadius = bottomLeft;
            return this;
        }

        public LineBorders title(String title) {
            this.title = title;
            return this;
        }

        public Borders build() {
            BorderStroke borderStroke = new BorderStroke((Paint)this.topColor, (Paint)this.rightColor, (Paint)this.bottomColor, (Paint)this.leftColor, this.strokeStyle, this.strokeStyle, this.strokeStyle, this.strokeStyle, new CornerRadii(this.topLeftRadius, this.topRightRadius, this.bottomRightRadius, this.bottomLeftRadius, false), new BorderWidths(this.topThickness, this.rightThickness, this.bottomThickness, this.leftThickness), null);
            BorderStroke outerPadding = new EmptyBorders(this.parent).padding(this.outerTopPadding, this.outerRightPadding, this.outerBottomPadding, this.outerLeftPadding).buildStroke();
            BorderStroke innerPadding = new EmptyBorders(this.parent).padding(this.innerTopPadding, this.innerRightPadding, this.innerBottomPadding, this.innerLeftPadding).buildStroke();
            this.parent.addBorder(new StrokeBorder(null, outerPadding));
            this.parent.addBorder(new StrokeBorder(this.title, borderStroke));
            this.parent.addBorder(new StrokeBorder(null, innerPadding));
            return this.parent;
        }

        public Node buildAll() {
            this.build();
            return this.parent.build();
        }
    }

    public class EtchedBorders {
        private final Borders parent;
        private String title;
        private boolean raised = false;
        private double outerTopPadding = 10.0;
        private double outerRightPadding = 10.0;
        private double outerBottomPadding = 10.0;
        private double outerLeftPadding = 10.0;
        private double innerTopPadding = 15.0;
        private double innerRightPadding = 15.0;
        private double innerBottomPadding = 15.0;
        private double innerLeftPadding = 15.0;
        private double topLeftRadius = 0.0;
        private double topRightRadius = 0.0;
        private double bottomRightRadius = 0.0;
        private double bottomLeftRadius = 0.0;
        private Color highlightColor = Borders.access$300();
        private Color shadowColor = Color.WHITE;

        private EtchedBorders(Borders parent) {
            this.parent = parent;
        }

        public EtchedBorders highlight(Color highlight) {
            this.highlightColor = highlight;
            return this;
        }

        public EtchedBorders shadow(Color shadow) {
            this.shadowColor = shadow;
            return this;
        }

        public EtchedBorders raised() {
            this.raised = true;
            return this;
        }

        public EtchedBorders title(String title) {
            this.title = title;
            return this;
        }

        public EtchedBorders outerPadding(double padding) {
            return this.outerPadding(padding, padding, padding, padding);
        }

        public EtchedBorders outerPadding(double topPadding, double rightPadding, double bottomPadding, double leftPadding) {
            this.outerTopPadding = topPadding;
            this.outerRightPadding = rightPadding;
            this.outerBottomPadding = bottomPadding;
            this.outerLeftPadding = leftPadding;
            return this;
        }

        public EtchedBorders innerPadding(double padding) {
            return this.innerPadding(padding, padding, padding, padding);
        }

        public EtchedBorders innerPadding(double topPadding, double rightPadding, double bottomPadding, double leftPadding) {
            this.innerTopPadding = topPadding;
            this.innerRightPadding = rightPadding;
            this.innerBottomPadding = bottomPadding;
            this.innerLeftPadding = leftPadding;
            return this;
        }

        public EtchedBorders radius(double radius) {
            return this.radius(radius, radius, radius, radius);
        }

        public EtchedBorders radius(double topLeft, double topRight, double bottomRight, double bottomLeft) {
            this.topLeftRadius = topLeft;
            this.topRightRadius = topRight;
            this.bottomRightRadius = bottomRight;
            this.bottomLeftRadius = bottomLeft;
            return this;
        }

        public Borders build() {
            Color inner = this.raised ? this.shadowColor : this.highlightColor;
            Color outer = this.raised ? this.highlightColor : this.shadowColor;
            BorderStroke innerStroke = new BorderStroke((Paint)inner, BorderStrokeStyle.SOLID, new CornerRadii(this.topLeftRadius, this.topRightRadius, this.bottomRightRadius, this.bottomLeftRadius, false), new BorderWidths(1.0));
            BorderStroke outerStroke = new BorderStroke((Paint)outer, BorderStrokeStyle.SOLID, new CornerRadii(this.topLeftRadius, this.topRightRadius, this.bottomRightRadius, this.bottomLeftRadius, false), new BorderWidths(1.0), new Insets(1.0));
            BorderStroke outerPadding = new EmptyBorders(this.parent).padding(this.outerTopPadding, this.outerRightPadding, this.outerBottomPadding, this.outerLeftPadding).buildStroke();
            BorderStroke innerPadding = new EmptyBorders(this.parent).padding(this.innerTopPadding, this.innerRightPadding, this.innerBottomPadding, this.innerLeftPadding).buildStroke();
            this.parent.addBorder(new StrokeBorder(null, outerPadding));
            this.parent.addBorder(new StrokeBorder(this.title, innerStroke, outerStroke));
            this.parent.addBorder(new StrokeBorder(null, innerPadding));
            return this.parent;
        }

        public Node buildAll() {
            this.build();
            return this.parent.build();
        }
    }

    public class EmptyBorders {
        private final Borders parent;
        private double top;
        private double right;
        private double bottom;
        private double left;

        private EmptyBorders(Borders parent) {
            this.parent = parent;
        }

        public EmptyBorders padding(double padding) {
            return this.padding(padding, padding, padding, padding);
        }

        public EmptyBorders padding(double top, double right, double bottom, double left) {
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.left = left;
            return this;
        }

        public Borders build() {
            this.parent.addBorder(new StrokeBorder(null, this.buildStroke()));
            return this.parent;
        }

        public Node buildAll() {
            this.build();
            return this.parent.build();
        }

        private BorderStroke buildStroke() {
            return new BorderStroke(null, BorderStrokeStyle.NONE, null, new BorderWidths(this.top, this.right, this.bottom, this.left), Insets.EMPTY);
        }
    }
}

