/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;

public class DesktopApi {
    public static boolean browse(URI uri) {
        if (DesktopApi.openSystemSpecific(uri.toString())) {
            return true;
        }
        return DesktopApi.browseDESKTOP(uri);
    }

    public static boolean open(File file) {
        if (DesktopApi.openSystemSpecific(file.getPath())) {
            return true;
        }
        return DesktopApi.openDESKTOP(file);
    }

    public static boolean openMail(URI uri) {
        EnumOS os = DesktopApi.getOs();
        if (os.isLinux() && DesktopApi.openSystemSpecific(uri.toString())) {
            return true;
        }
        return DesktopApi.openMAIL(uri);
    }

    public static boolean edit(File file) {
        if (DesktopApi.openSystemSpecific(file.getPath())) {
            return true;
        }
        return DesktopApi.editDESKTOP(file);
    }

    private static boolean openSystemSpecific(String what) {
        EnumOS os = DesktopApi.getOs();
        if (os.isLinux()) {
            if (DesktopApi.runCommand("kde-open", "%s", what)) {
                return true;
            }
            if (DesktopApi.runCommand("gnome-open", "%s", what)) {
                return true;
            }
            if (DesktopApi.runCommand("xdg-open", "%s", what)) {
                return true;
            }
        }
        if (os.isMac() && DesktopApi.runCommand("open", "%s", what)) {
            return true;
        }
        return os.isWindows() && DesktopApi.runCommand("explorer", "%s", what);
    }

    public static boolean browseDESKTOP(URI uri) {
        block5: {
            block4: {
                try {
                    if (Desktop.isDesktopSupported()) break block4;
                    return false;
                }
                catch (Throwable t) {
                    System.out.println(t.getLocalizedMessage());
                    return false;
                }
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) break block5;
            return false;
        }
        Desktop.getDesktop().browse(uri);
        return true;
    }

    private static boolean openDESKTOP(File file) {
        block5: {
            block4: {
                try {
                    if (Desktop.isDesktopSupported()) break block4;
                    return false;
                }
                catch (Throwable t) {
                    System.out.println(t.getLocalizedMessage());
                    return false;
                }
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) break block5;
            return false;
        }
        Desktop.getDesktop().open(file);
        return true;
    }

    private static boolean editDESKTOP(File file) {
        block5: {
            block4: {
                try {
                    if (Desktop.isDesktopSupported()) break block4;
                    return false;
                }
                catch (Throwable t) {
                    System.out.println(t.getLocalizedMessage());
                    return false;
                }
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) break block5;
            return false;
        }
        Desktop.getDesktop().edit(file);
        return true;
    }

    public static boolean openMAIL(URI uri) {
        block5: {
            block4: {
                try {
                    if (Desktop.isDesktopSupported()) break block4;
                    return false;
                }
                catch (Throwable t) {
                    System.out.println(t.getLocalizedMessage());
                    return false;
                }
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) break block5;
            return false;
        }
        Desktop.getDesktop().mail(uri);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean runCommand(String command, String args, String file) {
        String[] parts = DesktopApi.prepareCommand(command, args, file);
        try {
            Process p = Runtime.getRuntime().exec(parts);
            if (p == null) {
                return false;
            }
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    return false;
                }
                return false;
            }
            catch (IllegalThreadStateException itse) {
                return true;
            }
        }
        catch (IOException e2) {
            System.out.println(e2.getLocalizedMessage());
            return false;
        }
    }

    private static String[] prepareCommand(String command, String args, String file) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(command);
        if (args != null) {
            String[] stringArray = args.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                s = String.format(s, file);
                parts.add(s.trim());
                ++n2;
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    public static EnumOS getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS.windows;
        }
        if (s.contains("mac")) {
            return EnumOS.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS.linux;
        }
        if (s.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    public static enum EnumOS {
        linux,
        macos,
        solaris,
        unknown,
        windows;


        public boolean isLinux() {
            return this == linux || this == solaris;
        }

        public boolean isMac() {
            return this == macos;
        }

        public boolean isWindows() {
            return this == windows;
        }
    }
}

