/*
 * Decompiled with CFR 0.152.
 */
package utility;

import com.independentsoft.msg.Attachment;
import com.independentsoft.msg.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Properties;
import javafx.scene.control.Alert;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.FilenameUtils;
import org.bouncycastle.cms.CMSException;
import utility.Functions;
import utility.Independentsoft;

public class Email {
    private static Functions myFunctions;

    public Email() {
    }

    public Email(Functions functions) {
        myFunctions = functions;
    }

    public String getMessage(String filename, Boolean verifySign) throws CMSException, IOException {
        File pTmp = new File(myFunctions.getPathTmp());
        if (!pTmp.exists()) {
            pTmp.mkdir();
        }
        File fileTmp = new File(filename);
        String returnFile = "";
        String estensione = filename.substring(Math.max(filename.length() - 3, 0)).toLowerCase();
        if (estensione.equals("eml")) {
            File fileMsg = new File(String.valueOf(myFunctions.getPathTmp()) + myFunctions.getFilenameWithoutExtension(fileTmp.getName()) + ".msg");
            try {
                if (!fileMsg.exists()) {
                    Properties p = System.getProperties();
                    Session session = Session.getInstance(p);
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (FileInputStream in = new FileInputStream(filename);){
                        MimeMessage mimeMessage = new MimeMessage(session, in);
                        Message msgMessage = Independentsoft.convertToMsg(mimeMessage);
                        msgMessage.save(String.valueOf(myFunctions.getPathTmp()) + myFunctions.getFilenameWithoutExtension(fileTmp.getName()) + ".msg", true);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                filename = String.valueOf(myFunctions.getPathTmp()) + myFunctions.getFilenameWithoutExtension(fileTmp.getName()) + ".msg";
            }
            catch (Exception ex) {
                myFunctions.notifier("Attenzione", ex.getLocalizedMessage(), Alert.AlertType.WARNING, 2500.0);
            }
        }
        returnFile = this.getAttachment(filename, verifySign);
        return returnFile;
    }

    private String getAttachment(String filename, Boolean ApplyStyleSheets) throws CMSException, IOException {
        String returnAttachment = "";
        Message message = new Message(filename);
        for (Attachment attachment : message.getAttachments()) {
            if (attachment.getFileName() == null) continue;
            String nomeAllegatoOriginale = attachment.getFileName().toString().trim();
            if (attachment.getLongFileName() != null) {
                nomeAllegatoOriginale = attachment.getLongFileName().toString().trim();
            }
            int i = 0;
            String nomeAllegatoUnivoco = nomeAllegatoOriginale;
            while (Files.exists(Paths.get(String.valueOf(myFunctions.getPathTmp()) + nomeAllegatoUnivoco, new String[0]), new LinkOption[0])) {
                String nomeAllegato = FilenameUtils.removeExtension(nomeAllegatoOriginale);
                String extAllegato = FilenameUtils.getExtension(nomeAllegatoOriginale);
                nomeAllegatoUnivoco = String.valueOf(nomeAllegato) + "[" + ++i + "]." + extAllegato;
            }
            attachment.save(String.valueOf(myFunctions.getPathTmp()) + nomeAllegatoUnivoco);
            String ext = FilenameUtils.getExtension(nomeAllegatoUnivoco);
            if (ext.equalsIgnoreCase("xml")) {
                if (ApplyStyleSheets.booleanValue()) {
                    returnAttachment = myFunctions.applyStyleSheetsXml(new File(String.valueOf(myFunctions.getPathTmp()) + nomeAllegatoUnivoco));
                    continue;
                }
                returnAttachment = String.valueOf(myFunctions.getPathTmp()) + nomeAllegatoUnivoco;
                continue;
            }
            if (!ext.equalsIgnoreCase("p7m")) continue;
            returnAttachment = String.valueOf(myFunctions.getPathTmp()) + nomeAllegatoUnivoco;
        }
        return returnAttachment;
    }
}

