/*
 * Decompiled with CFR 0.152.
 */
package utility;

import entities.CTagDatiDDT;
import entities.CTagDatiOrdineAcquisto;
import entities.CTagNatura;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.Printer;
import javafx.print.PrinterJob;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DialogPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.PopOver;
import org.ini4j.Ini;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utility.CipherUtils;
import utility.DesktopApi;
import utility.SimpleAuthenticator;

public class Functions {
    public ImageView imageViewWarning = new ImageView(Functions.class.getClassLoader().getResource("res/warning.png").toString());
    public ImageView imageViewLogo = new ImageView(Functions.class.getClassLoader().getResource("res/loghi/logo.png").toString());
    public String cssStyle = Functions.class.getClassLoader().getResource("res/ControlStyle.css").toExternalForm();
    public Image iconDialog = new Image(Functions.class.getClassLoader().getResource("res/icon.png").toString());
    private String pathTmp;
    private String styleSheetsFatt;

    public String getPathTmp() {
        return this.pathTmp;
    }

    public void setPathTmp(String pathTmp) {
        this.pathTmp = pathTmp;
    }

    public String getStyleSheetsFatt() {
        return this.styleSheetsFatt;
    }

    public void setStyleSheetsFatt(String styleSheetsFatt) {
        this.styleSheetsFatt = styleSheetsFatt;
    }

    public Functions() {
        try {
            this.pathTmp = DesktopApi.getOs() == DesktopApi.EnumOS.windows || DesktopApi.getOs() == DesktopApi.EnumOS.linux ? String.valueOf(System.getProperty("user.home")) + "/MyInvoiceTemp/" : String.valueOf(URLDecoder.decode(ClassLoader.getSystemClassLoader().getResource(".").getPath(), "UTF-8")) + "MyInvoiceTemp/";
            this.pathTmp = String.valueOf(System.getProperty("user.home")) + "/MyInvoiceTemp/";
            File pTmp = new File(this.pathTmp);
            if (!pTmp.exists()) {
                pTmp.mkdir();
            }
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
    }

    public void printFile_old(final List<String> files, final Printer printer, final Integer copies, final PageOrientation orientation) throws Exception {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < files.size()) {
                    WebView webViewPrint = new WebView();
                    final WebEngine enginePrint = webViewPrint.getEngine();
                    final PrinterJob job = PrinterJob.createPrinterJob();
                    job.setPrinter(printer);
                    job.getJobSettings().setCopies(copies.intValue());
                    PageLayout pageLayout = printer.createPageLayout(Paper.A4, orientation, Printer.MarginType.DEFAULT);
                    job.getJobSettings().setPageLayout(pageLayout);
                    File lFile = new File((String)files.get(i));
                    job.getJobSettings().setJobName(lFile.getName());
                    Functions.this.Logga("prima enginePrint.load");
                    enginePrint.load("file:///" + (String)files.get(i));
                    Functions.this.Logga("dopo nginePrint.load");
                    enginePrint.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                            switch (newValue) {
                                case FAILED: {
                                    Functions.this.notifier("Attenzione", "Si \u00e8 verificato un errore durante la procedura di stampa!", Alert.AlertType.WARNING, 1500.0);
                                    break;
                                }
                                case CANCELLED: {
                                    break;
                                }
                                case SUCCEEDED: {
                                    Functions.this.Logga("prima enginePrint.print");
                                    enginePrint.print(job);
                                    Functions.this.Logga("dopo enginePrint.print");
                                    Functions.this.Logga("prima job.endJob");
                                    job.endJob();
                                    Functions.this.Logga("dopo job.endJob");
                                    Functions.this.notifier("Stampa", "Procedura di stampa effettuata con successo!", Alert.AlertType.INFORMATION, 2000.0);
                                    break;
                                }
                            }
                        }
                    });
                    ++i;
                }
            }
        });
    }

    public void printFile(final List<String> files, final int numFileToPrint, final Printer printer, final Integer copies, final PageOrientation orientation) throws Exception {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Functions.this.Logga("Richiesto printFile [" + (numFileToPrint + 1) + " di " + files.size() + "]");
                WebView webViewPrint = new WebView();
                final WebEngine enginePrint = webViewPrint.getEngine();
                final PrinterJob job = PrinterJob.createPrinterJob();
                job.setPrinter(printer);
                job.getJobSettings().setCopies(copies.intValue());
                PageLayout pageLayout = printer.createPageLayout(Paper.A4, orientation, Printer.MarginType.DEFAULT);
                job.getJobSettings().setPageLayout(pageLayout);
                File lFile = new File((String)files.get(numFileToPrint));
                job.getJobSettings().setJobName(lFile.getName());
                enginePrint.load("file:///" + (String)files.get(numFileToPrint));
                enginePrint.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                        switch (newValue) {
                            case FAILED: {
                                Functions.this.notifier("Attenzione", "Si \u00e8 verificato un errore durante la procedura di stampa!", Alert.AlertType.WARNING, 1500.0);
                                break;
                            }
                            case CANCELLED: {
                                break;
                            }
                            case SUCCEEDED: {
                                enginePrint.print(job);
                                job.endJob();
                                if (numFileToPrint < files.size() - 1) {
                                    Functions.this.Logga("Ciclo di stampa NON terminato, richiama la funzione di stampa.");
                                    try {
                                        Functions.this.printFile(files, numFileToPrint + 1, printer, copies, orientation);
                                    }
                                    catch (Exception e2) {
                                        e2.printStackTrace();
                                    }
                                    break;
                                }
                                Functions.this.Logga("Ciclo di stampa terminato.");
                                Functions.this.notifier("Stampa", "Procedura di stampa effettuata con successo!", Alert.AlertType.INFORMATION, 2000.0);
                                break;
                            }
                        }
                    }
                });
            }
        });
    }

    public Optional<ButtonType> alert(String title, String headerText, String contentText, ImageView imageMessage, Alert.AlertType type, Boolean Modal) {
        Alert alert = new Alert(type);
        alert.setGraphic((Node)imageMessage);
        alert.setTitle(title);
        alert.setHeaderText(headerText);
        if (contentText != "") {
            alert.setContentText(contentText);
        }
        DialogPane dialogPane = alert.getDialogPane();
        Stage dialog = (Stage)dialogPane.getScene().getWindow();
        if (DesktopApi.getOs() != DesktopApi.EnumOS.macos) {
            dialog.getIcons().add((Object)this.iconDialog);
        }
        dialogPane.getStylesheets().add((Object)this.cssStyle);
        Optional result = null;
        if (Modal.booleanValue()) {
            dialog.setAlwaysOnTop(true);
            result = alert.showAndWait();
        } else {
            alert.show();
        }
        return result;
    }

    public Alert alertWithOptOut(String title, String headerText, String contentText, Alert.AlertType type, final String optOutMessage, final Callback<Boolean, Void> optOutAction, ButtonType ... buttonTypes) {
        Alert alert = new Alert(type);
        Stage dialog = (Stage)alert.getDialogPane().getScene().getWindow();
        if (DesktopApi.getOs() != DesktopApi.EnumOS.macos) {
            dialog.getIcons().add((Object)this.iconDialog);
        }
        alert.setDialogPane(new DialogPane(){

            protected Node createDetailsButton() {
                CheckBox optOut = new CheckBox();
                optOut.setText(optOutMessage);
                optOut.setOnAction(e2 -> {
                    Object object = optOutAction.call((Object)optOut.isSelected());
                });
                return optOut;
            }
        });
        alert.getDialogPane().getButtonTypes().addAll((Object[])buttonTypes);
        alert.getDialogPane().setExpandableContent((Node)new Group());
        alert.getDialogPane().setExpanded(true);
        alert.setGraphic((Node)this.imageViewLogo);
        alert.setTitle(title);
        alert.setHeaderText(headerText);
        if (contentText != "") {
            alert.setContentText(contentText);
        }
        alert.getDialogPane().getStylesheets().add((Object)this.cssStyle);
        return alert;
    }

    public void notifier(String pTitle, String pMessage, Alert.AlertType type, Double duration) {
        Notifications notifications = Notifications.create();
        Duration myDuration = new Duration(duration.doubleValue());
        notifications.hideAfter(myDuration);
        Platform.runLater(() -> {
            switch (type) {
                case INFORMATION: {
                    notifications.title(pTitle).text(pMessage).showInformation();
                    break;
                }
                case ERROR: {
                    notifications.title(pTitle).text(pMessage).showError();
                    break;
                }
                case WARNING: {
                    notifications.title(pTitle).text(pMessage).showWarning();
                    break;
                }
                case CONFIRMATION: {
                    notifications.title(pTitle).text(pMessage).show();
                    break;
                }
                case NONE: {
                    notifications.graphic((Node)this.imageViewLogo);
                    notifications.title(pTitle).text(pMessage).show();
                    break;
                }
            }
        });
    }

    public static PopOver popover(Node node, PopOver.ArrowLocation location, Collection<Node> contentNode, Boolean hideOnEscape, Boolean autoHide) {
        HBox hPopOver = new HBox();
        hPopOver.setSpacing(5.0);
        hPopOver.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        hPopOver.setAlignment(Pos.CENTER_LEFT);
        hPopOver.getChildren().clear();
        hPopOver.getChildren().addAll(contentNode);
        PopOver popover = new PopOver();
        popover.setCornerRadius(5.0);
        popover.setHideOnEscape(hideOnEscape);
        popover.setAutoHide(autoHide);
        popover.setArrowLocation(location);
        popover.setContentNode((Node)hPopOver);
        popover.show(node);
        return popover;
    }

    public String getFilenameWithoutExtension(String filename) {
        String returnFilename = filename;
        int pos = filename.lastIndexOf(".");
        while (pos > 0) {
            returnFilename = filename.substring(0, pos);
            pos = returnFilename.lastIndexOf(".");
        }
        return returnFilename;
    }

    public String getVersion() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/res/version.properties");
        Properties prop = new Properties();
        try {
            prop.load(is);
            is.close();
            return prop.getProperty("version").trim();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return "";
        }
    }

    public String getUrlXslMyInvoice() {
        String strRis = null;
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            strRis = prop.getProperty("url_xsl_myinvoice").trim();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public String getXslMyInvoiceWork() {
        String strRis = null;
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            strRis = prop.getProperty("xsl_myinvoice_work").trim();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public String getUrlXslMinisteriale() {
        String strRis = null;
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            strRis = prop.getProperty("url_xsl_ministeriale").trim();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public String getXslMinisterialeWork() {
        String strRis = null;
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            strRis = prop.getProperty("xsl_ministeriale_work").trim();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public String getXslInUso() {
        String strRis = null;
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            strRis = prop.getProperty("xls_in_uso").trim();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public void setXslInUso(String valore) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            FileOutputStream os = new FileOutputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            prop.setProperty("xls_in_uso", valore);
            prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getVisualizzazioneInUso() {
        String strRis = null;
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            strRis = prop.getProperty("visualizzazione_in_uso").trim();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public void setVisualizzazioneInUso(String valore) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            FileOutputStream os = new FileOutputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            prop.setProperty("visualizzazione_in_uso", valore);
            prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getVersioneInUso() {
        String strRis = "";
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            String strRisTmp = prop.getProperty("versione_in_uso");
            if (strRisTmp != null) {
                strRis = strRisTmp.trim();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public void setVersioneInUso(String valore) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            FileOutputStream os = new FileOutputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            prop.setProperty("versione_in_uso", valore);
            prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getCondizioniUso() {
        String strRis = "";
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            String strRisTmp = prop.getProperty("condizioni_uso");
            if (strRisTmp != null) {
                strRis = strRisTmp.trim();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public void setCondizioniUso(String valore) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            FileOutputStream os = new FileOutputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            prop.setProperty("condizioni_uso", valore);
            prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public boolean getProxyAbilitato() {
        boolean bRis = false;
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            String strRisTmp = prop.getProperty("ProxyAbilitato");
            if (strRisTmp != null) {
                bRis = strRisTmp.toLowerCase().contentEquals("true");
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return bRis;
    }

    public void setProxyAbilitato(boolean valore) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            FileOutputStream os = new FileOutputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            prop.setProperty("ProxyAbilitato", valore ? "True" : "False");
            prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getProxyIndirizzoIP() {
        String strRis = "";
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            String strRisTmp = prop.getProperty("ProxyIndirizzoIP");
            if (strRisTmp != null) {
                strRis = strRisTmp.trim();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public void setProxyIndirizzoIP(String valore) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            FileOutputStream os = new FileOutputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            prop.setProperty("ProxyIndirizzoIP", valore);
            prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getProxyPorta() {
        String strRis = "";
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            String strRisTmp = prop.getProperty("ProxyPorta");
            if (strRisTmp != null) {
                strRis = strRisTmp.trim();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public void setProxyPorta(String valore) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            FileOutputStream os = new FileOutputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            prop.setProperty("ProxyPorta", valore);
            prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getProxyUsername() {
        String strRis = "";
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            String strRisTmp = prop.getProperty("ProxyUsername");
            if (strRisTmp != null) {
                strRis = strRisTmp.trim();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public void setProxyUsername(String valore) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            FileOutputStream os = new FileOutputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            prop.setProperty("ProxyUsername", valore);
            prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getProxyPassword() {
        String strRis = "";
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            String strRisTmp = prop.getProperty("ProxyPassword");
            strRisTmp = CipherUtils.decrypt(strRisTmp);
            if (strRisTmp != null) {
                strRis = strRisTmp.trim();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public void setProxyPassword(String valore) {
        try {
            FileInputStream is = new FileInputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            FileOutputStream os = new FileOutputStream(String.valueOf(this.getPathTmp()) + "myinvoice.properties");
            String strRisTmp = CipherUtils.encrypt(valore);
            if (strRisTmp == null) {
                strRisTmp = "";
            }
            prop.setProperty("ProxyPassword", strRisTmp);
            prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private Reader preparePropertyFile(String file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder result = new StringBuilder();
        boolean endingBackslash = false;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            if (endingBackslash && (line.isEmpty() || line.startsWith("#") || line.matches("^\\w+(\\.\\w+)*="))) {
                result.append("\\\\");
            }
            if (line.endsWith("\\")) {
                endingBackslash = true;
                line = line.substring(0, line.length() - 1);
            } else {
                endingBackslash = false;
            }
            result.append(line.replace("\\", "\\\\"));
        }
        reader.close();
        if (endingBackslash) {
            result.append("\\\\");
        }
        return new StringReader(result.toString());
    }

    public String getSourceFolderFromSetup(String strDefault) {
        String strRis = strDefault;
        try {
            byte[] data = Files.readAllBytes(Paths.get(String.valueOf(System.getProperty("user.dir")) + "/setup.ini", new String[0]));
            String contents = new String(data).replaceAll("\\\\", "/");
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes());
            Ini ini = new Ini();
            ini.load(stream);
            strRis = ini.get((Object)"Settings", "SourceFolder");
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return strRis;
    }

    public boolean getEnableSettingsFromSetup(boolean bDefault) {
        boolean bRis = bDefault;
        try {
            byte[] data = Files.readAllBytes(Paths.get(String.valueOf(System.getProperty("user.dir")) + "/setup.ini", new String[0]));
            String contents = new String(data).replaceAll("\\\\", "/");
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes());
            Ini ini = new Ini();
            ini.load(stream);
            bRis = ini.get((Object)"Settings", "EnableSettings").equalsIgnoreCase("True");
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return bRis;
    }

    public void CopiaFileResInLocaleSeNecessario(String nomeFile, boolean bSovrascrivi) {
        try {
            File fileLocale = new File(String.valueOf(this.getPathTmp()) + nomeFile);
            if (!fileLocale.exists() || bSovrascrivi) {
                int length;
                InputStream in = this.getClass().getResourceAsStream("/res/" + nomeFile);
                BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(String.valueOf(this.getPathTmp()) + nomeFile));
                byte[] buffer = new byte[4096];
                while ((length = in.read(buffer)) >= 0) {
                    ((OutputStream)writer).write(buffer, 0, length);
                }
                ((OutputStream)writer).flush();
                ((OutputStream)writer).close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public boolean deleteAllTmp(File dir) {
        File[] filesList;
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        File[] fileArray = filesList = dir.listFiles();
        int n = filesList.length;
        int n2 = 0;
        while (n2 < n) {
            File item = fileArray[n2];
            if (item.isDirectory()) {
                File[] filesList2;
                File[] fileArray2 = filesList2 = item.listFiles();
                int n3 = filesList2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File item2 = fileArray2[n4];
                    item2.delete();
                    ++n4;
                }
                item.delete();
            } else if (item.isFile() && !item.getName().contains(".xsl") && !item.getName().contains(".properties") && !item.getName().contains(".bin")) {
                item.delete();
            }
            ++n2;
        }
        return dir.delete();
    }

    public boolean deleteHtmlTmp(File dir) {
        File[] filesList;
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        File[] fileArray = filesList = dir.listFiles();
        int n = filesList.length;
        int n2 = 0;
        while (n2 < n) {
            File item = fileArray[n2];
            if (item.isFile() && item.getName().contains(".html")) {
                item.delete();
            }
            ++n2;
        }
        return dir.delete();
    }

    private void EliminaNodo(Document doc, String nomeNodo, String nomeNodoPadre1, String nomeNodoPadre2, String nomeNodoPadre3) {
        try {
            NodeList listNode = doc.getElementsByTagName(nomeNodo);
            int i = 0;
            while (i < listNode.getLength()) {
                Element element = (Element)listNode.item(i);
                boolean bEliminaNodo = false;
                if (!nomeNodoPadre3.isEmpty()) {
                    if (element.getParentNode().getNodeName().equalsIgnoreCase(nomeNodoPadre1) && element.getParentNode().getParentNode().getNodeName().equalsIgnoreCase(nomeNodoPadre2) && element.getParentNode().getParentNode().getParentNode().getNodeName().equalsIgnoreCase(nomeNodoPadre3)) {
                        bEliminaNodo = true;
                    }
                } else if (!nomeNodoPadre2.isEmpty()) {
                    if (element.getParentNode().getNodeName().equalsIgnoreCase(nomeNodoPadre1) && element.getParentNode().getParentNode().getNodeName().equalsIgnoreCase(nomeNodoPadre2)) {
                        bEliminaNodo = true;
                    }
                } else if (!nomeNodoPadre1.isEmpty()) {
                    if (element.getParentNode().getNodeName().equalsIgnoreCase(nomeNodoPadre1)) {
                        bEliminaNodo = true;
                    }
                } else {
                    bEliminaNodo = true;
                }
                if (bEliminaNodo) {
                    element.getParentNode().removeChild(element);
                    listNode = doc.getElementsByTagName(nomeNodo);
                    i = -1;
                }
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void EliminaNodoTranneConTipoDato(Document doc, String nomeNodo, String nomeNodoPadre1, String tipoDato) {
        try {
            NodeList listNode = doc.getElementsByTagName(nomeNodo);
            int i = 0;
            while (i < listNode.getLength()) {
                Element element = (Element)listNode.item(i);
                boolean bEliminaNodo = false;
                if (!nomeNodoPadre1.isEmpty()) {
                    if (element.getParentNode().getNodeName().equalsIgnoreCase(nomeNodoPadre1)) {
                        bEliminaNodo = true;
                    }
                } else {
                    bEliminaNodo = true;
                }
                if (bEliminaNodo) {
                    NodeList childNodes = element.getChildNodes();
                    int j = 0;
                    while (j < childNodes.getLength()) {
                        if (childNodes.item(j).getNodeName().equalsIgnoreCase("TipoDato") && childNodes.item(j).getTextContent().equalsIgnoreCase(tipoDato)) {
                            bEliminaNodo = false;
                            break;
                        }
                        ++j;
                    }
                }
                if (bEliminaNodo) {
                    element.getParentNode().removeChild(element);
                    listNode = doc.getElementsByTagName(nomeNodo);
                    i = -1;
                }
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void EliminaNodoAltriDatiGestionali(Document doc, String tipoDato) {
        try {
            NodeList nodes = doc.getElementsByTagName("AltriDatiGestionali");
            int i = 0;
            while (i < nodes.getLength()) {
                Element element = (Element)nodes.item(i);
                boolean bEliminaNodo = false;
                NodeList childNodes = element.getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    if (childNodes.item(j).getNodeName().equalsIgnoreCase("TipoDato") && childNodes.item(j).getTextContent().equalsIgnoreCase(tipoDato)) {
                        bEliminaNodo = true;
                        break;
                    }
                    ++j;
                }
                if (bEliminaNodo) {
                    element.getParentNode().removeChild(element);
                    nodes = doc.getElementsByTagName("AltriDatiGestionali");
                    i = -1;
                }
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private String GetRiferimentoTestoDaTipoDato(Element element, String tipoDato) {
        String riferimentoTesto = "";
        boolean bTrovatoNodo = false;
        NodeList childNodes = element.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            if (childNodes.item(j).getNodeName().equalsIgnoreCase("TipoDato")) {
                if (childNodes.item(j).getTextContent().equalsIgnoreCase(tipoDato)) {
                    bTrovatoNodo = true;
                }
            } else if (bTrovatoNodo && childNodes.item(j).getNodeName().equalsIgnoreCase("RiferimentoTesto")) {
                riferimentoTesto = childNodes.item(j).getTextContent();
                break;
            }
            ++j;
        }
        return riferimentoTesto;
    }

    private int GetRiferimentoNumeroDaTipoDato(Element element, String tipoDato) {
        int riferimentoNumero = 0;
        boolean bTrovatoNodo = false;
        NodeList childNodes = element.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            String strTmp;
            if (childNodes.item(j).getNodeName().equalsIgnoreCase("TipoDato")) {
                if (childNodes.item(j).getTextContent().equalsIgnoreCase(tipoDato)) {
                    bTrovatoNodo = true;
                }
            } else if (bTrovatoNodo && childNodes.item(j).getNodeName().equalsIgnoreCase("RiferimentoNumero") && !(strTmp = childNodes.item(j).getTextContent()).isEmpty()) {
                int nPos = strTmp.indexOf(46);
                if (nPos > 0) {
                    strTmp = strTmp.substring(0, nPos);
                }
                if ((nPos = strTmp.indexOf(44)) > 0) {
                    strTmp = strTmp.substring(0, nPos);
                }
                riferimentoNumero = Integer.parseInt(strTmp.trim());
                break;
            }
            ++j;
        }
        return riferimentoNumero;
    }

    private String GetRiferimentoDataDaTipoDato(Element element, String tipoDato) {
        String riferimentoTesto = "";
        boolean bTrovatoNodo = false;
        NodeList childNodes = element.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            if (childNodes.item(j).getNodeName().equalsIgnoreCase("TipoDato")) {
                if (childNodes.item(j).getTextContent().equalsIgnoreCase(tipoDato)) {
                    bTrovatoNodo = true;
                }
            } else if (bTrovatoNodo && childNodes.item(j).getNodeName().equalsIgnoreCase("RiferimentoData")) {
                riferimentoTesto = childNodes.item(j).getTextContent();
                break;
            }
            ++j;
        }
        return riferimentoTesto;
    }

    private String EstraiTagDaSharp(String testo) {
        String valore = "";
        try {
            if (testo.indexOf("#") > 0) {
                valore = testo.substring(testo.indexOf("#") + 1);
                valore = valore.substring(0, valore.indexOf("#"));
                valore = valore.trim();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return valore;
    }

    private String EstraiTestoSharp(String testo) {
        String valore = "";
        try {
            if (testo.indexOf("#") > 0) {
                valore = testo.substring(0, testo.indexOf("#"));
                valore = valore.trim();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return valore;
    }

    private void ModificaValoreNatura(Element element, String nomeTag, String nuovoValore) {
        NodeList childNodes = element.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            if (childNodes.item(j).getNodeName().equalsIgnoreCase(nomeTag)) {
                CTagNatura natura = new CTagNatura();
                natura.setVecchioTag(childNodes.item(j).getTextContent());
                natura.setNuovoTag(nuovoValore);
                childNodes.item(j).setTextContent(nuovoValore);
            }
            ++j;
        }
    }

    private void ElaboraTagKit(Document doc) {
        block13: {
            ArrayList<String> listLineePadre = new ArrayList<String>();
            try {
                NodeList nodes = doc.getElementsByTagName("AltriDatiGestionali");
                int i = 0;
                while (i < nodes.getLength()) {
                    String riferimentoTesto = this.GetRiferimentoTestoDaTipoDato((Element)nodes.item(i), "AswRifRiga");
                    if (!riferimentoTesto.isEmpty() && riferimentoTesto.contains("KitPadre")) {
                        String tagEstratto = this.EstraiTagDaSharp(riferimentoTesto);
                        listLineePadre.add(tagEstratto);
                    }
                    ++i;
                }
                if (listLineePadre.size() <= 0) break block13;
                for (String numeroLineaPadre : listLineePadre) {
                    ArrayList<Element> listFigli = new ArrayList<Element>();
                    NodeList nodes2 = doc.getElementsByTagName("DettaglioLinee");
                    int i2 = 0;
                    while (i2 < nodes2.getLength()) {
                        NodeList nodes3 = ((Element)nodes2.item(i2)).getElementsByTagName("AltriDatiGestionali");
                        int j = 0;
                        while (j < nodes3.getLength()) {
                            String riferimentoTesto = this.GetRiferimentoTestoDaTipoDato((Element)nodes3.item(j), "AswRifRiga");
                            if (riferimentoTesto.equals("KitFiglio #" + numeroLineaPadre + "#")) {
                                listFigli.add((Element)nodes2.item(i2));
                                break;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    for (Element e2 : listFigli) {
                        e2.getParentNode().removeChild(e2);
                    }
                    NodeList nodes4 = doc.getElementsByTagName("DettaglioLinee");
                    int i3 = 0;
                    while (i3 < nodes4.getLength()) {
                        NodeList nodes5 = ((Element)nodes4.item(i3)).getElementsByTagName("AltriDatiGestionali");
                        int j = 0;
                        while (j < nodes5.getLength()) {
                            String riferimentoTesto = this.GetRiferimentoTestoDaTipoDato((Element)nodes5.item(j), "AswRifRiga");
                            if (riferimentoTesto.equals("KitPadre #" + numeroLineaPadre + "#")) {
                                int z = listFigli.size() - 1;
                                while (z >= 0) {
                                    nodes4.item(i3).getParentNode().insertBefore((org.w3c.dom.Node)listFigli.get(z), nodes4.item(i3).getNextSibling());
                                    --z;
                                }
                                break;
                            }
                            ++j;
                        }
                        ++i3;
                    }
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    private void ElaboraTagNaturaDettaglioLinee(Document doc) {
        try {
            NodeList nodes = doc.getElementsByTagName("AltriDatiGestionali");
            int i = 0;
            while (i < nodes.getLength()) {
                String riferimentoTesto = this.GetRiferimentoTestoDaTipoDato((Element)nodes.item(i), "ASWCODIVA");
                if (!riferimentoTesto.isEmpty()) {
                    String tagEstratto = this.EstraiTagDaSharp(riferimentoTesto);
                    this.ModificaValoreNatura((Element)nodes.item(i).getParentNode(), "Natura", tagEstratto);
                }
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void ElaboraTagOpzPrezzoTotale(Document doc) {
        try {
            NodeList nodes = doc.getElementsByTagName("AltriDatiGestionali");
            int i = 0;
            while (i < nodes.getLength()) {
                String riferimentoTesto = this.GetRiferimentoTestoDaTipoDato((Element)nodes.item(i), "ASWTRIGA");
                if (!riferimentoTesto.isEmpty() && (riferimentoTesto.contains("#OS") || riferimentoTesto.contains("#OC") || riferimentoTesto.contains("#SO") || riferimentoTesto.contains("#SM"))) {
                    String testoEstratto = this.EstraiTestoSharp(riferimentoTesto);
                    Element element = doc.createElement("OpzPrezzoTotale");
                    element.setTextContent(testoEstratto);
                    nodes.item(i).getParentNode().appendChild(element);
                }
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void ElaboraTagOpzPrezzoTotale2(Document doc) {
        try {
            NodeList nodes = doc.getElementsByTagName("AltriDatiGestionali");
            int i = 0;
            while (i < nodes.getLength()) {
                String riferimentoTesto = this.GetRiferimentoTestoDaTipoDato((Element)nodes.item(i), "ASWTRIGA");
                if (!riferimentoTesto.isEmpty() && (riferimentoTesto.contains("#NO") || riferimentoTesto.contains("#VA") || riferimentoTesto.contains("#DE"))) {
                    String testoEstratto = this.EstraiTestoSharp(riferimentoTesto);
                    Element element = doc.createElement("OpzPrezzoTotale");
                    element.setTextContent(testoEstratto);
                    nodes.item(i).getParentNode().appendChild(element);
                }
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void ElaboraTagOpzDescrizionePagamento(Document doc) {
        try {
            NodeList nodes = doc.getElementsByTagName("AltriDatiGestionali");
            int i = 0;
            while (i < nodes.getLength()) {
                NodeList nodes2;
                String riferimentoTesto = this.GetRiferimentoTestoDaTipoDato((Element)nodes.item(i), "AswTipoPag");
                int riferimentoNumero = this.GetRiferimentoNumeroDaTipoDato((Element)nodes.item(i), "AswTipoPag");
                if (!riferimentoTesto.isEmpty() && riferimentoNumero > 0 && riferimentoNumero <= (nodes2 = doc.getElementsByTagName("DettaglioPagamento")).getLength()) {
                    Element element = doc.createElement("OpzDescrizionePagamento");
                    element.setTextContent(this.EstraiTestoSharp(riferimentoTesto));
                    nodes2.item(riferimentoNumero - 1).appendChild(element);
                }
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void ElaboraTagNaturaDatiRiepilogo(Document doc) {
        ArrayList<CTagNatura> listTagNatura = new ArrayList<CTagNatura>();
        try {
            NodeList nodes = doc.getElementsByTagName("DatiRiepilogo");
            int i = 0;
            while (i < nodes.getLength()) {
                Element element = (Element)nodes.item(i);
                CTagNatura tagNatura = new CTagNatura();
                NodeList childNodes = element.getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    String nuovoTag;
                    if (childNodes.item(j).getNodeName().equalsIgnoreCase("RiferimentoNormativo") && !(nuovoTag = this.EstraiTagDaSharp(childNodes.item(j).getTextContent())).isEmpty()) {
                        tagNatura.setNuovoTag(nuovoTag);
                        tagNatura.setTestoRiferimento(this.EstraiTestoSharp(childNodes.item(j).getTextContent()));
                        childNodes.item(j).setTextContent(this.EstraiTestoSharp(childNodes.item(j).getTextContent()));
                    }
                    ++j;
                }
                if (!tagNatura.getNuovoTag().isEmpty()) {
                    j = 0;
                    while (j < childNodes.getLength()) {
                        if (childNodes.item(j).getNodeName().equalsIgnoreCase("Natura")) {
                            tagNatura.setVecchioTag(childNodes.item(j).getTextContent());
                            childNodes.item(j).setTextContent(tagNatura.getNuovoTag());
                            listTagNatura.add(tagNatura);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private int CalcolaNumeroBody(NodeList nodesListBody, org.w3c.dom.Node node) {
        int numBody = 0;
        if (nodesListBody.getLength() > 1) {
            int i = 0;
            while (i < nodesListBody.getLength()) {
                if ((node.compareDocumentPosition(nodesListBody.item(i)) & 8) > 0) {
                    numBody = i + 1;
                    break;
                }
                ++i;
            }
        } else {
            numBody = 1;
        }
        return numBody;
    }

    private void ElaboraTagOpzPreLineaDatiDDT(Document doc) {
        ArrayList<CTagDatiDDT> listTagDatiDDT = new ArrayList<CTagDatiDDT>();
        boolean bIsMultiBody = false;
        NodeList nodesListBody = doc.getElementsByTagName("FatturaElettronicaBody");
        if (nodesListBody != null && nodesListBody.getLength() > 1) {
            bIsMultiBody = true;
        }
        try {
            NodeList nodes = doc.getElementsByTagName("DatiDDT");
            int i = 0;
            while (i < nodes.getLength()) {
                Element element = (Element)nodes.item(i);
                CTagDatiDDT datiDDT = new CTagDatiDDT();
                datiDDT.setNumeroBody(bIsMultiBody ? this.CalcolaNumeroBody(nodesListBody, nodes.item(i)) : 1);
                NodeList childNodes = element.getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    if (childNodes.item(j).getNodeName().equalsIgnoreCase("NumeroDDT")) {
                        datiDDT.setNumeroDDT(childNodes.item(j).getTextContent());
                    } else if (childNodes.item(j).getNodeName().equalsIgnoreCase("DataDDT")) {
                        datiDDT.setDataDDT(childNodes.item(j).getTextContent());
                    } else if (childNodes.item(j).getNodeName().equalsIgnoreCase("RiferimentoNumeroLinea")) {
                        datiDDT.addRiferimentoNumeroLinea(Integer.parseInt(childNodes.item(j).getTextContent().trim()));
                    }
                    ++j;
                }
                listTagDatiDDT.add(datiDDT);
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (listTagDatiDDT.size() > 0) {
            block4: for (CTagDatiDDT datiDDT : listTagDatiDDT) {
                NodeList nodes = doc.getElementsByTagName("NumeroLinea");
                int i = 0;
                while (i < nodes.getLength()) {
                    int numeroBodyTagNumeroLinea;
                    int n = numeroBodyTagNumeroLinea = bIsMultiBody ? this.CalcolaNumeroBody(nodesListBody, nodes.item(i)) : 1;
                    if (numeroBodyTagNumeroLinea == datiDDT.getNumeroBody()) {
                        Element element = (Element)nodes.item(i);
                        Integer numeroLinea = Integer.parseInt(element.getTextContent().trim());
                        if (datiDDT.getRiferimentoNumeroLinea().contains(numeroLinea) || datiDDT.getRiferimentoNumeroLinea().size() == 0) {
                            Element element2 = doc.createElement("OpzPreLineaDatiDDT");
                            String strTmp = "D.D.T. " + datiDDT.getNumeroDDT();
                            if (datiDDT.getDataDDT() != null) {
                                strTmp = String.valueOf(strTmp) + " del " + datiDDT.getDataDDT();
                            }
                            element2.setTextContent(strTmp);
                            element.getParentNode().appendChild(element2);
                        }
                        if (datiDDT.getRiferimentoNumeroLinea().size() == 0) continue block4;
                    }
                    ++i;
                }
            }
        }
    }

    private void ElaboraTagOpzPreLineaDatiOrdineAcquisto(Document doc, String tagSorgente, String tagDestinazione, String strEtichetta) {
        ArrayList<CTagDatiOrdineAcquisto> listTagDatiOrdineAcquisto = new ArrayList<CTagDatiOrdineAcquisto>();
        boolean bIsMultiBody = false;
        NodeList nodesListBody = doc.getElementsByTagName("FatturaElettronicaBody");
        if (nodesListBody != null && nodesListBody.getLength() > 1) {
            bIsMultiBody = true;
        }
        try {
            NodeList nodes = doc.getElementsByTagName(tagSorgente);
            int i = 0;
            while (i < nodes.getLength()) {
                Element element = (Element)nodes.item(i);
                CTagDatiOrdineAcquisto datiOrdineAcquisto = new CTagDatiOrdineAcquisto();
                datiOrdineAcquisto.setNumeroBody(bIsMultiBody ? this.CalcolaNumeroBody(nodesListBody, nodes.item(i)) : 1);
                NodeList childNodes = element.getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    if (childNodes.item(j).getNodeName().equalsIgnoreCase("IdDocumento")) {
                        datiOrdineAcquisto.setIdDocumento(childNodes.item(j).getTextContent());
                    } else if (childNodes.item(j).getNodeName().equalsIgnoreCase("Data")) {
                        datiOrdineAcquisto.setData(childNodes.item(j).getTextContent());
                    } else if (childNodes.item(j).getNodeName().equalsIgnoreCase("RiferimentoNumeroLinea")) {
                        datiOrdineAcquisto.addRiferimentoNumeroLinea(Integer.parseInt(childNodes.item(j).getTextContent().trim()));
                    } else if (childNodes.item(j).getNodeName().equalsIgnoreCase("CodiceCUP")) {
                        datiOrdineAcquisto.setCodiceCUP(childNodes.item(j).getTextContent());
                    } else if (childNodes.item(j).getNodeName().equalsIgnoreCase("CodiceCIG")) {
                        datiOrdineAcquisto.setCodiceCIG(childNodes.item(j).getTextContent());
                    }
                    ++j;
                }
                listTagDatiOrdineAcquisto.add(datiOrdineAcquisto);
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (listTagDatiOrdineAcquisto.size() > 0) {
            block4: for (CTagDatiOrdineAcquisto datiOrdineAcquisto : listTagDatiOrdineAcquisto) {
                NodeList nodes = doc.getElementsByTagName("NumeroLinea");
                int i = 0;
                while (i < nodes.getLength()) {
                    int numeroBodyTagNumeroLinea;
                    int n = numeroBodyTagNumeroLinea = bIsMultiBody ? this.CalcolaNumeroBody(nodesListBody, nodes.item(i)) : 1;
                    if (numeroBodyTagNumeroLinea == datiOrdineAcquisto.getNumeroBody()) {
                        Element element = (Element)nodes.item(i);
                        Integer numeroLinea = Integer.parseInt(element.getTextContent().trim());
                        if (datiOrdineAcquisto.getRiferimentoNumeroLinea().contains(numeroLinea) || datiOrdineAcquisto.getRiferimentoNumeroLinea().size() == 0) {
                            Element element2 = doc.createElement(tagDestinazione);
                            String strTmp = String.valueOf(strEtichetta) + " " + datiOrdineAcquisto.getIdDocumento();
                            if (datiOrdineAcquisto.getData() != null) {
                                strTmp = String.valueOf(strTmp) + " del " + datiOrdineAcquisto.getData();
                            }
                            if (datiOrdineAcquisto.getCodiceCUP() != null) {
                                strTmp = String.valueOf(strTmp) + " CUP:" + datiOrdineAcquisto.getCodiceCUP();
                            }
                            if (datiOrdineAcquisto.getCodiceCIG() != null) {
                                strTmp = String.valueOf(strTmp) + " CIG:" + datiOrdineAcquisto.getCodiceCIG();
                            }
                            element2.setTextContent(strTmp);
                            element.getParentNode().appendChild(element2);
                        }
                        if (datiOrdineAcquisto.getRiferimentoNumeroLinea().size() == 0) continue block4;
                    }
                    ++i;
                }
            }
        }
    }

    private void ElaboraTagOpzPostLineaAswDichInt(Document doc) {
        try {
            NodeList nodes = doc.getElementsByTagName("DettaglioLinee");
            int i = 0;
            while (i < nodes.getLength()) {
                Element element = (Element)nodes.item(i);
                NodeList nodes2 = element.getElementsByTagName("AltriDatiGestionali");
                int j = 0;
                while (j < nodes2.getLength()) {
                    String riferimentoTesto = this.GetRiferimentoTestoDaTipoDato((Element)nodes2.item(j), "AswDichInt");
                    if (!riferimentoTesto.isEmpty()) {
                        String strTmp = "Dichiarazione d'intento";
                        String riferimentoData = this.GetRiferimentoDataDaTipoDato((Element)nodes2.item(j), "AswDichInt");
                        if (!riferimentoData.isEmpty()) {
                            strTmp = String.valueOf(strTmp) + " - Data:" + riferimentoData;
                        }
                        strTmp = String.valueOf(strTmp) + " - Prot:" + riferimentoTesto;
                        int riferimentoNumero = this.GetRiferimentoNumeroDaTipoDato((Element)nodes2.item(j), "AswDichInt");
                        if (riferimentoNumero > 0) {
                            strTmp = String.valueOf(strTmp) + " - Prog:" + riferimentoNumero;
                        }
                        Element element2 = doc.createElement("OpzPostLinea");
                        element2.setTextContent(strTmp);
                        element.appendChild(element2);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private int VerificaNumeroBody(Document doc) {
        int nNumBody = 0;
        try {
            NodeList nodes = doc.getElementsByTagName("FatturaElettronicaBody");
            nNumBody = nodes.getLength();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return nNumBody;
    }

    private String GeneraFileXML_esteso(File inputFilename) {
        String pathFileEsteso;
        File fileEsteso;
        this.Logga("Inizio GeneraFileXML_esteso [" + inputFilename.getAbsolutePath() + "]");
        String fileNameEsteso = this.NascondiDirDefault(inputFilename.getAbsolutePath());
        if (fileNameEsteso.isEmpty()) {
            fileNameEsteso = this.getFilenameWithoutExtension(inputFilename.getName());
        }
        if (!(fileEsteso = new File(pathFileEsteso = String.valueOf(this.pathTmp) + fileNameEsteso + "_esteso.xml")).exists()) {
            try {
                boolean bEseguiElaborazione;
                FileInputStream inputTmp = new FileInputStream(inputFilename);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(inputTmp);
                doc.getDocumentElement().normalize();
                boolean bl = bEseguiElaborazione = this.VerificaNumeroBody(doc) == 1;
                if (bEseguiElaborazione) {
                    this.EliminaNodo(doc, "IdTrasmittente", "DatiTrasmissione", "", "");
                    this.EliminaNodo(doc, "ProgressivoInvio", "DatiTrasmissione", "", "");
                    this.EliminaNodo(doc, "FormatoTrasmissione", "DatiTrasmissione", "", "");
                    this.EliminaNodo(doc, "ContattiTrasmittente", "DatiTrasmissione", "", "");
                    this.EliminaNodo(doc, "ContattiTrasmittente", "DatiTrasmissione", "", "");
                    this.EliminaNodo(doc, "Titolo", "Anagrafica", "DatiAnagrafici", "CedentePrestatore");
                    this.EliminaNodo(doc, "CodEORI", "Anagrafica", "DatiAnagrafici", "CedentePrestatore");
                    this.EliminaNodo(doc, "AlboProfessionale", "DatiAnagrafici", "CedentePrestatore", "");
                    this.EliminaNodo(doc, "ProvinciaAlbo", "DatiAnagrafici", "CedentePrestatore", "");
                    this.EliminaNodo(doc, "NumeroIscrizioneAlbo", "DatiAnagrafici", "CedentePrestatore", "");
                    this.EliminaNodo(doc, "DataIscrizioneAlbo", "DatiAnagrafici", "CedentePrestatore", "");
                    this.EliminaNodo(doc, "IscrizioneREA", "CedentePrestatore", "", "");
                    this.EliminaNodo(doc, "Fax", "Contatti", "CedentePrestatore", "");
                    this.EliminaNodo(doc, "Titolo", "Anagrafica", "DatiAnagrafici", "RappresentanteFiscale");
                    this.EliminaNodo(doc, "Titolo", "Anagrafica", "DatiAnagrafici", "CessionarioCommittente");
                    this.EliminaNodo(doc, "BolloVirtuale", "DatiBollo", "DatiGeneraliDocumento", "DatiGenerali");
                    this.EliminaNodo(doc, "DatiConvenzione", "DatiGenerali", "", "");
                    this.EliminaNodo(doc, "DatiRicezione", "DatiGenerali", "", "");
                    this.EliminaNodo(doc, "DatiAnagraficiVettore", "DatiTrasporto", "DatiGenerali", "");
                    this.EliminaNodo(doc, "FatturaPrincipale", "DatiGenerali", "", "");
                    this.EliminaNodo(doc, "DatiVeicoli", "", "", "");
                    this.EliminaNodo(doc, "AlgoritmoCompressione", "Allegati", "", "");
                    this.EliminaNodo(doc, "FormatoAttachment", "Allegati", "", "");
                    this.ElaboraTagKit(doc);
                    this.ElaboraTagNaturaDettaglioLinee(doc);
                    this.ElaboraTagOpzPrezzoTotale(doc);
                    this.ElaboraTagOpzPrezzoTotale2(doc);
                    this.ElaboraTagNaturaDatiRiepilogo(doc);
                    this.ElaboraTagOpzDescrizionePagamento(doc);
                    this.ElaboraTagOpzPostLineaAswDichInt(doc);
                    this.EliminaNodoAltriDatiGestionali(doc, "AswTratSco");
                    this.EliminaNodoAltriDatiGestionali(doc, "AswSconMag");
                    this.EliminaNodoAltriDatiGestionali(doc, "AswPremio");
                    this.EliminaNodoAltriDatiGestionali(doc, "AswPromo");
                    this.EliminaNodoAltriDatiGestionali(doc, "AswSpSanit");
                    this.EliminaNodoAltriDatiGestionali(doc, "AswConCont");
                    this.EliminaNodoAltriDatiGestionali(doc, "AswCenCost");
                    this.EliminaNodoAltriDatiGestionali(doc, "AswDichInt");
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (doc.getXmlEncoding() != null) {
                    transformer.setOutputProperty("encoding", doc.getXmlEncoding());
                }
                DOMSource source = new DOMSource(doc);
                StreamResult streamResult = new StreamResult(fileEsteso);
                transformer.transform(source, streamResult);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.Logga("Fine GeneraFileXML_esteso [" + pathFileEsteso + "]");
        return pathFileEsteso;
    }

    public String applyStyleSheetsXml(File inputFilename) {
        File pTmp;
        this.Logga("Inizio applyStyleSheetsXml");
        this.Logga("inputFilename=" + inputFilename.getAbsolutePath());
        String outputFileName = this.NascondiDirDefault(inputFilename.getAbsolutePath());
        if (outputFileName.isEmpty()) {
            outputFileName = this.getFilenameWithoutExtension(inputFilename.getName());
        }
        if (!(pTmp = new File(this.pathTmp)).exists()) {
            pTmp.mkdir();
        }
        File outFile = new File(String.valueOf(this.pathTmp) + outputFileName + ".html");
        this.Logga("outFile=" + outFile.getAbsolutePath());
        if (outFile.exists()) {
            this.Logga("Il file esiste gi\u00e0 su disco, non \u00e8 necessario rigenerarlo");
            return outFile.getAbsolutePath();
        }
        try {
            this.Logga("Richiesto applicazione foglio di stile");
            this.Logga("styleSheetsFatt=" + this.styleSheetsFatt);
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream in = new FileInputStream(this.styleSheetsFatt);){
                TransformerFactory factory = TransformerFactory.newInstance();
                Templates template = factory.newTemplates(new StreamSource(in));
                Transformer xformer = template.newTransformer();
                String branch = outFile.getParentFile().getCanonicalPath().substring("root".length());
                branch = branch.replace(File.separatorChar, '/');
                StringBuffer path = new StringBuffer();
                int i = 0;
                while (i < branch.length()) {
                    if (branch.charAt(i) == '/') {
                        path.append("/..");
                    }
                    ++i;
                }
                xformer.setParameter("branch", branch);
                xformer.setParameter("root", path.toString());
                if (this.styleSheetsFatt.contains(this.getXslMyInvoiceWork())) {
                    inputFilename = new File(this.GeneraFileXML_esteso(inputFilename));
                    this.Logga("La preview utilizza il foglio di stile MyInvoice");
                } else {
                    this.Logga("La preview utilizza il foglio di stile ministeriale");
                }
                Throwable throwable2 = null;
                Object var14_19 = null;
                try (FileInputStream input = new FileInputStream(inputFilename);){
                    StreamSource sourceStream = new StreamSource(input);
                    this.Logga("Prima di xformer.transform");
                    Throwable throwable3 = null;
                    Object var18_25 = null;
                    try (FileOutputStream output = new FileOutputStream(outFile);){
                        StreamResult resultStream = new StreamResult(output);
                        xformer.transform(sourceStream, resultStream);
                        resultStream.getOutputStream().close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    this.Logga("Dopo di xformer.transform");
                    this.Logga("outFile=" + outFile.getAbsolutePath());
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            this.Logga("Exception " + e2.getMessage());
            return "";
        }
        this.Logga("Fine applyStyleSheetsXml");
        return outFile.getAbsolutePath();
    }

    public int getCalendarFromDate(Date data, Integer formatField) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(data);
        return calendar.get(formatField);
    }

    public boolean downloadFile(String fileURL, String saveDir) {
        boolean esito = false;
        try {
            if (this.getProxyAbilitato()) {
                this.Logga("Richiesto downloadFile con proxy server " + this.getProxyIndirizzoIP());
                Authenticator.setDefault(new SimpleAuthenticator(this.getProxyUsername(), this.getProxyPassword()));
                Properties systemProperties = System.getProperties();
                systemProperties.setProperty("http.proxyHost", this.getProxyIndirizzoIP());
                systemProperties.setProperty("http.proxyPort", this.getProxyPorta());
            } else {
                this.Logga("Richiesto downloadFile senza proxy server");
            }
            URL url = new URL(String.valueOf(fileURL) + "?cacheFrom=" + System.currentTimeMillis());
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-GB;     rv:1.9.2.13) Gecko/20101203 Firefox/3.6.13 (.NET CLR 3.5.30729)");
            int responseCode = httpConn.getResponseCode();
            this.Logga("Esito downloadFile responseCode=" + responseCode);
            if (responseCode == 200) {
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(index + 10, disposition.length() - 1);
                    }
                } else {
                    fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
                }
                InputStream inputStream = httpConn.getInputStream();
                String saveFilePath = String.valueOf(saveDir) + File.separator + fileName;
                FileOutputStream outputStream = new FileOutputStream(saveFilePath);
                int bytesRead = -1;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                httpConn.disconnect();
                esito = true;
            }
        }
        catch (Exception e2) {
            this.Logga("Exception " + e2.getMessage());
        }
        return esito;
    }

    public int VerificaAggiornamentoFoglioDiStile(String pathTmp, String nomeFileTmp, String nomeFileWork) {
        int nEsito = 0;
        try {
            File tmpFile = new File(String.valueOf(pathTmp) + nomeFileTmp);
            File workFile = new File(String.valueOf(pathTmp) + nomeFileWork);
            if (tmpFile.exists()) {
                if (workFile.exists()) {
                    if (!FileUtils.contentEquals(tmpFile, workFile)) {
                        FileUtils.copyFile(tmpFile, workFile);
                        nEsito = 1;
                    }
                } else {
                    FileUtils.copyFile(tmpFile, workFile);
                    nEsito = 1;
                }
            } else {
                nEsito = -1;
            }
        }
        catch (Exception e2) {
            nEsito = 1;
            e2.printStackTrace();
        }
        return nEsito;
    }

    public void Logga(String strMsg) {
        try {
            String filename = String.valueOf(this.pathTmp) + "myinvoice.log";
            FileWriter fw = new FileWriter(filename, true);
            fw.write(String.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date())) + "|" + strMsg + "\r\n");
            fw.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public String NormalizzaNomeFile(String param) {
        if (param != null) {
            param = param.replace("~", "_");
            param = param.replace("#", "_");
            param = param.replace("%", "_");
            param = param.replace("&", "_");
            param = param.replace("*", "_");
            param = param.replace("{", "_");
            param = param.replace("}", "_");
            param = param.replace("\\", "_");
            param = param.replace(":", "_");
            param = param.replace("<", "_");
            param = param.replace(">", "_");
            param = param.replace("?", "_");
            param = param.replace("/", "_");
            param = param.replace("+", "_");
            param = param.replace("|", "_");
            param = param.replace("\"", "_");
            param = param.replace(" ", "_");
        }
        return param;
    }

    public String GeneraGUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public String NascondiDirDefault(String nomeFileSuDisco) {
        String ris = "";
        if (nomeFileSuDisco != null) {
            Preferences preferences = Preferences.userRoot();
            String directoryDefaultTmp = preferences.node("settings").get("directoryDefault", "");
            directoryDefaultTmp = directoryDefaultTmp.replace("\\", "|");
            directoryDefaultTmp = directoryDefaultTmp.replace("/", "|");
            directoryDefaultTmp = directoryDefaultTmp.replace("||", "|");
            ris = nomeFileSuDisco;
            ris = ris.replace("\\", "|");
            ris = ris.replace("/", "|");
            if ((ris = ris.replace("||", "|")).contains(directoryDefaultTmp)) {
                ris = ris.replace(directoryDefaultTmp, "");
                while (ris.length() > 0 && ris.startsWith("|")) {
                    ris = ris.substring(1);
                }
                ris = ris.replace("|", " - ");
            } else {
                ris = "";
            }
        }
        return ris;
    }

    public List<String> CaricaListaContrassegnateDaDisco() {
        List<String> lista = new ArrayList<String>();
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(String.valueOf(this.pathTmp) + "dbContrassegnate.bin"));
            lista = (List)ois.readObject();
            ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lista;
    }

    public void SalvaListaContrassegnateSuDisco(List<String> lista) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(String.valueOf(this.pathTmp) + "dbContrassegnate.bin"));
            oos.writeObject(lista);
            oos.flush();
            oos.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

