/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javax.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.bouncycastle.tsp.cms.CMSTimeStampedData;
import org.bouncycastle.util.Store;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import utility.Functions;

public class Sign {
    private Font customFontTitle = Font.loadFont((String)this.getClass().getResource("/res/EngraversGothic.ttf").toExternalForm(), (double)18.0);

    private void verifyP7M(byte[] buffer, Accordion nodeAccordion) throws ParseException, CMSException, CertificateException, OperatorCreationException {
        CMSSignedData signature = new CMSSignedData(buffer);
        Store cs = signature.getCertificates();
        SignerInformationStore signers = signature.getSignerInfos();
        Collection<SignerInformation> cSigners = signers.getSigners();
        int numSign = 1;
        for (SignerInformation signerInformation : cSigners) {
            TitledPane tpSign = new TitledPane();
            tpSign.setTextFill((Paint)Color.rgb((int)46, (int)175, (int)235));
            tpSign.setFont(this.customFontTitle);
            if (cSigners.size() > 1) {
                tpSign.setText("Firma (" + String.valueOf(numSign) + ")");
            } else {
                tpSign.setText("Firma");
            }
            tpSign.setExpanded(true);
            tpSign.setAnimated(false);
            VBox vboxInformations = new VBox();
            vboxInformations.setStyle("-fx-background-radius: 1em; -fx-background-color: transparent");
            TextFlow informations = new TextFlow();
            Text labelData = new Text("Data di firma: ");
            Text valueData = new Text();
            labelData.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
            valueData.setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
            Text labelVerifySign = new Text("Stato della firma: ");
            Text valueVerifySign = new Text();
            labelVerifySign.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
            Collection certCollection = cs.getMatches(signerInformation.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
            java.security.cert.X509Certificate certFromSignedData = new JcaX509CertificateConverter().setProvider(new BouncyCastleProvider()).getCertificate(certHolder);
            if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(new BouncyCastleProvider()).build(certFromSignedData))) {
                valueVerifySign.setText("Firma valida\n\n");
                valueVerifySign.setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt;-fx-fill: green;");
            } else {
                valueVerifySign.setText("Firma non valida\n\n");
                valueVerifySign.setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt;-fx-fill: red;");
            }
            informations.getChildren().addAll((Object[])new Node[]{labelVerifySign, valueVerifySign});
            AttributeTable signedAttr = signerInformation.getSignedAttributes();
            Attribute signingTime = signedAttr.get(CMSAttributes.signingTime);
            if (signingTime != null) {
                Enumeration en = signingTime.getAttrValues().getObjects();
                while (en.hasMoreElements()) {
                    Object obj = en.nextElement();
                    if (obj instanceof ASN1UTCTime) {
                        ASN1UTCTime asn1Time = (ASN1UTCTime)obj;
                        valueData.setText(String.valueOf(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(asn1Time.getDate())) + "\n");
                        continue;
                    }
                    if (!(obj instanceof DERUTCTime)) continue;
                    DERUTCTime derTime = (DERUTCTime)obj;
                    valueData.setText(String.valueOf(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(derTime.getDate())) + "\n");
                }
            } else {
                valueData.setText("Data di firma: nessuna\n");
            }
            informations.getChildren().addAll((Object[])new Node[]{labelData, valueData});
            Text labelSubject = new Text("\nSoggetto\n\n");
            labelSubject.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
            informations.getChildren().add((Object)labelSubject);
            ArrayList<Text> valueSubject = new ArrayList<Text>();
            Text labelIssuer = new Text("\nCertificato emesso da:\n\n");
            labelIssuer.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
            ArrayList<Text> valueIssuer = new ArrayList<Text>();
            String[] informationsSubject = certHolder.getSubject().toString().split(",");
            int i = 0;
            while (i < informationsSubject.length) {
                valueSubject.add(new Text("    \u2022 " + informationsSubject[i].toString() + "\n\n"));
                ((Text)valueSubject.get(i)).setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                informations.getChildren().addAll((Object[])new Node[]{(Node)valueSubject.get(i)});
                ++i;
            }
            if (!informations.getChildren().contains((Object)labelIssuer)) {
                informations.getChildren().addAll((Object[])new Node[]{labelIssuer});
            }
            String[] informationsIssuer = certHolder.getIssuer().toString().split(",");
            i = 0;
            while (i < informationsIssuer.length) {
                if (i == informationsIssuer.length - 1) {
                    valueIssuer.add(new Text("    \u2022 " + informationsIssuer[i].toString()));
                } else {
                    valueIssuer.add(new Text("    \u2022 " + informationsIssuer[i].toString() + "\n\n"));
                }
                ((Text)valueIssuer.get(i)).setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                informations.getChildren().addAll((Object[])new Node[]{(Node)valueIssuer.get(i)});
                ++i;
            }
            ++numSign;
            vboxInformations.getChildren().addAll((Object[])new Node[]{informations});
            tpSign.setContent((Node)vboxInformations);
            nodeAccordion.getPanes().addAll((Object[])new TitledPane[]{tpSign});
        }
    }

    private void verifyXades(byte[] buffer, Accordion nodeAccordion) throws ParseException, CMSException, CertificateException, OperatorCreationException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(buffer));
            NodeList nodelist = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            if (nodelist.getLength() > 0) {
                int j = 0;
                while (j < nodelist.getLength()) {
                    X509Certificate cert = X509Certificate.getInstance(Base64.getMimeDecoder().decode(nodelist.item(j).getTextContent()));
                    TitledPane tpSign = new TitledPane();
                    tpSign.setTextFill((Paint)Color.rgb((int)46, (int)175, (int)235));
                    tpSign.setFont(this.customFontTitle);
                    if (nodelist.getLength() > 1) {
                        tpSign.setText("Firma (" + String.valueOf(j + 1) + ")");
                    } else {
                        tpSign.setText("Firma");
                    }
                    tpSign.setExpanded(true);
                    tpSign.setAnimated(false);
                    VBox vboxInformations = new VBox();
                    vboxInformations.setStyle("-fx-background-radius: 1em; -fx-background-color: transparent");
                    TextFlow informations = new TextFlow();
                    Text labelData = new Text("Data di firma: ");
                    Text valueData = new Text();
                    Text labelSubject = new Text("\nSoggetto\n\n");
                    labelSubject.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
                    informations.getChildren().add((Object)labelSubject);
                    ArrayList<Text> valueSubject = new ArrayList<Text>();
                    Text labelIssuer = new Text("\nCertificato emesso da:\n\n");
                    labelIssuer.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
                    ArrayList<Text> valueIssuer = new ArrayList<Text>();
                    String[] informationsSubject = cert.getSubjectDN().toString().split(",");
                    int i = 0;
                    while (i < informationsSubject.length) {
                        valueSubject.add(new Text("    \u2022 " + informationsSubject[i].toString() + "\n\n"));
                        ((Text)valueSubject.get(i)).setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                        informations.getChildren().addAll((Object[])new Node[]{(Node)valueSubject.get(i)});
                        ++i;
                    }
                    if (!informations.getChildren().contains((Object)labelIssuer)) {
                        informations.getChildren().addAll((Object[])new Node[]{labelIssuer});
                    }
                    String[] informationsIssuer = cert.getIssuerDN().toString().split(",");
                    i = 0;
                    while (i < informationsIssuer.length) {
                        if (i == informationsIssuer.length - 1) {
                            valueIssuer.add(new Text("    \u2022 " + informationsIssuer[i].toString()));
                        } else {
                            valueIssuer.add(new Text("    \u2022 " + informationsIssuer[i].toString() + "\n\n"));
                        }
                        ((Text)valueIssuer.get(i)).setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                        informations.getChildren().addAll((Object[])new Node[]{(Node)valueIssuer.get(i)});
                        ++i;
                    }
                    vboxInformations.getChildren().addAll((Object[])new Node[]{informations});
                    tpSign.setContent((Node)vboxInformations);
                    nodeAccordion.getPanes().addAll((Object[])new TitledPane[]{tpSign});
                    ++j;
                }
            } else {
                TitledPane tpSign = new TitledPane();
                tpSign.setTextFill((Paint)Color.rgb((int)46, (int)175, (int)235));
                tpSign.setFont(this.customFontTitle);
                tpSign.setText("Nessuna firma");
                tpSign.setExpanded(true);
                tpSign.setAnimated(false);
                tpSign.setMinWidth(300.0);
                nodeAccordion.getPanes().addAll((Object[])new TitledPane[]{tpSign});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public VBox verify(String file) throws CMSException, IOException, ParseException, CertificateException, OperatorCreationException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, TSPException {
        File f2 = new File(file);
        byte[] buffer = new byte[(int)f2.length()];
        DataInputStream in = new DataInputStream(new FileInputStream(f2));
        in.readFully(buffer);
        in.close();
        VBox vboxVerifySign = new VBox();
        vboxVerifySign.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        vboxVerifySign.setStyle("-fx-background-radius: 1em; -fx-background-color: transparent");
        Accordion accordions = new Accordion();
        accordions.setStyle("-fx-background-radius: 1em; -fx-background-color: transparent");
        accordions.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        byte[] bufDecoded = null;
        try {
            bufDecoded = Base64.getMimeDecoder().decode(buffer);
        }
        catch (Exception e2) {
            bufDecoded = (byte[])buffer.clone();
        }
        if (file.toString().toLowerCase().endsWith(".p7m")) {
            this.verifyP7M(bufDecoded, accordions);
        } else if (file.toString().toLowerCase().endsWith(".xml")) {
            this.verifyXades(bufDecoded, accordions);
        } else if (file.toString().toLowerCase().endsWith(".tsd")) {
            TimeStampToken[] tokens;
            int numMark = 1;
            CMSTimeStampedData marked = new CMSTimeStampedData(bufDecoded);
            TimeStampToken[] timeStampTokenArray = tokens = marked.getTimeStampTokens();
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                TimeStampToken token = timeStampTokenArray[n2];
                TimeStampTokenInfo infoMark = token.getTimeStampInfo();
                TitledPane tpMarked = new TitledPane();
                tpMarked.setTextFill((Paint)Color.rgb((int)46, (int)175, (int)235));
                tpMarked.setFont(this.customFontTitle);
                if (tokens.length > 1) {
                    tpMarked.setText("Marcatura (" + String.valueOf(numMark) + ")");
                } else {
                    tpMarked.setText("Marcatura");
                }
                tpMarked.setExpanded(true);
                tpMarked.setAnimated(false);
                VBox vboxInformationsMark = new VBox();
                vboxInformationsMark.setStyle("-fx-background-radius: 1em; -fx-background-color: transparent");
                TextFlow informationsMark = new TextFlow();
                Collection certCollection = token.getCertificates().getMatches(token.getSID());
                Iterator certIt = certCollection.iterator();
                X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
                Text labelData = new Text("Data di marcatura: ");
                Text valueData = new Text();
                labelData.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
                valueData.setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                if (infoMark.getGenTime() != null) {
                    valueData.setText(String.valueOf(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(infoMark.getGenTime())) + "\n");
                } else {
                    valueData.setText("Data di marcatura: nessuna\n");
                }
                informationsMark.getChildren().addAll((Object[])new Node[]{labelData, valueData});
                Text labelSubject = new Text("\nSoggetto\n\n");
                labelSubject.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
                informationsMark.getChildren().add((Object)labelSubject);
                ArrayList<Text> valueSubject = new ArrayList<Text>();
                String[] informationsSubject = certHolder.getSubject().toString().split(",");
                int i = 0;
                while (i < informationsSubject.length) {
                    valueSubject.add(new Text("    \u2022 " + informationsSubject[i].toString() + "\n\n"));
                    ((Text)valueSubject.get(i)).setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                    informationsMark.getChildren().addAll((Object[])new Node[]{(Node)valueSubject.get(i)});
                    ++i;
                }
                Text labelPolicy = new Text("Policy: ");
                Text valuePolicy = new Text();
                labelPolicy.setStyle("-fx-font-family: Arial; -fx-font-size: 9pt");
                valuePolicy.setStyle("-fx-font-weight: bold; -fx-font-family: Arial; -fx-font-size: 9pt");
                ASN1ObjectIdentifier policy = infoMark.getPolicy();
                valuePolicy.setText(policy.getId());
                informationsMark.getChildren().addAll((Object[])new Node[]{labelPolicy, valuePolicy});
                ++numMark;
                vboxInformationsMark.getChildren().addAll((Object[])new Node[]{informationsMark});
                tpMarked.setContent((Node)vboxInformationsMark);
                accordions.getPanes().addAll((Object[])new TitledPane[]{tpMarked});
                byte[] bufferP7M = Sign.getData(bufDecoded);
                if (bufferP7M != null) {
                    this.verifyP7M(bufferP7M, accordions);
                }
                ++n2;
            }
        }
        vboxVerifySign.getChildren().addAll((Object[])new Node[]{accordions});
        accordions.setExpandedPane((TitledPane)accordions.getPanes().get(0));
        accordions.expandedPaneProperty().addListener((observable, oldPane, newPane) -> {
            Boolean expand = true;
            for (TitledPane pane : accordions.getPanes()) {
                if (!pane.isExpanded()) continue;
                expand = false;
            }
            if (expand.booleanValue() && oldPane != null) {
                Platform.runLater(() -> accordions.setExpandedPane(oldPane));
            }
        });
        return vboxVerifySign;
    }

    private static byte[] getData(byte[] pBytes) throws IOException {
        CMSSignedData cms;
        byte[] returnByte;
        byte[] bufDecoded;
        block16: {
            if (pBytes == null) {
                return null;
            }
            bufDecoded = null;
            try {
                bufDecoded = Base64.getMimeDecoder().decode(pBytes);
            }
            catch (Exception e2) {
                bufDecoded = (byte[])pBytes.clone();
            }
            returnByte = null;
            cms = new CMSSignedData(bufDecoded);
            if (cms.getSignedContent() != null) break block16;
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                cms.getSignedContent().write(out);
                returnByte = out.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CMSException e3) {
            CMSTimeStampedData cmsTsd = new CMSTimeStampedData(bufDecoded);
            if (cmsTsd.getContent() == null) {
                return null;
            }
            returnByte = cmsTsd.getContent();
        }
        return returnByte;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String extractSignAndMark(File file, Functions functions, Boolean ApplyStyleSheets) throws FileNotFoundException, IOException, CMSException {
        File fileTmp;
        File inputFile = file;
        String inputFilename = String.valueOf(functions.GeneraGUID()) + "_" + functions.getFilenameWithoutExtension(inputFile.getName());
        File pTmp = new File(functions.getPathTmp());
        if (!pTmp.exists()) {
            pTmp.mkdir();
        }
        if ((fileTmp = new File(String.valueOf(functions.getPathTmp()) + inputFilename + ".html")).exists()) {
            return String.valueOf(functions.getPathTmp()) + inputFilename + ".html";
        }
        String fileResult = "";
        Throwable throwable = null;
        Object var10_11 = null;
        try {
            FileInputStream inputFileStream = new FileInputStream(inputFile);
            try {
                byte[] result;
                byte[] buffer = new byte[(int)inputFile.length()];
                inputFileStream.read(buffer);
                inputFileStream.close();
                String tmpFile = inputFile.getName();
                String[] partOfFile = tmpFile.split("\\.");
                Integer numLoopExtract = 0;
                int i = partOfFile.length - 1;
                while (true) {
                    if (i <= 0) {
                        result = null;
                        result = Sign.getData(buffer);
                        if (result != null) break;
                        return null;
                    }
                    String itemPartOfFile = partOfFile[i].toLowerCase();
                    if (itemPartOfFile.contains("p7m") || itemPartOfFile.contains("tsd")) {
                        numLoopExtract = numLoopExtract + 1;
                    }
                    --i;
                }
                int i2 = 0;
                while (true) {
                    if (i2 >= numLoopExtract - 1) {
                        if (result != null) break;
                        return null;
                    }
                    result = Sign.getData(result);
                    ++i2;
                }
                String fileXML = String.valueOf(functions.getPathTmp()) + inputFilename + ".xml";
                Throwable throwable2 = null;
                Object var19_25 = null;
                try (FileOutputStream out = new FileOutputStream(fileXML);){
                    out.write(result);
                    out.close();
                    if (ApplyStyleSheets.booleanValue()) {
                        fileResult = functions.applyStyleSheetsXml(new File(fileXML));
                        return fileResult;
                    }
                    fileResult = fileXML;
                    return fileResult;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
            }
            finally {
                if (inputFileStream == null) return null;
                inputFileStream.close();
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }
}

