/*
 * Decompiled with CFR 0.152.
 */
package utility;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Scale;

public class ZoomingPane
extends Pane {
    Node content;
    private DoubleProperty zoomFactor = new SimpleDoubleProperty(1.0);

    public ZoomingPane(Node content, final Label labelZoomPercentage) {
        this.content = content;
        this.setStyle("-fx-background-color: white; -fx-background-radius: 5em; -fx-border-width: 1.3; -fx-border-color: #CEE3ED; -fx-border-insets: 10, 0, 10, 0; -fx-border-radius: 1em");
        this.setPadding(new Insets(5.0, 5.0, 3.0, 5.0));
        this.getChildren().addAll((Object[])new Node[]{content});
        final Scale scale = new Scale(1.0, 1.0);
        content.getTransforms().add((Object)scale);
        this.zoomFactor.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                scale.setX(newValue.doubleValue());
                scale.setY(newValue.doubleValue());
                double value = 100.0 * newValue.doubleValue() / 1.0;
                labelZoomPercentage.setText("Zoom: " + Long.toString((long)Math.floor(value + 0.5)) + "%");
                ZoomingPane.this.requestLayout();
            }
        });
    }

    protected void layoutChildren() {
        Pos pos = Pos.TOP_LEFT;
        double width = this.getWidth();
        double height = this.getHeight();
        double top = this.getInsets().getTop();
        double right = this.getInsets().getRight();
        double left = this.getInsets().getLeft();
        double bottom = this.getInsets().getBottom();
        double contentWidth = (width - left - right) / this.zoomFactor.get();
        double contentHeight = (height - top - bottom) / this.zoomFactor.get();
        this.layoutInArea(this.content, left, top, contentWidth, contentHeight, 0.0, null, pos.getHpos(), pos.getVpos());
    }

    public final Double getZoomFactor() {
        return this.zoomFactor.get();
    }

    public final void setZoomFactor(Double zoomFactor) {
        this.zoomFactor.set(zoomFactor.doubleValue());
    }

    public final DoubleProperty zoomFactorProperty() {
        return this.zoomFactor;
    }
}

